/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import simulator.algorithms.AbstractAlgorithm;
import simulator.controllers.ControllerTimer;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.AlgorithmGraphStylesheet;
import simulator.graphs.GraphCell;
import simulator.gui.TextLineNumber;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public abstract class AbstractController {
    protected Map<String, VariableObject> variables = new LinkedHashMap<String, VariableObject>();
    protected Color doneColor = Color.red;
    protected List<Instruction> tape = new LinkedList<Instruction>();
    protected int tapePosition = 0;
    protected boolean pause = false;
    protected boolean end = false;
    protected boolean interactiveMode = false;
    protected CompoundEditBlock editBlock;
    protected UndoManager undoManager = new UndoManager();
    protected Object activeVariable;
    protected Object[] registers = new Object[8];
    protected Object lastScroll;
    protected boolean scrollEnabled = true;
    protected final AbstractAlgorithm algorithm;
    protected AlgorithmGraph graph;
    protected AlgorithmGraphStylesheet stylesheet;
    protected final VisualizationPseudocodePanel completeCodePanel;
    protected final TextLineNumber codePanel;
    protected final VariablesPanel variablesPanel;
    protected AlgorithmGraphComponent graphComponent;
    protected final JLabel graphComponentLabel;
    protected mxCell selectedNode = null;
    protected final ControllerTimer timer = new ControllerTimer(0, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AbstractController.this.doNext()) {
                ((Timer)actionEvent.getSource()).stop();
            }
            if (AbstractController.this.codePanel.isDebugOnCurrentLine()) {
                AbstractController.this.timer.stop();
                AbstractController.this.codePanel.scrollToCurrentLine();
            }
        }
    });
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public AbstractController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel) {
        this.completeCodePanel = visualizationPseudocodePanel;
        this.algorithm = visualizationPseudocodePanel.getAlgorithm();
        this.graphComponentLabel = jLabel;
        this.graphComponent = algorithmGraphComponent;
        this.graph = this.graphComponent.getGraph();
        this.stylesheet = this.graph.getAlgorithmStylesheet();
        this.codePanel = visualizationPseudocodePanel.getTln();
        this.variablesPanel = variablesPanel;
        this.addAllAdjLists();
        this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

            @Override
            public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                if (graphCell.isSelected().booleanValue()) {
                    AbstractController.this.selectedNode = mxCell2;
                    return false;
                }
                return true;
            }

            @Override
            public boolean allowEdge() {
                return false;
            }
        });
        this.editBlock = new CompoundEditBlock();
        this.undoManager.setLimit(10000);
        this.timer.setRepeats(true);
    }

    private void addAllAdjLists() {
        for (Object object : this.graph.getChildVertices(this.graph.getDefaultParent())) {
            mxCell mxCell2 = (mxCell)object;
            LinkedList<mxCell> linkedList = new LinkedList<mxCell>();
            for (int i = 0; i < this.graph.getModel().getEdgeCount((Object)mxCell2); ++i) {
                mxCell mxCell3 = (mxCell)this.graph.getModel().getEdgeAt((Object)mxCell2, i);
                mxCell mxCell4 = (mxCell)mxCell3.getSource();
                mxCell mxCell5 = (mxCell)mxCell3.getTarget();
                if (mxCell4 == mxCell2 && !linkedList.contains(mxCell5)) {
                    linkedList.addFirst(mxCell5);
                    continue;
                }
                if (this.graph.isOriented() || mxCell5 != mxCell2 || linkedList.contains(mxCell4)) continue;
                linkedList.addFirst(mxCell4);
            }
            this.variablesPanel.addNodeAdjList(((GraphCell)mxCell2.getValue()).getName(), AbstractController.dequeToString(linkedList));
        }
    }

    protected void updateVariablesShow() {
        for (Map.Entry<String, VariableObject> entry : this.variables.entrySet()) {
            if (entry.getValue().isEnabled()) {
                this.variablesPanel.addVariable(entry.getKey(), entry.getValue().toString());
                continue;
            }
            this.variablesPanel.removeVariable(entry.getKey());
        }
    }

    public void resetController() {
        this.end = false;
        this.timer.stop();
        this.timer.setEnabled(true);
        this.timer.setRepeats(true);
        this.graph.resetCells();
        this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

            @Override
            public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                if (mxCell2 == AbstractController.this.selectedNode) {
                    graphCell.setSelected(true);
                } else {
                    graphCell.setSelected(false);
                }
                return true;
            }

            @Override
            public boolean allowEdge() {
                return false;
            }
        });
        this.graph.refresh();
        this.editBlock.die();
        this.editBlock = new CompoundEditBlock();
        this.undoManager.discardAllEdits();
        this.activeVariable = null;
        for (int i = 0; i < this.registers.length; ++i) {
            this.registers[i] = null;
        }
        this.lastScroll = null;
        this.pause = false;
        this.tapePosition = 0;
        this.codePanel.setCurrentLine(0);
        this.codePanel.clearAllHighlight();
        this.codePanel.clearAllhighlightStart();
        this.graph.refresh();
        this.codePanel.repaint();
        this.updateVariablesShow();
        for (Instruction instruction : this.tape) {
            instruction.stop();
        }
    }

    public void setDelay(int n) {
        this.timer.setDelay(n);
    }

    protected String getNodeName(Object object) {
        if (object == null || !(object instanceof mxCell)) {
            return "";
        }
        return ((GraphCell)((mxCell)object).getValue()).getName();
    }

    public static String dequeToString(Deque<mxCell> deque) {
        if (deque == null) {
            return "[]";
        }
        Iterator<mxCell> iterator = deque.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (true) {
            mxCell mxCell2;
            if ((mxCell2 = iterator.next()).isVertex()) {
                stringBuilder.append(((GraphCell)mxCell2.getValue()).getName());
            } else {
                mxCell mxCell3 = (mxCell)mxCell2.getSource();
                mxCell mxCell4 = (mxCell)mxCell2.getTarget();
                stringBuilder.append('(');
                stringBuilder.append(((GraphCell)mxCell3.getValue()).getName());
                stringBuilder.append(", ");
                stringBuilder.append(((GraphCell)mxCell4.getValue()).getName());
                stringBuilder.append(')');
            }
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    protected void clearGraphComponent(AlgorithmGraphComponent algorithmGraphComponent) {
        AlgorithmGraph algorithmGraph = algorithmGraphComponent.getGraph();
        for (Object object : algorithmGraph.getChildCells(algorithmGraph.getDefaultParent(), true, true)) {
            algorithmGraph.getModel().remove(object);
        }
    }

    protected boolean isDoublesEquals(double d, double d2) {
        return d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY || Math.abs(d2 - d) <= 1.0E-6;
    }

    public void setScrollEnabled(boolean bl) {
        this.scrollEnabled = bl;
    }

    public void runSimulation() {
        if (!this.timer.isEnable()) {
            this.performNext();
            this.timer.start();
        } else if (this.timer.isRunning()) {
            this.timer.stop();
        } else {
            this.timer.start();
        }
    }

    public void addTimerPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.timer.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeTimerPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.timer.removePropertyChangeListener(propertyChangeListener);
    }

    public void setTimerStart(boolean bl) {
        if (bl) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public boolean isTimerRunning() {
        return this.timer.isRunning();
    }

    protected void scrollToActive() {
        if (this.scrollEnabled && this.activeVariable instanceof mxCell && this.lastScroll != this.activeVariable) {
            this.lastScroll = this.activeVariable;
            mxCell mxCell2 = (mxCell)this.activeVariable;
            double d = mxCell2.getGeometry().getCenterX();
            double d2 = mxCell2.getGeometry().getCenterY();
            Rectangle rectangle = this.graphComponent.getViewport().getViewRect();
            Point point = new Point((int)d - rectangle.width / 2, (int)d2 - rectangle.height / 2);
            if (point.getX() < 0.0) {
                point.x = 0;
            }
            if (point.getY() < 0.0) {
                point.y = 0;
            }
            this.graphComponent.getViewport().setViewPosition(point);
        }
    }

    protected boolean nextStep() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        } else if (!this.end) {
            this.pause = false;
            while (!this.pause && this.tapePosition < this.tape.size()) {
                Instruction instruction = this.tape.get(this.tapePosition);
                if (this.interactiveMode || !instruction.isInteractive()) {
                    instruction.preform();
                    this.tapePosition = instruction.nextTapePos();
                    continue;
                }
                ++this.tapePosition;
            }
            return this.tapePosition != this.tape.size();
        }
        return this.undoManager.canRedo();
    }

    protected boolean doNext() {
        boolean bl = this.nextStep();
        this.graph.refresh();
        this.codePanel.repaint();
        this.scrollToActive();
        this.updateVariablesShow();
        return bl;
    }

    public boolean performNext() {
        this.timer.stop();
        return this.doNext();
    }

    public boolean canDoNext() {
        return this.undoManager.canRedo() || !this.end && this.tapePosition < this.tape.size();
    }

    public boolean canDoBefore() {
        if (this.tapePosition < this.tape.size() && this.tape.get(this.tapePosition).isInteractive() && this.tape.get(this.tapePosition).nextTapePos() == this.tapePosition) {
            return false;
        }
        return this.undoManager.canUndo();
    }

    protected boolean doBefore() {
        if (!this.canDoBefore()) {
            return false;
        }
        this.undoManager.undo();
        this.graph.refresh();
        this.codePanel.repaint();
        this.updateVariablesShow();
        return true;
    }

    public boolean performBefore() {
        this.timer.stop();
        return this.doBefore();
    }

    public void setInteractiveMode(boolean bl) {
        Instruction instruction;
        if (this.interactiveMode && !bl && this.tapePosition < this.tape.size() && (instruction = this.tape.get(this.tapePosition)).isInteractive()) {
            instruction.stop();
        }
        this.interactiveMode = bl;
    }

    protected void setRegisterValue(Object object, int n) {
        this.registers[n] = object;
    }

    protected Object getRegisterValue(int n) {
        return this.registers[n];
    }

    protected String getTextForLabel(String string) {
        return "<html><div style=\"text-align: center;\">" + string.replaceAll("\n", "<br>") + "</html>";
    }

    protected final class ShowOrHideVariableEdit
    extends AlgorithmUndoableEdit {
        protected boolean show;
        protected boolean showBefore;
        protected VariableObject variable;

        public ShowOrHideVariableEdit(VariableObject variableObject, boolean bl) {
            this.variable = variableObject;
            this.show = bl;
            this.showBefore = variableObject.isShow();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.variable.setShow(this.showBefore);
        }

        @Override
        protected void action() {
            this.variable.setShow(this.show);
        }
    }

    protected final class DequeueEdit
    extends AlgorithmUndoableEdit {
        protected mxCell oldActive;
        protected mxCell oldFirstInQueue;
        protected Deque<mxCell> q;

        public DequeueEdit(Deque<mxCell> deque) {
            this.q = deque;
            this.oldActive = (mxCell)AbstractController.this.activeVariable;
            this.oldFirstInQueue = this.q.getFirst();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.addFirst(this.oldFirstInQueue);
            AbstractController.this.activeVariable = this.oldActive;
        }

        @Override
        protected void action() {
            AbstractController.this.activeVariable = this.q.removeFirst();
        }
    }

    protected final class EnqueueEdit
    extends AlgorithmUndoableEdit {
        protected mxCell oldActive;
        protected Deque<mxCell> q;
        protected boolean last;

        public EnqueueEdit(Deque<mxCell> deque, boolean bl) {
            this.q = deque;
            this.last = bl;
            this.oldActive = (mxCell)AbstractController.this.activeVariable;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.remove(this.oldActive);
        }

        @Override
        protected void action() {
            if (this.last) {
                this.q.addLast(this.oldActive);
            } else {
                this.q.addFirst(this.oldActive);
            }
        }
    }

    protected final class MakeAdjListEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected mxCell oldActive;
        protected boolean oriented;

        public MakeAdjListEdit(Deque<mxCell> deque, boolean bl) {
            this.q = deque;
            this.oldActive = (mxCell)AbstractController.this.activeVariable;
            this.oriented = bl;
            this.action();
        }

        private void addAllVerticesToAdjlist(mxCell mxCell2) {
            this.q.clear();
            for (int i = 0; i < AbstractController.this.graph.getModel().getEdgeCount((Object)mxCell2); ++i) {
                mxCell mxCell3 = (mxCell)AbstractController.this.graph.getModel().getEdgeAt((Object)mxCell2, i);
                mxCell mxCell4 = (mxCell)mxCell3.getSource();
                mxCell mxCell5 = (mxCell)mxCell3.getTarget();
                if (mxCell4 == mxCell2) {
                    this.q.addFirst(mxCell5);
                    continue;
                }
                if (this.oriented || mxCell5 != mxCell2) continue;
                this.q.addFirst(mxCell4);
            }
        }

        @Override
        public void undo() {
            super.undo();
            this.q.clear();
        }

        @Override
        protected void action() {
            this.q.clear();
            this.addAllVerticesToAdjlist(this.oldActive);
        }
    }

    protected final class SetColorHighlighEdit
    extends AlgorithmUndoableEdit {
        protected int start;
        protected int end;
        protected Color c;
        protected Map<Integer, Color> lastHighlight;

        public SetColorHighlighEdit(int n, int n2, Color color) {
            this.start = n;
            this.end = n2;
            this.c = color;
            this.lastHighlight = AbstractController.this.codePanel.getAllhighlightStart();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            for (Map.Entry<Integer, Color> entry : this.lastHighlight.entrySet()) {
                AbstractController.this.codePanel.highlightLineStart(entry.getKey(), entry.getValue());
            }
        }

        @Override
        protected void action() {
            AbstractController.this.codePanel.highlightLineStartArea(this.start, this.end, this.c);
        }
    }

    protected final class ChangeEdgeStyleEdit
    extends AlgorithmUndoableEdit {
        protected mxCell edge;
        protected String newStyle;
        protected String oldStyle;

        public ChangeEdgeStyleEdit(mxCell mxCell2, String string) {
            this.edge = mxCell2;
            this.newStyle = string;
            this.oldStyle = mxCell2.getStyle();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.edge.setStyle(this.oldStyle);
        }

        @Override
        protected void action() {
            this.edge.setStyle(this.newStyle);
        }
    }

    protected final class MoveRegisterToActive
    extends AlgorithmUndoableEdit {
        protected Object oldActive;
        protected int registerNumber;

        public MoveRegisterToActive(int n) {
            this.oldActive = AbstractController.this.activeVariable;
            this.registerNumber = n;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.activeVariable = this.oldActive;
        }

        @Override
        protected void action() {
            AbstractController.this.activeVariable = AbstractController.this.registers[this.registerNumber];
        }
    }

    protected final class MoveActiveToRegister
    extends AlgorithmUndoableEdit {
        protected Object oldRegister;
        protected Object active;
        protected int registerNumber;

        public MoveActiveToRegister(int n, Object object) {
            this.oldRegister = AbstractController.this.registers[n];
            this.registerNumber = n;
            this.active = object;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.registers[this.registerNumber] = this.oldRegister;
        }

        @Override
        protected void action() {
            AbstractController.this.registers[this.registerNumber] = this.active;
        }
    }

    protected final class SetCursorEdit
    extends AlgorithmUndoableEdit {
        protected int oldPosition;
        protected int newPosition;

        public SetCursorEdit(int n) {
            this.newPosition = n;
            this.oldPosition = AbstractController.this.codePanel.getCurrentLine();
            this.action();
        }

        @Override
        protected void action() {
            AbstractController.this.codePanel.setCurrentLine(this.newPosition);
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.codePanel.setCurrentLine(this.oldPosition);
        }
    }

    protected final class SetColorEdit
    extends AlgorithmUndoableEdit {
        protected mxCell node;
        protected String oldStyle;
        protected String newStyle;

        public SetColorEdit(String string, mxCell mxCell2) {
            this.node = mxCell2;
            this.newStyle = string;
            this.oldStyle = mxCell2.getStyle();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graph.setCellStyle(this.oldStyle, new Object[]{this.node});
        }

        @Override
        protected void action() {
            AbstractController.this.graph.setCellStyle(this.newStyle, new Object[]{this.node});
        }
    }

    protected final class SetLabelTextEdit
    extends AlgorithmUndoableEdit {
        protected String oldText;
        protected String newText;

        public SetLabelTextEdit(String string) {
            this.oldText = AbstractController.this.graphComponentLabel.getText();
            this.newText = AbstractController.this.getTextForLabel(string);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graphComponentLabel.setText(this.oldText);
        }

        @Override
        protected void action() {
            AbstractController.this.graphComponentLabel.setText(this.newText);
        }
    }

    protected final class SetEnableToolTipsEdit
    extends AlgorithmUndoableEdit {
        protected GraphCell graphNode;
        protected boolean toolTips;

        public SetEnableToolTipsEdit(mxCell mxCell2) {
            this.graphNode = (GraphCell)mxCell2.getValue();
            this.toolTips = this.graphNode.isToolTipsEnabled();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setToolTipsEnabled(this.toolTips);
        }

        @Override
        protected void action() {
            this.graphNode.setToolTipsEnabled(!this.toolTips);
        }
    }

    protected final class SetNewActiveGraphEdit
    extends AlgorithmUndoableEdit {
        protected AlgorithmGraph newGraph;
        protected AlgorithmGraph oldGraph;

        public SetNewActiveGraphEdit(AlgorithmGraph algorithmGraph) {
            this.oldGraph = AbstractController.this.graph;
            this.newGraph = algorithmGraph;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graph = this.oldGraph;
        }

        @Override
        protected void action() {
            AbstractController.this.graph = this.newGraph;
        }
    }

    protected final class SetNewActiveGraphComponentEdit
    extends AlgorithmUndoableEdit {
        protected AlgorithmGraphComponent newGraph;
        protected AlgorithmGraphComponent oldGraph;

        public SetNewActiveGraphComponentEdit(AlgorithmGraphComponent algorithmGraphComponent) {
            this.oldGraph = AbstractController.this.graphComponent;
            this.newGraph = algorithmGraphComponent;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.graphComponent = this.oldGraph;
        }

        @Override
        protected void action() {
            AbstractController.this.graphComponent = this.newGraph;
        }
    }

    protected final class SetEnableEdit
    extends AlgorithmUndoableEdit {
        protected GraphCell graphNode;
        protected boolean enable;

        public SetEnableEdit(mxCell mxCell2) {
            this.graphNode = (GraphCell)mxCell2.getValue();
            this.enable = this.graphNode.isEnabled();
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.graphNode.setEnabled(this.enable);
        }

        @Override
        protected void action() {
            this.graphNode.setEnabled(!this.enable);
        }
    }

    protected class SetColorHighlighInstruction
    extends BasicInstruction {
        protected int start;
        protected int end;
        protected Color c;

        public SetColorHighlighInstruction(int n, int n2, Color color) {
            this.start = n;
            this.end = n2;
            this.c = color;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetColorHighlighEdit(this.start, this.end, this.c));
        }
    }

    protected class ShowOrHideVariableInstruction
    extends BasicInstruction {
        protected boolean show;
        protected String variable;

        public ShowOrHideVariableInstruction(String string, boolean bl) {
            this.show = bl;
            this.variable = string;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new ShowOrHideVariableEdit(AbstractController.this.variables.get(this.variable), this.show));
        }
    }

    protected class ActiveToRegisterInstruction
    extends BasicInstruction {
        protected int registerIndex;

        public ActiveToRegisterInstruction(int n) {
            this.registerIndex = n;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new MoveActiveToRegister(this.registerIndex, AbstractController.this.activeVariable));
        }
    }

    protected class SetNewActiveGraphInstruction
    extends BasicInstruction {
        protected AlgorithmGraph newGraph;
        protected AlgorithmGraphComponent newComp;

        public SetNewActiveGraphInstruction(AlgorithmGraphComponent algorithmGraphComponent) {
            this.newGraph = null;
            this.newComp = null;
            this.newComp = algorithmGraphComponent;
        }

        public SetNewActiveGraphInstruction(AlgorithmGraph algorithmGraph) {
            this.newGraph = null;
            this.newComp = null;
            this.newGraph = algorithmGraph;
        }

        @Override
        public void preform() {
            if (this.newComp == null) {
                AbstractController.this.editBlock.addEdit(new SetNewActiveGraphEdit(this.newGraph));
            } else {
                AbstractController.this.editBlock.addEdit(new SetNewActiveGraphEdit(this.newComp.getGraph()));
                AbstractController.this.editBlock.addEdit(new SetNewActiveGraphComponentEdit(this.newComp));
            }
        }
    }

    protected final class SetSelectedCellFirstEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected mxCell cell;
        protected Deque<mxCell> oldQ;

        public SetSelectedCellFirstEdit(Deque<mxCell> deque, mxCell mxCell2) {
            this.q = deque;
            this.cell = mxCell2;
            this.oldQ = new LinkedList<mxCell>();
            this.oldQ.addAll(deque);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.clear();
            this.q.addAll(this.oldQ);
        }

        @Override
        protected void action() {
            if (this.q.contains(this.cell)) {
                this.q.remove(this.cell);
                this.q.addFirst(this.cell);
            }
        }
    }

    protected class SetSelectedCellFirstInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public SetSelectedCellFirstInstruction(Deque<mxCell> deque) {
            this.q = deque;
        }

        @Override
        public void preform() {
            AbstractController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    if (graphCell.isSelected().booleanValue() && SetSelectedCellFirstInstruction.this.q.contains(mxCell2)) {
                        AbstractController.this.editBlock.addEdit(new SetSelectedCellFirstEdit(SetSelectedCellFirstInstruction.this.q, mxCell2));
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return true;
                }
            });
        }
    }

    protected class ColorEdgeActiveAndRegisterInstruction
    extends BasicInstruction {
        protected String newStyle;
        protected int registerNum;
        protected boolean oriented;

        public ColorEdgeActiveAndRegisterInstruction(int n, String string, boolean bl) {
            this.newStyle = string;
            this.registerNum = n;
            this.oriented = bl;
        }

        @Override
        public void preform() {
            for (int i = 0; i < AbstractController.this.graph.getModel().getEdgeCount(AbstractController.this.activeVariable); ++i) {
                mxCell mxCell2 = (mxCell)AbstractController.this.graph.getModel().getEdgeAt(AbstractController.this.activeVariable, i);
                mxCell mxCell3 = (mxCell)mxCell2.getTarget();
                mxCell mxCell4 = (mxCell)mxCell2.getSource();
                if (AbstractController.this.getRegisterValue(this.registerNum) == AbstractController.this.activeVariable) {
                    if (mxCell3 != AbstractController.this.activeVariable || mxCell4 != AbstractController.this.activeVariable) continue;
                    AbstractController.this.editBlock.addEdit(new ChangeEdgeStyleEdit(mxCell2, this.newStyle));
                    continue;
                }
                if (mxCell4 != AbstractController.this.getRegisterValue(this.registerNum) && (this.oriented || mxCell3 != AbstractController.this.getRegisterValue(this.registerNum))) continue;
                AbstractController.this.editBlock.addEdit(new ChangeEdgeStyleEdit(mxCell2, this.newStyle));
            }
        }
    }

    protected class RegisterToActiveInstruction
    extends BasicInstruction {
        protected int registerIndex;

        public RegisterToActiveInstruction(int n) {
            this.registerIndex = n;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new MoveRegisterToActive(this.registerIndex));
        }
    }

    protected class LabelInstruction
    extends BasicInstruction {
        protected Instruction jump;
        protected Condition condition;

        public LabelInstruction() {
            this.jump = null;
        }

        public LabelInstruction(Instruction instruction, Condition condition) {
            this.jump = instruction;
            this.condition = condition;
        }

        @Override
        public void preform() {
            if (this.jump != null && (this.condition == null || this.condition.isFulfil())) {
                new SetTapePositionInstruction(AbstractController.this.tape.indexOf(this.jump)).preform();
            }
        }
    }

    protected class SetLabelTextInstruction
    extends BasicInstruction {
        protected String text;

        public SetLabelTextInstruction(String string) {
            this.text = string;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetLabelTextEdit(this.text));
        }
    }

    protected class SetCursorInstruction
    extends BasicInstruction {
        protected int cursorPos;

        public SetCursorInstruction(int n) {
            this.cursorPos = n;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetCursorEdit(this.cursorPos));
        }
    }

    protected class SetColorInstruction
    extends BasicInstruction {
        protected String style;

        public SetColorInstruction(String string) {
            this.style = string;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetColorEdit(this.style, (mxCell)AbstractController.this.activeVariable));
        }
    }

    protected class SetTapePositionInstruction
    extends BasicInstruction {
        protected int tapePos;

        public SetTapePositionInstruction(int n) {
            this.tapePos = n;
        }

        @Override
        public void preform() {
            AbstractController.this.tapePosition = this.tapePos;
        }
    }

    protected class PauseInstruction
    extends BasicInstruction {
        protected boolean bigPause;

        protected PauseInstruction() {
            this.bigPause = false;
        }

        public PauseInstruction setBigPause(boolean bl) {
            this.bigPause = bl;
            return this;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.setLastTapeIndex(AbstractController.this.tapePosition);
            AbstractController.this.editBlock.end();
            AbstractController.this.undoManager.addEdit(AbstractController.this.editBlock);
            AbstractController.this.editBlock = new CompoundEditBlock();
            AbstractController.this.editBlock.setFirstTapeIndex(AbstractController.this.tapePosition);
            AbstractController.this.pause = true;
        }
    }

    protected class MakeAdjListInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;
        protected boolean oriented;

        public MakeAdjListInstruction(Deque<mxCell> deque, boolean bl) {
            this.q = deque;
            this.oriented = bl;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new MakeAdjListEdit(this.q, this.oriented));
        }
    }

    protected final class SetIntRegisterEdit
    extends AlgorithmUndoableEdit {
        protected Integer newValue;
        protected Integer oldValue;
        protected int registerIndex;

        public SetIntRegisterEdit(int n, Integer n2) {
            this.newValue = n2;
            this.oldValue = (Integer)AbstractController.this.getRegisterValue(n);
            this.registerIndex = n;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            AbstractController.this.setRegisterValue(this.oldValue, this.registerIndex);
        }

        @Override
        protected void action() {
            AbstractController.this.setRegisterValue(this.newValue, this.registerIndex);
        }
    }

    protected class IncIntRegisterInstruction
    extends BasicInstruction {
        protected int registerIndex;

        public IncIntRegisterInstruction(int n) {
            this.registerIndex = n;
        }

        @Override
        public void preform() {
            Integer n = (Integer)AbstractController.this.getRegisterValue(this.registerIndex) + 1;
            AbstractController.this.editBlock.addEdit(new SetIntRegisterEdit(this.registerIndex, n));
        }
    }

    protected class SetIntRegisterInstruction
    extends BasicInstruction {
        protected Integer value;
        protected int registerIndex;

        public SetIntRegisterInstruction(int n, Integer n2) {
            this.value = n2;
            this.registerIndex = n;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetIntRegisterEdit(this.registerIndex, this.value));
        }
    }

    protected final class AddAllCellToListEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected boolean vertices;
        protected boolean edges;

        public AddAllCellToListEdit(Deque<mxCell> deque, boolean bl, boolean bl2) {
            this.q = deque;
            this.vertices = bl;
            this.edges = bl2;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.q.clear();
        }

        @Override
        protected void action() {
            this.q.clear();
            AbstractController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                @Override
                public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                    if (mxCell2.isVertex() && AddAllCellToListEdit.this.vertices || mxCell2.isEdge() && AddAllCellToListEdit.this.edges) {
                        AddAllCellToListEdit.this.q.add(mxCell2);
                    }
                    return true;
                }

                @Override
                public boolean allowEdge() {
                    return AddAllCellToListEdit.this.edges;
                }
            });
        }
    }

    protected class AddAllVertexListInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public AddAllVertexListInstruction(Deque<mxCell> deque) {
            this.q = deque;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new AddAllCellToListEdit(this.q, true, false));
        }
    }

    protected class AddAllEdgesListInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public AddAllEdgesListInstruction(Deque<mxCell> deque) {
            this.q = deque;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new AddAllCellToListEdit(this.q, false, true));
        }
    }

    protected class DequeueInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public DequeueInstruction(Deque<mxCell> deque) {
            this.q = deque;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new DequeueEdit(this.q));
        }
    }

    protected class EnqueueInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public EnqueueInstruction(Deque<mxCell> deque) {
            this.q = deque;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new EnqueueEdit(this.q, true));
        }
    }

    protected class PushInstruction
    extends BasicInstruction {
        protected Deque<mxCell> s;

        public PushInstruction(Deque<mxCell> deque) {
            this.s = deque;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new EnqueueEdit(this.s, false));
        }
    }

    protected final class ClearQueueEdit
    extends AlgorithmUndoableEdit {
        protected Deque<mxCell> q;
        protected Deque<mxCell> oldQ;

        public ClearQueueEdit(Deque<mxCell> deque) {
            this.q = deque;
            this.oldQ = new LinkedList<mxCell>();
            this.oldQ.addAll(deque);
            this.action();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.q.clear();
            this.q.addAll(this.oldQ);
        }

        @Override
        protected void action() {
            this.q.clear();
        }
    }

    protected class ClearQueueInstruction
    extends BasicInstruction {
        protected Deque<mxCell> q;

        public ClearQueueInstruction(Deque<mxCell> deque) {
            this.q = deque;
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new ClearQueueEdit(this.q));
        }
    }

    protected class SetVertexToolTipsInstruction
    extends BasicInstruction {
        protected SetVertexToolTipsInstruction() {
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetEnableToolTipsEdit((mxCell)AbstractController.this.activeVariable));
        }
    }

    protected class SetVertexEnableInstruction
    extends BasicInstruction {
        protected SetVertexEnableInstruction() {
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetEnableEdit((mxCell)AbstractController.this.activeVariable));
        }
    }

    protected class SelectStartNodeInstruction
    extends InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;

        public SelectStartNodeInstruction() {
            this.adapter = new SelectCellsMouseAdapter(1, AbstractController.this.graphComponent, AbstractController.this.graph);
            this.adapter.setActivated(false);
            AbstractController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        @Override
        public void preform() {
            AbstractController.this.graphComponentLabel.setText(AbstractController.this.getTextForLabel("Vyber po\u010d\u00e1te\u010dn\u00ed uzel a klikni pokra\u010dovat\n[u\u017eivatelsk\u00e1 akce]"));
            if (!this.adapter.isActivated()) {
                AbstractController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else if (this.adapter.getLastSelected() != null) {
                AbstractController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                    @Override
                    public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                        if (mxCell2 == SelectStartNodeInstruction.this.adapter.getLastSelected()) {
                            graphCell.setSelected(true);
                        } else {
                            graphCell.setSelected(false);
                        }
                        return true;
                    }

                    @Override
                    public boolean allowEdge() {
                        return false;
                    }
                });
                this.stop();
                return;
            }
            AbstractController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return AbstractController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                AbstractController.this.timer.setEnabled(true);
            }
        }
    }

    protected class EndInstruction
    extends BasicInstruction {
        protected EndInstruction() {
        }

        @Override
        public void preform() {
            AbstractController.this.editBlock.addEdit(new SetCursorEdit(0));
            AbstractController.this.editBlock.setLastTapeIndex(AbstractController.this.tapePosition);
            AbstractController.this.editBlock.end();
            AbstractController.this.undoManager.addEdit(AbstractController.this.editBlock);
            AbstractController.this.pause = true;
            AbstractController.this.end = true;
        }

        @Override
        public int nextTapePos() {
            return AbstractController.this.tape.size();
        }
    }

    protected static interface Condition {
        public boolean isFulfil();
    }

    protected abstract class BasicInstruction
    implements Instruction {
        protected BasicInstruction() {
        }

        @Override
        public boolean isInteractive() {
            return false;
        }

        @Override
        public int nextTapePos() {
            return AbstractController.this.tapePosition + 1;
        }

        @Override
        public void stop() {
        }
    }

    protected abstract class InteractiveInstruction
    implements Instruction {
        protected InteractiveInstruction() {
        }

        @Override
        public boolean isInteractive() {
            return true;
        }

        @Override
        public int nextTapePos() {
            return AbstractController.this.tapePosition + 1;
        }
    }

    public class CompoundEditBlock
    extends CompoundEdit {
        protected int firstTapeIndex;
        protected int lastTapeIndex;

        public int getFirstTapeIndex() {
            return this.firstTapeIndex;
        }

        public void setFirstTapeIndex(int n) {
            this.firstTapeIndex = n;
        }

        public int getLastTapeIndex() {
            return this.lastTapeIndex;
        }

        public void setLastTapeIndex(int n) {
            this.lastTapeIndex = n;
        }
    }

    public static abstract class AlgorithmUndoableEdit
    extends AbstractUndoableEdit {
        protected abstract void action();

        @Override
        public void redo() {
            super.redo();
            this.action();
        }
    }

    public static interface Instruction {
        public void preform();

        public void stop();

        public int nextTapePos();

        public boolean isInteractive();
    }
}

