/*
 * Decompiled with CFR 0.152.
 */
package simulator.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import simulator.algorithms.AlgorithmBase;

public abstract class AbstractAlgorithm
extends DefaultStyledDocument {
    protected AlgorithmBase algorithmBase = new AlgorithmBase();
    protected String algorithmName;
    protected List<AlgorithmBase.AlgorithmElement[]> algorithmParts = new ArrayList<AlgorithmBase.AlgorithmElement[]>();
    protected ArrayList<DefaultStyledDocument.ElementSpec> batch;
    protected int lineNumberCount = 0;

    protected DefaultStyledDocument.ElementSpec createSpecStart(AttributeSet attributeSet, short s) {
        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 1);
        elementSpec.setDirection(s);
        return elementSpec;
    }

    protected DefaultStyledDocument.ElementSpec createSpecEnd() {
        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(null, 2);
        return elementSpec;
    }

    protected DefaultStyledDocument.ElementSpec createContent(AttributeSet attributeSet, String string, short s) {
        DefaultStyledDocument.ElementSpec elementSpec = new DefaultStyledDocument.ElementSpec(attributeSet, 3, string.toCharArray(), 0, string.length());
        elementSpec.setDirection(s);
        return elementSpec;
    }

    protected void addEmtyLine() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute("lineNum", 0);
        simpleAttributeSet.addAttribute("line", 0);
        simpleAttributeSet.addAttributes(this.algorithmBase.getAlgorithmsStyle("AlgorithmHeading"));
        this.batch.add(this.createSpecStart(simpleAttributeSet, (short)6));
        this.batch.add(this.createContent(SimpleAttributeSet.EMPTY, "\n", (short)6));
        this.batch.add(this.createSpecEnd());
    }

    protected void addLine(AlgorithmBase.AlgorithmContent[] algorithmContentArray) {
        for (AlgorithmBase.AlgorithmContent algorithmContent : algorithmContentArray) {
            AttributeSet attributeSet = algorithmContent.getStyleName() == null ? SimpleAttributeSet.EMPTY : this.algorithmBase.getAlgorithmsStyle(algorithmContent.getStyleName());
            this.batch.add(this.createContent(attributeSet, algorithmContent.getContent(), (short)6));
        }
        this.batch.add(this.createContent(null, "\n", (short)6));
    }

    protected int addAlgorithmPart(AlgorithmBase.AlgorithmElement[] algorithmElementArray, int n) {
        int n2 = 0;
        for (AlgorithmBase.AlgorithmElement algorithmElement : algorithmElementArray) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute("lineNum", n2);
            simpleAttributeSet.addAttribute("line", ++n);
            if (algorithmElement.getStyleName() != null) {
                simpleAttributeSet.addAttributes(this.algorithmBase.getAlgorithmsStyle(algorithmElement.getStyleName()));
            }
            this.batch.add(this.createSpecStart(simpleAttributeSet, (short)6));
            this.addLine(algorithmElement.getContentArray());
            this.batch.add(this.createSpecEnd());
            ++n2;
        }
        return n;
    }

    protected void addAlgorithm() {
        this.batch = new ArrayList();
        this.batch.add(this.createSpecEnd());
        int n = 0;
        for (AlgorithmBase.AlgorithmElement[] algorithmElementArray : this.algorithmParts) {
            n = this.addAlgorithmPart(algorithmElementArray, n);
            this.addEmtyLine();
        }
        DefaultStyledDocument.ElementSpec[] elementSpecArray = new DefaultStyledDocument.ElementSpec[this.batch.size()];
        this.batch.toArray(elementSpecArray);
        try {
            this.insert(0, elementSpecArray);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(AbstractAlgorithm.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        this.lineNumberCount = n;
    }

    public int getBeforeRealLine(int n) {
        if (n - 1 < 0) {
            return this.lineNumberCount;
        }
        return (n - 1) % (this.lineNumberCount + 1);
    }

    public int getNextRealLine(int n) {
        return (n + 1) % (this.lineNumberCount + 1);
    }

    public int getRealLineNumber(int n, int n2) {
        n2 %= this.algorithmParts.get(n %= this.algorithmParts.size()).length;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += this.algorithmParts.get(i).length;
        }
        return n3 + n2 + 1;
    }

    public int getNumberOfAlgorithms() {
        return this.algorithmParts.size();
    }

    public int getNumberOfAlgorithmLine(int n) {
        return this.algorithmParts.get(n).length;
    }
}

