/*
 * Decompiled with CFR 0.152.
 */
package program;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import editor.EditorGraph;
import editor.EditorUndoManager;
import editor.GraphViewPanel;
import editor.InformationPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.logging.log4j.LogManager;
import program.Program;
import program.actions.ActionLogger;
import program.actions.BasicActions;

public final class MainPanel
extends JPanel {
    private static org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)MainPanel.class.getSimpleName());
    protected GraphViewPanel graphPanel;
    protected EditorUndoManager editorUndoManager;
    protected boolean modified = false;
    protected File currentFile;
    protected mxEventSource.mxIEventListener changeTracker = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            MainPanel.this.setModified(true);
        }
    };

    public MainPanel() {
        this.setLayout(new GridLayout(0, 1));
        JSplitPane jSplitPane = new JSplitPane(1);
        this.add(jSplitPane);
        this.graphPanel = new GraphViewPanel();
        this.graphPanel.getGraph().getModel().addListener("change", this.changeTracker);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.bindGraphAction(mxResources.get((String)"EdgesLabel"), new ActionLogger(new BasicActions.HideEdgeLabelAction())));
        jCheckBoxMenuItem.setState(true);
        jPopupMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem(this.bindGraphAction(mxResources.get((String)"VerticesLabel"), new ActionLogger(new BasicActions.HideVertexLabelAction())));
        jCheckBoxMenuItem.setState(true);
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(this.bindGraphAction(mxResources.get((String)"ParallelLayout"), new ActionLogger(new BasicActions.ParallelEdgeLabelAction())));
        jPopupMenu.add(jMenuItem);
        this.graphPanel.getGraphComponent().getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.editorUndoManager = new EditorUndoManager(this.graphPanel.getGraph());
        jSplitPane.setLeftComponent(new InformationPanel(this.graphPanel));
        jSplitPane.setRightComponent((Component)this.graphPanel.getGraphComponent());
        jSplitPane.setResizeWeight(0.3);
        jSplitPane.setDividerLocation(250);
    }

    public EditorUndoManager getEditorUndoManager() {
        return this.editorUndoManager;
    }

    protected Action bindImpl(final Object object, String string, final Action action, String string2) {
        logger.entry(new Object[]{object, string, action, string2});
        AbstractAction abstractAction = new AbstractAction(string, string2 != null ? new ImageIcon(Program.class.getResource(string2)) : null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                action.actionPerformed(new ActionEvent(object, actionEvent.getID(), actionEvent.getActionCommand()));
            }
        };
        abstractAction.putValue("ShortDescription", action.getValue("ShortDescription"));
        return (Action)logger.exit((Object)abstractAction);
    }

    public Action bind(String string, Action action) {
        return this.bind(string, action, null);
    }

    public Action bind(String string, Action action, String string2) {
        logger.entry(new Object[]{string, action, string2});
        return (Action)logger.exit((Object)this.bindImpl(this, string, action, string2));
    }

    public Action bindGraphAction(String string, Action action) {
        return this.bindGraphAction(string, action, null);
    }

    public Action bindGraphAction(String string, Action action, String string2) {
        logger.entry(new Object[]{string, action, string2});
        return (Action)logger.exit((Object)this.bindImpl(this.getGraphComponent(), string, action, string2));
    }

    public void setLookAndFeel(String string) {
        logger.entry(new Object[]{string});
        if (string.equals(UIManager.getLookAndFeel().getName())) {
            return;
        }
        JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(this);
        assert (jFrame != null);
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(jFrame);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, exception);
        }
        logger.exit();
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphPanel.getGraphComponent();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        boolean bl2 = this.modified;
        this.modified = bl;
        if (bl2 != bl) {
            this.updateTitle();
        }
    }

    public void updateTitle() {
        JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(this);
        if (jFrame != null) {
            String string;
            String string2 = string = this.currentFile != null ? this.currentFile.getAbsolutePath() : mxResources.get((String)"newDiagram");
            if (this.modified) {
                string = string + "*";
            }
            jFrame.setTitle(string + " - " + mxResources.get((String)"mainTitle"));
        }
    }

    public EditorGraph getGraph() {
        return this.graphPanel.getGraph();
    }

    public void setGraph(mxGraph mxGraph2) {
        this.graphPanel.setGraph(mxGraph2);
    }

    public void setCurrentFile(File file) {
        File file2 = this.currentFile;
        this.currentFile = file;
        this.firePropertyChange("currentFile", file2, file);
        if (file2 != file) {
            this.updateTitle();
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public GraphViewPanel getGraphPanel() {
        return this.graphPanel;
    }
}

