/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import program.MainPanel;
import simulator.graphs.BasicStylesheet;

public class StyleDialogMaker {
    private StyleDialogMaker() {
    }

    public static StyleDialog getStyleDialog(JFrame jFrame, final MainPanel mainPanel) {
        final mxGraph mxGraph2 = new mxGraph();
        mxGraph2.setStylesheet((mxStylesheet)BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet()));
        final StyleDialog styleDialog = new StyleDialog((Frame)jFrame, true, mxGraph2);
        mxGraphComponent mxGraphComponent2 = new mxGraphComponent(mxGraph2);
        mxGraphComponent2.setDragEnabled(false);
        mxGraph2.setAllowDanglingEdges(false);
        mxGraph2.setAllowNegativeCoordinates(false);
        mxGraph2.setCellsDeletable(false);
        mxGraph2.setCellsEditable(false);
        mxGraph2.setCellsDisconnectable(false);
        mxGraphComponent2.getViewport().setBackground(Color.WHITE);
        mxGraphComponent2.setBackground(Color.WHITE);
        Set<String> set = BasicStylesheet.getAllStyles();
        final Object object = mxGraph2.insertVertex(mxGraph2.getDefaultParent(), null, (Object)"Style", 20.0, 50.0, 80.0, 80.0, "VERTEX_STYLE");
        Object object2 = mxGraph2.insertVertex(mxGraph2.getDefaultParent(), null, (Object)"V Style", 300.0, 50.0, 80.0, 80.0, "VERTEX_STYLE");
        final Object object3 = mxGraph2.insertEdge(mxGraph2.getDefaultParent(), null, (Object)"100", object, object2, "EDGE_STYLE");
        mxGraph2.refresh();
        set.remove("defaultVertex");
        set.remove("defaultEdge");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        final JTextField jTextField = new JTextField();
        final JComboBox<String> jComboBox = new JComboBox<String>(set.toArray(new String[0]));
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.func();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.func();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.func();
            }

            public void func() {
                Map map = mxGraph2.getStylesheet().getStyles();
                map.put(jComboBox.getSelectedItem().toString(), BasicStylesheet.stringToStyle(jTextField.getText()));
                mxGraph2.refresh();
            }
        });
        jComboBox.setToolTipText(BasicStylesheet.getDesc(jComboBox.getSelectedItem().toString()));
        if (BasicStylesheet.isVertexStyle(jComboBox.getSelectedItem().toString())) {
            ((mxCell)object).setStyle(jComboBox.getSelectedItem().toString());
        } else if (BasicStylesheet.isEdgeStyle(jComboBox.getSelectedItem().toString())) {
            ((mxCell)object3).setStyle(jComboBox.getSelectedItem().toString());
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jComboBox.getSelectedItem().toString();
                ((mxCell)object).setStyle("VERTEX_STYLE");
                ((mxCell)object3).setStyle("EDGE_STYLE");
                if (BasicStylesheet.isVertexStyle(string)) {
                    ((mxCell)object).setStyle(string);
                } else if (BasicStylesheet.isEdgeStyle(string)) {
                    ((mxCell)object3).setStyle(string);
                }
                jComboBox.setToolTipText(BasicStylesheet.getDesc(string));
                jTextField.setText(BasicStylesheet.styleToString((Map)mxGraph2.getStylesheet().getStyles().get(string)));
                mxGraph2.refresh();
            }
        });
        jTextField.setText(BasicStylesheet.styleToString((Map)mxGraph2.getStylesheet().getStyles().get(jComboBox.getSelectedItem().toString())));
        jPanel2.add(jComboBox, "West");
        jPanel2.add((Component)jTextField, "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)mxGraphComponent2, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        JButton jButton = new JButton("Reset");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mxGraph2.setStylesheet((mxStylesheet)BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet()));
                jTextField.setText(BasicStylesheet.styleToString((Map)mxGraph2.getStylesheet().getStyles().get(jComboBox.getSelectedItem().toString())));
                mxGraph2.refresh();
            }
        });
        JButton jButton2 = new JButton("Save");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mainPanel.getGraph().setStylesheet(BasicStylesheet.getFromMxStylesheet(mxGraph2.getStylesheet()));
                mainPanel.getGraph().refresh();
                styleDialog.setVisible(false);
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, "South");
        styleDialog.getContentPane().add(jPanel);
        styleDialog.setResizable(true);
        styleDialog.setSize(450, 300);
        styleDialog.setLocationRelativeTo((Component)mainPanel.getGraphComponent());
        return styleDialog;
    }

    public static class StyleDialog
    extends JDialog {
        private mxGraph graph;

        public StyleDialog(Frame frame, boolean bl, mxGraph mxGraph2) {
            super(frame, bl);
            this.graph = mxGraph2;
        }

        public void setStyles(mxStylesheet mxStylesheet2) {
            this.graph.setStylesheet((mxStylesheet)BasicStylesheet.getFromMxStylesheet(mxStylesheet2));
            this.graph.refresh();
        }
    }
}

