/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.mxgraph.io.mxCodec;
import com.mxgraph.io.mxStylesheetCodec;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphStylesheet;
import simulator.graphs.BasicStylesheet;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.GraphVertexData;

public class GraphIO {
    private GraphIO() {
    }

    public static mxGraph getClonedGraph(mxGraph mxGraph2) {
        mxGraph mxGraph3 = new mxGraph();
        mxStylesheet mxStylesheet2 = mxGraph2.getStylesheet();
        mxGraph3.addCells(mxGraph2.cloneCells(mxGraph2.getChildCells(mxGraph2.getDefaultParent())));
        for (Object object : mxGraphModel.getChildren((mxIGraphModel)mxGraph3.getModel(), (Object)mxGraph3.getDefaultParent())) {
            if (!(object instanceof mxCell)) continue;
            mxCell mxCell2 = (mxCell)object;
            if (mxCell2.getValue() != null && (mxCell2.getValue() instanceof GraphVertexBasicData || mxCell2.getValue() instanceof GraphEdgeBasicData)) {
                if (mxCell2.isVertex()) {
                    mxCell2.setValue((Object)((GraphVertexBasicData)mxCell2.getValue()).getBasicVertexData());
                } else {
                    mxCell2.setValue((Object)((GraphEdgeBasicData)mxCell2.getValue()).getBasicEdgeData());
                }
            } else if (mxCell2.isVertex()) {
                mxCell2.setValue((Object)new GraphVertexData());
            } else {
                mxCell2.setValue((Object)new GraphEdgeData());
            }
            if (!(mxStylesheet2 instanceof AlgorithmGraphStylesheet)) continue;
            AlgorithmGraphStylesheet algorithmGraphStylesheet = (AlgorithmGraphStylesheet)mxStylesheet2;
            mxCell2.setStyle(mxCell2.isVertex() ? algorithmGraphStylesheet.getVertexStyle() : algorithmGraphStylesheet.getEdgeStyle());
        }
        return mxGraph3;
    }

    public static void writeGraph(mxGraph mxGraph2, Path path) throws IOException {
        mxGraph mxGraph3 = GraphIO.getClonedGraph(mxGraph2);
        try {
            mxStylesheetCodec mxStylesheetCodec2 = new mxStylesheetCodec();
            mxCodec mxCodec2 = new mxCodec();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("graph");
            document.appendChild(element);
            element.appendChild(document.importNode(mxCodec2.encode((Object)mxGraph3.getModel()), true));
            element.appendChild(document.importNode(mxStylesheetCodec2.encode(mxCodec2, (Object)mxGraph2.getStylesheet()), true));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource dOMSource = new DOMSource(document);
            transformer.transform(dOMSource, streamResult);
            String string = streamResult.getWriter().toString();
            try (FileWriter fileWriter = new FileWriter(path.toFile());){
                fileWriter.write(string);
                fileWriter.flush();
            }
        }
        catch (ParserConfigurationException | TransformerException exception) {
            Logger.getLogger(GraphIO.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public static AlgorithmGraph readGraph(Path path) throws IOException, SAXException, ParserConfigurationException, GraphIOBadXmlException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(path.toFile());
        if (document == null) {
            throw new GraphIOBadXmlException();
        }
        Node node = document.getDocumentElement().getElementsByTagName("mxGraphModel").item(0);
        Node node2 = document.getDocumentElement().getElementsByTagName("mxStylesheet").item(0);
        if (node == null || node2 == null) {
            throw new GraphIOBadXmlException();
        }
        mxStylesheetCodec mxStylesheetCodec2 = new mxStylesheetCodec();
        mxCodec mxCodec2 = new mxCodec();
        AlgorithmGraph algorithmGraph = new AlgorithmGraph();
        mxStylesheet mxStylesheet2 = (mxStylesheet)mxStylesheetCodec2.decode(mxCodec2, node2);
        BasicStylesheet basicStylesheet = BasicStylesheet.getFromMxStylesheet(mxStylesheet2);
        algorithmGraph.setOriented(basicStylesheet.isDirectedEgeStyle());
        algorithmGraph.setModel((mxIGraphModel)mxCodec2.decode(node));
        algorithmGraph.setStylesheet(basicStylesheet);
        return algorithmGraph;
    }

    public static class GraphIOBadXmlException
    extends Exception {
        public GraphIOBadXmlException() {
            super(mxResources.get((String)"BadXmlException"));
        }
    }
}

