/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexData;

public class EditorGraph
extends mxGraph {
    protected boolean vertexLabel = true;
    protected boolean edgeLabel = true;

    public EditorGraph(mxStylesheet mxStylesheet2) {
        super(mxStylesheet2);
    }

    public boolean isVertexLabel() {
        return this.vertexLabel;
    }

    public void setVertexLabel(boolean bl) {
        this.vertexLabel = bl;
    }

    public boolean isEdgeLabel() {
        return this.edgeLabel;
    }

    public void setEdgeLabel(boolean bl) {
        this.edgeLabel = bl;
    }

    public String getToolTipForCell(Object object) {
        GraphVertexData graphVertexData;
        mxCell mxCell2 = (mxCell)object;
        if (mxCell2.isVertex() && (graphVertexData = (GraphVertexData)mxCell2.getValue()).getSelected().booleanValue()) {
            return mxResources.get((String)"selected");
        }
        return null;
    }

    public String convertValueToString(Object object) {
        if (object instanceof mxCell) {
            if (((mxCell)object).isVertex() && !this.vertexLabel || ((mxCell)object).isEdge() && !this.edgeLabel) {
                return "";
            }
            Object object2 = ((mxCell)object).getValue();
            if (this.vertexLabel && object2 instanceof GraphVertexData) {
                GraphVertexData graphVertexData = (GraphVertexData)object2;
                return graphVertexData.getName();
            }
            if (this.edgeLabel && object2 instanceof GraphEdgeData) {
                GraphEdgeData graphEdgeData = (GraphEdgeData)object2;
                return new DecimalFormat("#").format(graphEdgeData.getDistance());
            }
        }
        return super.convertValueToString(object);
    }

    public boolean isVertexLabelsMovable() {
        return false;
    }

    public boolean isEdgeLabelsMovable() {
        return false;
    }

    public boolean isCellEditable(Object object) {
        mxCell mxCell2 = (mxCell)object;
        if (this.vertexLabel && mxCell2.isVertex() || this.edgeLabel && mxCell2.isEdge()) {
            return super.isCellEditable(object);
        }
        return false;
    }

    public boolean containCellName(String string, mxCell mxCell2) {
        for (Object object : this.getChildVertices(this.getDefaultParent())) {
            GraphVertexData graphVertexData = (GraphVertexData)((mxCell)object).getValue();
            if (object == mxCell2 || !graphVertexData.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void cellLabelChanged(Object object, Object object2, boolean bl) {
        this.model.beginUpdate();
        if (bl) {
            this.cellSizeUpdated(object, false);
        }
        String string = (String)object2;
        if (this.vertexLabel && ((mxCell)object).isVertex()) {
            GraphVertexData graphVertexData = (GraphVertexData)((mxCell)object).getValue();
            this.getModel().setValue(object, (Object)new GraphVertexData((String)object2, graphVertexData.isSelected()));
        } else if (this.edgeLabel) {
            GraphEdgeData graphEdgeData = new GraphEdgeData();
            if (string.contains("\u221e") || string.contains("inf")) {
                graphEdgeData.setDistance(Double.POSITIVE_INFINITY);
            } else {
                Pattern pattern = Pattern.compile("-?\\d+");
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    double d = Double.parseDouble(matcher.group());
                    graphEdgeData.setDistance(d);
                }
            }
            this.getModel().setValue(object, (Object)graphEdgeData);
        }
        this.getSelectionModel().clear();
        this.fireEvent(new mxEventObject("labelChanged"));
        this.model.endUpdate();
    }

    public boolean isAllowDanglingEdges() {
        return false;
    }

    public boolean isAllowLoops() {
        return true;
    }

    public boolean isAllowNegativeCoordinates() {
        return false;
    }

    public boolean isOriented() {
        String string = (String)((Map)this.getStylesheet().getStyles().get("EDGE_STYLE")).get(mxConstants.STYLE_ENDARROW);
        return !string.equalsIgnoreCase(mxConstants.NONE);
    }
}

