/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="TimeBasedTriggeringPolicy", type="Core", printObject=true)
public final class TimeBasedTriggeringPolicy
implements TriggeringPolicy {
    private long nextRollover;
    private final int interval;
    private final boolean modulate;
    private RollingFileManager manager;

    private TimeBasedTriggeringPolicy(int interval, boolean modulate) {
        this.interval = interval;
        this.modulate = modulate;
    }

    public void initialize(RollingFileManager manager) {
        this.manager = manager;
        this.nextRollover = manager.getProcessor().getNextTime(manager.getFileTime(), this.interval, this.modulate);
    }

    public boolean isTriggeringEvent(LogEvent event) {
        if (this.manager.getFileSize() == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now > this.nextRollover) {
            this.nextRollover = this.manager.getProcessor().getNextTime(now, this.interval, this.modulate);
            return true;
        }
        return false;
    }

    public String toString() {
        return "TimeBasedTriggeringPolicy";
    }

    @PluginFactory
    public static TimeBasedTriggeringPolicy createPolicy(@PluginAttr(value="interval") String interval, @PluginAttr(value="modulate") String modulate) {
        int increment = interval == null ? 1 : Integer.parseInt(interval);
        boolean mod = modulate == null ? false : Boolean.parseBoolean(modulate);
        return new TimeBasedTriggeringPolicy(increment, mod);
    }
}

