/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

@Plugin(name="ThrowablePatternConverter", type="Converter")
@ConverterKeys(value={"ex", "throwable", "exception"})
public class ThrowablePatternConverter
extends LogEventPatternConverter {
    protected static final String NONE = "none";
    protected static final String FULL = "full";
    protected static final String SHORT = "short";
    protected final String option;
    protected final int lines;

    protected ThrowablePatternConverter(String name, String style, String[] options) {
        super(name, style);
        int count = Integer.MAX_VALUE;
        if (options != null && options.length > 0) {
            this.option = options[0];
            if (this.option != null) {
                if (this.option.equalsIgnoreCase(NONE)) {
                    count = 0;
                } else if (this.option.equalsIgnoreCase(SHORT)) {
                    count = 2;
                } else if (!this.option.equalsIgnoreCase(FULL)) {
                    count = Integer.parseInt(this.option);
                }
            }
        } else {
            this.option = null;
        }
        this.lines = count;
    }

    public static ThrowablePatternConverter newInstance(String[] options) {
        return new ThrowablePatternConverter("Throwable", "throwable", options);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        Throwable t = event.getThrown();
        if (t != null && this.lines > 0) {
            StringWriter w = new StringWriter();
            t.printStackTrace(new PrintWriter(w));
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(" ");
            }
            if (this.lines != Integer.MAX_VALUE) {
                StringBuilder sb = new StringBuilder();
                String[] array = w.toString().split("\n");
                int limit = this.lines > array.length ? array.length : this.lines;
                for (int i = 0; i < limit; ++i) {
                    sb.append(array[i]).append("\n");
                }
                toAppendTo.append(sb.toString());
            } else {
                toAppendTo.append(w.toString());
            }
        }
    }

    public boolean handlesThrowable() {
        return true;
    }
}

