/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="File", type="Core", elementType="appender", printObject=true)
public final class FileAppender
extends AbstractOutputStreamAppender {
    private final String fileName;

    private FileAppender(String name, Layout layout, Filter filter, FileManager manager, String filename, boolean handleException, boolean immediateFlush) {
        super(name, layout, filter, handleException, immediateFlush, manager);
        this.fileName = filename;
    }

    public String getFileName() {
        return this.fileName;
    }

    @PluginFactory
    public static FileAppender createAppender(@PluginAttr(value="fileName") String fileName, @PluginAttr(value="append") String append, @PluginAttr(value="locking") String locking, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginAttr(value="suppressExceptions") String suppress, @PluginAttr(value="bufferedIO") String bufferedIO, @PluginElement(value="layout") Layout layout, @PluginElement(value="filters") Filter filter) {
        boolean handleExceptions;
        boolean isBuffered;
        boolean isAppend = append == null ? true : Boolean.valueOf(append);
        boolean isLocking = locking == null ? false : Boolean.valueOf(locking);
        boolean bl = isBuffered = bufferedIO == null ? true : Boolean.valueOf(bufferedIO);
        if (isLocking && isBuffered) {
            if (bufferedIO != null) {
                LOGGER.warn("Locking and buffering are mutually exclusive. No buffereing will occur for " + fileName);
            }
            isBuffered = false;
        }
        boolean isFlush = immediateFlush == null ? true : Boolean.valueOf(immediateFlush);
        boolean bl2 = handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        if (name == null) {
            LOGGER.error("No name provided for FileAppender");
            return null;
        }
        if (fileName == null) {
            LOGGER.error("No filename provided for FileAppender with name " + name);
            return null;
        }
        FileManager manager = FileManager.getFileManager(fileName, isAppend, isLocking, isBuffered);
        if (manager == null) {
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null);
        }
        return new FileAppender(name, layout, filter, manager, fileName, handleExceptions, isFlush);
    }
}

