/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui.panels;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import java.awt.BorderLayout;
import java.awt.Component;
import simulator.algorithms.AlgorithmDfs;
import simulator.controllers.DfsController;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.dfs.DfsGraphEdge;
import simulator.graphs.dfs.DfsGraphVertex;
import simulator.gui.AbstractSimulatorPanel;
import simulator.gui.panels.AbstractAlgorithmPanel;

public class DfsPanel
extends AbstractAlgorithmPanel {
    protected AbstractSimulatorPanel simulatorPanel;

    public DfsPanel(AlgorithmGraph algorithmGraph) {
        this.makeDfsGraph(algorithmGraph);
        algorithmGraph.refresh();
        algorithmGraph.setOriented(algorithmGraph.getAlgorithmStylesheet().isDirectedEgeStyle());
        this.setLayout(new BorderLayout());
        this.simulatorPanel = new AbstractSimulatorPanel(algorithmGraph, new AlgorithmDfs());
        this.simulatorPanel.getGraphPanel().add((Component)((Object)this.simulatorPanel.getGraphComponent()), "Center");
        DfsController dfsController = new DfsController(this.simulatorPanel.getGraphComponent(), this.simulatorPanel.getLabel(), this.simulatorPanel.getCodePanel(), this.simulatorPanel.getVariablesPanel());
        this.simulatorPanel.setController(dfsController);
        this.add((Component)this.simulatorPanel, "Center");
    }

    @Override
    public void stop() {
        this.simulatorPanel.getVariablesPanel().dockTables();
        this.simulatorPanel.getController().setTimerStart(false);
    }

    private void makeDfsGraph(AlgorithmGraph algorithmGraph) {
        for (Object object : mxGraphModel.getChildren((mxIGraphModel)algorithmGraph.getModel(), (Object)algorithmGraph.getDefaultParent())) {
            if (!(object instanceof mxCell)) continue;
            mxCell mxCell2 = (mxCell)object;
            if (mxCell2.isVertex()) {
                if (mxCell2.getValue() == null || !(mxCell2.getValue() instanceof GraphVertexBasicData)) {
                    throw new IllegalArgumentException();
                }
                if (!(mxCell2.getValue() instanceof DfsGraphVertex)) {
                    GraphVertexBasicData graphVertexBasicData = (GraphVertexBasicData)mxCell2.getValue();
                    mxCell2.setValue((Object)new DfsGraphVertex(graphVertexBasicData.getName(), graphVertexBasicData.isSelected()));
                }
                mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getVertexStyle());
                continue;
            }
            if (mxCell2.getValue() != null && !(mxCell2.getValue() instanceof GraphEdgeBasicData)) {
                throw new IllegalArgumentException();
            }
            mxCell2.setValue((Object)new DfsGraphEdge());
            mxCell2.setStyle(algorithmGraph.getAlgorithmStylesheet().getEdgeStyle());
        }
    }
}

