/*
 * Decompiled with CFR 0.152.
 */
package simulator.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import simulator.gui.LineHighlighter;

public class TextLineNumber
extends JPanel
implements MouseListener {
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float RIGHT = 1.0f;
    public static final Color defaultHighlightColor = Color.decode("#BBFFFF");
    private static final Border OUTER = new MatteBorder(0, 0, 0, 2, Color.GRAY);
    private static final int HEIGHT = 2146483647;
    private JTextComponent component;
    private int borderGap;
    private Color currentLineForeground;
    private float digitAlignment;
    private int minimumDisplayDigits;
    private int currentLine;
    private int lastPrintedLine;
    private Set<Integer> debugLinesSet = new HashSet<Integer>();
    private int lastDigits;
    private int lastHeight;
    private Element actualLineElement;
    int lastCurrentLine = 0;
    private Map<String, FontMetrics> fonts = new HashMap<String, FontMetrics>();
    private boolean scrollEnabled = true;
    private LineHighlighter painter;

    public TextLineNumber(JTextComponent jTextComponent) {
        this(jTextComponent, 3, defaultHighlightColor);
    }

    public TextLineNumber(JTextComponent jTextComponent, Color color) {
        this(jTextComponent, 3, color);
    }

    public TextLineNumber(JTextComponent jTextComponent, int n) {
        this(jTextComponent, n, defaultHighlightColor);
    }

    public TextLineNumber(JTextComponent jTextComponent, int n, Color color) {
        this.component = jTextComponent;
        this.addMouseListener(this);
        this.lastPrintedLine = 0;
        this.currentLine = 0;
        DefaultHighlighter defaultHighlighter = new DefaultHighlighter();
        this.painter = new LineHighlighter(color);
        jTextComponent.setHighlighter(defaultHighlighter);
        try {
            defaultHighlighter.addHighlight(0, 0, this.painter);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(TextLineNumber.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        this.setFont(jTextComponent.getFont());
        this.setBorderGap(5);
        this.setCurrentLineForeground(Color.RED);
        this.setDigitAlignment(1.0f);
        this.setMinimumDisplayDigits(n);
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public void setBorderGap(int n) {
        this.borderGap = n;
        EmptyBorder emptyBorder = new EmptyBorder(0, n, 0, n);
        this.setBorder(new CompoundBorder(OUTER, emptyBorder));
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    public boolean isScrollEnabled() {
        return this.scrollEnabled;
    }

    public void setScrollEnabled(boolean bl) {
        this.scrollEnabled = bl;
    }

    public void clearAllHighlight() {
        this.painter.clearAllHighlight();
    }

    public void highlightLine(int n, Color color) {
        this.painter.highlightLine(n, color);
    }

    public void clearAllhighlightStart() {
        this.painter.clearAllhighlightStart();
    }

    public Map<Integer, Color> getAllhighlightStart() {
        return this.painter.getAllhighlightStart();
    }

    public void highlightLineStart(int n, Color color) {
        this.painter.highlightLineStart(n, color);
    }

    public void highlightLineStartArea(int n, int n2, Color color) {
        for (int i = n; i <= n2; ++i) {
            this.painter.highlightLineStart(i, color);
        }
    }

    public void setActualLineHighlightColor(Color color) {
        this.painter.setActualLineHighlightColor(color);
    }

    public Color getActualLineHighlightColor() {
        return this.painter.getActualLineHighlightColor();
    }

    public Color getCurrentLineForeground() {
        return this.currentLineForeground == null ? this.getForeground() : this.currentLineForeground;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setCurrentLine(int n) {
        if (n < 0 || n > this.component.getDocument().getDefaultRootElement().getElementCount()) {
            throw new IllegalArgumentException();
        }
        this.currentLine = n;
        this.painter.setActualLine(this.currentLine);
    }

    public void moveFromCurrentLine(int n) {
        this.setCurrentLine(this.currentLine + n);
    }

    public void setCurrentLineForeground(Color color) {
        this.currentLineForeground = color;
    }

    public float getDigitAlignment() {
        return this.digitAlignment;
    }

    public void setDigitAlignment(float f) {
        this.digitAlignment = f > 1.0f ? 1.0f : (f < 0.0f ? -1.0f : f);
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int n) {
        this.minimumDisplayDigits = n;
        this.setPreferredWidth();
    }

    public double getLinesNumbersPartWidth() {
        return this.getSize().getWidth() - this.component.getSize().getWidth();
    }

    private void setPreferredWidth() {
        Element element = this.component.getDocument().getDefaultRootElement();
        int n = element.getElementCount();
        int n2 = Math.max(String.valueOf(n).length(), this.minimumDisplayDigits);
        if (this.lastDigits != n2) {
            this.lastDigits = n2;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = fontMetrics.charWidth('0') * n2;
            Insets insets = this.getInsets();
            int n4 = insets.left + insets.right + n3 + 15;
            Dimension dimension = this.getPreferredSize();
            dimension.setSize(n4, 2146483647);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
    }

    public static void centerLineInScrollPane(JTextComponent jTextComponent) {
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, jTextComponent);
        if (container == null) {
            return;
        }
        try {
            Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
            JViewport jViewport = (JViewport)container;
            int n = jViewport.getExtentSize().height;
            int n2 = jViewport.getViewSize().height;
            int n3 = Math.max(0, rectangle.y - n / 2);
            n3 = Math.min(n3, n2 - n);
            jViewport.setViewPosition(new Point(0, n3));
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(TextLineNumber.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
    }

    protected void positionCaret(int n, int n2) {
        if (this.currentLine != this.lastCurrentLine) {
            this.lastCurrentLine = this.currentLine;
            if (n2 != 1) {
                this.component.setCaretPosition(n + 1);
            } else {
                this.component.setCaretPosition(0);
            }
            TextLineNumber.centerLineInScrollPane(this.component);
        }
    }

    protected void paintActiveLine(Graphics2D graphics2D, int n, int n2) {
        Color color = graphics2D.getColor();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Polygon polygon = new Polygon();
        polygon.addPoint(12, n2 - 11);
        polygon.addPoint(12, n2 + 1);
        polygon.addPoint(20, n2 - 5);
        graphics2D.setColor(Color.GREEN);
        graphics2D.fillPolygon(polygon);
        graphics2D.fillRect(5, n2 - 8, 7, 6);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        graphics2D.setColor(color);
    }

    protected void paintDebugSymbol(Graphics2D graphics2D, int n, int n2) {
        Color color = graphics2D.getColor();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double d = 5.0;
        n = 28;
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n - d, (double)(n2 -= 5) - d, 2.0 * d, 2.0 * d);
        graphics2D.setColor(Color.RED);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        graphics2D.fill(double_);
        graphics2D.setColor(color);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.component.repaint();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        Insets insets = this.getInsets();
        int n = this.getSize().width - insets.left - insets.right;
        int n2 = 0;
        int n3 = this.component.getDocument().getLength();
        this.actualLineElement = null;
        while (n2 <= n3) {
            try {
                Element element = this.component.getDocument().getDefaultRootElement();
                Element element2 = element.getElement(element.getElementIndex(n2));
                int n4 = this.getLineNumber(element2);
                int n5 = this.getRealLineNumber(element2);
                if (this.lastPrintedLine != n5 && n5 != 0) {
                    String string = this.getTextLineNumber(n4);
                    int n6 = fontMetrics.stringWidth(string);
                    int n7 = this.getOffsetX(n, n6) + insets.left;
                    int n8 = this.getOffsetY(n2, fontMetrics);
                    if (n5 != 0 && n5 == this.currentLine) {
                        this.paintActiveLine(graphics2D, n7, n8);
                        graphics2D.setColor(this.getCurrentLineForeground());
                        this.actualLineElement = element2;
                    } else {
                        graphics2D.setColor(this.getForeground());
                    }
                    if (n5 != 0 && this.debugLinesSet.contains(n5)) {
                        this.paintDebugSymbol(graphics2D, n7, n8);
                    } else {
                        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        graphics2D.drawString(string, n7, n8);
                        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                    }
                    this.lastPrintedLine = n5;
                }
                n2 = Utilities.getRowEnd(this.component, n2) + 1;
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(TextLineNumber.class.getName()).log(Level.SEVERE, null, badLocationException);
            }
        }
        this.scrollToCurrentLine();
        this.lastPrintedLine = 0;
    }

    public void scrollToCurrentLine() {
        if (this.scrollEnabled) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TextLineNumber.this.actualLineElement != null) {
                        TextLineNumber.this.positionCaret(TextLineNumber.this.actualLineElement.getEndOffset(), TextLineNumber.this.getRealLineNumber(TextLineNumber.this.actualLineElement));
                    }
                }
            });
        }
    }

    protected int getRealLineNumber(Element element) {
        Object object = element.getAttributes().getAttribute("line");
        return (Integer)(object == null ? Integer.valueOf(0) : object);
    }

    protected int getLineNumber(Element element) {
        Object object = element.getAttributes().getAttribute("lineNum");
        return (Integer)(object == null ? Integer.valueOf(0) : object);
    }

    protected String getTextLineNumber(int n) {
        if (n != 0) {
            return String.valueOf(n);
        }
        return "";
    }

    private int getOffsetX(int n, int n2) {
        return (int)((float)(n - n2) * this.digitAlignment);
    }

    private int getOffsetY(int n, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle rectangle = this.component.modelToView(n);
        int n2 = fontMetrics.getHeight();
        int n3 = rectangle.y + rectangle.height;
        int n4 = 0;
        if (rectangle.height == n2) {
            n4 = fontMetrics.getDescent();
        } else {
            Element element = this.component.getDocument().getDefaultRootElement();
            int n5 = element.getElementIndex(n);
            Element element2 = element.getElement(n5);
            for (int i = 0; i < element2.getElementCount(); ++i) {
                Element element3 = element2.getElement(i);
                AttributeSet attributeSet = element3.getAttributes();
                String string = (String)attributeSet.getAttribute(StyleConstants.FontFamily);
                Integer n6 = (Integer)attributeSet.getAttribute(StyleConstants.FontSize);
                String string2 = string + n6;
                FontMetrics fontMetrics2 = this.fonts.get(string2);
                if (fontMetrics2 == null) {
                    Font font = new Font(string, 0, n6);
                    fontMetrics2 = this.component.getFontMetrics(font);
                    this.fonts.put(string2, fontMetrics2);
                }
                n4 = Math.max(n4, fontMetrics2.getDescent());
            }
        }
        return n3 - n4;
    }

    public boolean isDebugOnCurrentLine() {
        return this.debugLinesSet.contains(this.currentLine);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() % 2 == 0) {
            int n;
            int n2 = this.component.viewToModel(mouseEvent.getPoint());
            Element element = this.component.getDocument().getDefaultRootElement();
            Element element2 = element.getElement(n = element.getElementIndex(n2));
            if (element2 != null) {
                int n3 = this.getRealLineNumber(element2);
                if (this.debugLinesSet.contains(n3)) {
                    this.debugLinesSet.remove(n3);
                } else {
                    this.debugLinesSet.add(n3);
                }
                this.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

