/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs.bfs;

import simulator.graphs.AbstractGraphCell;
import simulator.graphs.bfs.BfsNodeData;
import simulator.graphs.bfs.BfsOperations;

public class BfsGraphCell
extends AbstractGraphCell
implements BfsOperations {
    protected BfsNodeData state = null;

    public BfsGraphCell() {
        this((String)null);
    }

    public BfsGraphCell(String string) {
        this(string, false);
    }

    public BfsGraphCell(String string, Boolean bl) {
        this(string, new BfsNodeData(), bl);
    }

    public BfsGraphCell(String string, BfsNodeData bfsNodeData, Boolean bl) {
        super(string, bl);
        this.state = bfsNodeData;
    }

    @Override
    public String getLabel() {
        if (!this.state.isEnabled()) {
            return this.getName();
        }
        if (this.state.isInfinity()) {
            return this.getName() + ",\u221e";
        }
        return this.getName() + "," + this.state.getIntValue();
    }

    @Override
    public String getToolTips() {
        if (!this.state.isEnabled() || !this.state.isToolTipsEnabled()) {
            return "\u03c0 = ";
        }
        if (this.state.getNodePath() == null) {
            return "\u03c0 = NIL";
        }
        return "\u03c0 = " + this.state.getNodePath().getName();
    }

    @Override
    public boolean isInfinity() {
        return this.state.isInfinity();
    }

    @Override
    public void setInfinity(boolean bl) {
        this.state.setInfinity(bl);
    }

    @Override
    public int getIntValue() {
        return this.state.getIntValue();
    }

    @Override
    public void setIntValue(int n) {
        this.state.setIntValue(n);
    }

    @Override
    public BfsGraphCell getNodePath() {
        return this.state.getNodePath();
    }

    @Override
    public void setNodePath(BfsGraphCell bfsGraphCell) {
        this.state.setNodePath(bfsGraphCell);
    }

    @Override
    public void clearState() {
        this.state = null;
    }

    @Override
    public void resetState() {
        this.state.resetState();
    }

    @Override
    public boolean isEnabled() {
        return this.state.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.state.setEnabled(bl);
    }

    @Override
    public boolean isActive() {
        return this.state.isActive();
    }

    @Override
    public void setActive(boolean bl) {
        this.state.setActive(bl);
    }

    @Override
    public void setToolTipsEnabled(boolean bl) {
        this.state.setToolTipsEnabled(bl);
    }

    @Override
    public boolean isToolTipsEnabled() {
        return this.state.isToolTipsEnabled();
    }
}

