/*
 * Decompiled with CFR 0.152.
 */
package program;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUndoManager;
import com.mxgraph.view.mxGraphView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.TransferHandler;
import program.MainPanel;
import program.actions.ActionLogger;
import program.actions.BasicActions;

public class ToolBar
extends JToolBar
implements mxEventSource.mxIEventListener {
    private static final Insets margins = new Insets(0, 0, 0, 0);
    protected boolean hideLabels = true;
    protected ToolBarButton redoButton;
    protected ToolBarButton undoButton;
    private boolean ignoreZoomChange = false;

    public ToolBar(final MainPanel mainPanel, int n) {
        super(n);
        this.setFloatable(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), this.getBorder()));
        this.add(new ToolBarButton(mainPanel.bind(mxResources.get((String)"new"), new ActionLogger(new BasicActions.NewAction()), "/images/new.gif")));
        this.add(new ToolBarButton(mainPanel.bind(mxResources.get((String)"open"), new ActionLogger(new BasicActions.OpenAction()), "/images/open.gif")));
        this.add(new ToolBarButton(mainPanel.bind(mxResources.get((String)"save"), new ActionLogger(new BasicActions.SaveAction(false)), "/images/save.gif")));
        this.addSeparator();
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get((String)"cut"), new ActionLogger(TransferHandler.getCutAction()), "/images/cut.gif")));
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get((String)"copy"), new ActionLogger(TransferHandler.getCopyAction()), "/images/copy.gif")));
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get((String)"paste"), new ActionLogger(TransferHandler.getPasteAction()), "/images/paste.gif")));
        this.addSeparator();
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get((String)"delete"), new ActionLogger(mxGraphActions.getDeleteAction()), "/images/delete.gif")));
        this.addSeparator();
        this.undoButton = (ToolBarButton)this.add(new ToolBarButton(mainPanel.bind(mxResources.get((String)"undo"), new ActionLogger(new BasicActions.UndoAction()), "/images/undo.gif")));
        this.undoButton.setEnabled(false);
        this.redoButton = (ToolBarButton)this.add(new ToolBarButton(mainPanel.bind(mxResources.get((String)"redo"), new ActionLogger(new BasicActions.RedoAction()), "/images/redo.gif")));
        this.redoButton.setEnabled(false);
        this.addSeparator();
        final mxGraphView mxGraphView2 = mainPanel.getGraphComponent().getGraph().getView();
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"400%", "200%", "150%", "100%", "75%", "50%", mxResources.get((String)"actualSize")});
        jComboBox.setName("Zoom");
        jComboBox.setEditable(true);
        jComboBox.setMinimumSize(new Dimension(75, 0));
        jComboBox.setPreferredSize(new Dimension(75, 0));
        jComboBox.setMaximumSize(new Dimension(75, 100));
        jComboBox.setMaximumRowCount(9);
        this.add(jComboBox);
        this.addSeparator();
        mxEventSource.mxIEventListener mxIEventListener2 = new mxEventSource.mxIEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke(Object object, mxEventObject mxEventObject2) {
                ToolBar.this.ignoreZoomChange = true;
                try {
                    jComboBox.setSelectedItem((int)Math.round(100.0 * mxGraphView2.getScale()) + "%");
                }
                finally {
                    ToolBar.this.ignoreZoomChange = false;
                }
            }
        };
        mxGraphView2.getGraph().getView().addListener("scale", mxIEventListener2);
        mxGraphView2.getGraph().getView().addListener("scaleAndTranslate", mxIEventListener2);
        mxIEventListener2.invoke(null, null);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mxGraphComponent mxGraphComponent2 = mainPanel.getGraphComponent();
                if (!ToolBar.this.ignoreZoomChange) {
                    String string = jComboBox.getSelectedItem().toString();
                    if (string.equals(mxResources.get((String)"actualSize"))) {
                        mxGraphComponent2.zoomActual();
                    } else {
                        try {
                            string = string.replace("%", "");
                            double d = Math.min(16.0, Math.max(0.01, Double.parseDouble(string) / 100.0));
                            mxGraphComponent2.zoomTo(d, mxGraphComponent2.isCenterZoom());
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(mainPanel, exception.getMessage());
                        }
                    }
                }
            }
        });
        this.add(new ToolBarButton(mainPanel.bindGraphAction(mxResources.get((String)"setSelected"), new ActionLogger(new BasicActions.SetCellSelectedAction()), "/images/preferences.gif")));
    }

    public void showOrHideLabels() {
        this.hideLabels = !this.hideLabels;
        for (Component component : this.getComponents()) {
            JComponent jComponent;
            if (component instanceof ToolBarButton) {
                jComponent = (ToolBarButton)component;
                ((AbstractButton)jComponent).setHideActionText(this.hideLabels);
                continue;
            }
            if (!(component instanceof JComboBox)) continue;
            jComponent = (JComboBox)component;
            jComponent.setMaximumSize(jComponent.getSize());
        }
    }

    public void invoke(Object object, mxEventObject mxEventObject2) {
        if (object != null && object instanceof mxUndoManager) {
            mxUndoManager mxUndoManager2 = (mxUndoManager)object;
            this.redoButton.setEnabled(mxUndoManager2.canRedo());
            this.undoButton.setEnabled(mxUndoManager2.canUndo());
        }
    }

    public class ToolBarButton
    extends JButton {
        public ToolBarButton(Action action) {
            super(action);
            this.setMargin(margins);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHideActionText(ToolBar.this.hideLabels);
            this.setFocusPainted(false);
            this.setToolTipText((String)action.getValue("Name"));
        }
    }
}

