/*
 * Decompiled with CFR 0.152.
 */
package program;

import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxUndoManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import program.MainPanel;
import program.actions.ActionLogger;
import program.actions.BasicActions;

public class MenuBar
extends JMenuBar
implements mxEventSource.mxIEventListener,
PropertyChangeListener {
    private static Logger logger = LogManager.getLogger((String)MenuBar.class.getName());
    protected MainPanel mainPanel;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenuItem aboutItem;
    protected JMenuItem fullscreenItem;

    public MenuBar(MainPanel mainPanel) {
        logger.entry(new Object[]{mainPanel});
        if (mainPanel == null) {
            throw new NullPointerException();
        }
        this.mainPanel = mainPanel;
        this.addFileItems();
        this.addEditMenu();
        this.addViewMenu();
        this.addSimulateMenu();
        this.addWindowMenu();
        this.addLanguageItems();
        this.addHelpMenu();
        logger.exit();
    }

    private void addFileItems() {
        logger.entry();
        JMenu jMenu = this.add(new JMenu(mxResources.get((String)"file")));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"newGraph"), new ActionLogger(new BasicActions.NewAction()), "/images/new.gif")).setAccelerator(KeyStroke.getKeyStroke(78, 3));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"openFile"), new ActionLogger(new BasicActions.OpenAction()), "/images/open.gif")).setAccelerator(KeyStroke.getKeyStroke(79, 3));
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"save"), new ActionLogger(new BasicActions.SaveAction(false)), "/images/save.gif")).setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"saveAs"), new ActionLogger(new BasicActions.SaveAction(true)), "/images/saveas.gif"));
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"exit"), new BasicActions.ExitAction()));
        logger.exit();
    }

    private void addEditMenu() {
        logger.entry();
        JMenu jMenu = this.add(new JMenu(mxResources.get((String)"edit")));
        this.undoItem = jMenu.add(this.mainPanel.bind(mxResources.get((String)"undo"), new ActionLogger(new BasicActions.UndoAction()), "/images/undo.gif"));
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoItem.setEnabled(false);
        this.redoItem = jMenu.add(this.mainPanel.bind(mxResources.get((String)"redo"), new ActionLogger(new BasicActions.RedoAction()), "/images/redo.gif"));
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoItem.setEnabled(false);
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"cut"), new ActionLogger(TransferHandler.getCutAction()), "/images/cut.gif")).setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"copy"), new ActionLogger(TransferHandler.getCopyAction()), "/images/copy.gif")).setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"paste"), new ActionLogger(TransferHandler.getPasteAction()), "/images/paste.gif")).setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"delete"), new ActionLogger(mxGraphActions.getDeleteAction()), "/images/delete.gif")).setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"selectAll"), new ActionLogger(mxGraphActions.getSelectAllAction()))).setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"selectAllEdges"), new ActionLogger(mxGraphActions.getSelectEdgesAction())));
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"selectAllVertices"), new ActionLogger(mxGraphActions.getSelectVerticesAction())));
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"selectNone"), new ActionLogger(mxGraphActions.getSelectNoneAction())));
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"setSelected"), new ActionLogger(new BasicActions.SetCellSelectedAction()))).setAccelerator(KeyStroke.getKeyStroke(' '));
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"edit"), new ActionLogger(mxGraphActions.getEditAction())));
        jMenu.add(this.mainPanel.bindGraphAction(mxResources.get((String)"setStyle"), new ActionLogger(new BasicActions.SetStyleAction())));
        logger.exit();
    }

    private void addViewMenu() {
        logger.entry();
        JMenu jMenu = this.add(new JMenu(mxResources.get((String)"view")));
        JMenu jMenu2 = (JMenu)jMenu.add(new JMenu(mxResources.get((String)"zoom")));
        jMenu2.add(this.mainPanel.bind("400%", new BasicActions.ZoomAction(4.0)));
        jMenu2.add(this.mainPanel.bind("200%", new BasicActions.ZoomAction(2.0)));
        jMenu2.add(this.mainPanel.bind("150%", new BasicActions.ZoomAction(1.5)));
        jMenu2.add(this.mainPanel.bind("100%", new BasicActions.ZoomAction(1.0)));
        jMenu2.add(this.mainPanel.bind("75%", new BasicActions.ZoomAction(0.75)));
        jMenu2.add(this.mainPanel.bind("50%", new BasicActions.ZoomAction(0.5)));
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"maximize"), new ActionLogger(new BasicActions.MaximizeAction())));
        logger.exit();
    }

    private void addSimulateMenu() {
        logger.entry();
        JMenu jMenu = this.add(new JMenu(mxResources.get((String)"simulate")));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"BFS"), new ActionLogger(new BasicActions.BfsSimulatorAction())));
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"DFS"), new ActionLogger(new BasicActions.DfsSimulatorAction())));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"TopologicalSort"), new ActionLogger(new BasicActions.TopologicalSortSimulatorAction())));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"SCC"), new ActionLogger(new BasicActions.SccSimulatorAction())));
        jMenu.addSeparator();
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"BellmanFord"), new ActionLogger(new BasicActions.BellmanFordSimulatorAction())));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"Dijkstra"), new ActionLogger(new BasicActions.DijkstraSimulatorAction())));
        logger.exit();
    }

    private void addLanguageItems() {
        logger.entry();
        JMenu jMenu = this.add(new JMenu(mxResources.get((String)"language")));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"czech"), new ActionLogger(new BasicActions.CzechLanguageAction()), "/images/cze.gif"));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"english"), new ActionLogger(new BasicActions.EnglishLanguageAction()), "/images/uk.gif"));
        logger.exit();
    }

    private void addWindowMenu() {
        logger.entry();
        JMenu jMenu = this.add(new JMenu(mxResources.get((String)"window")));
        jMenu.add(new JCheckBoxMenuItem(this.mainPanel.bind(mxResources.get((String)"toolBarLabel"), new ActionLogger(new BasicActions.ToolBarLabelsAction()))));
        jMenu.addSeparator();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            final String string = lookAndFeelInfoArray[i].getClassName();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(lookAndFeelInfoArray[i].getName()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MenuBar.this.mainPanel.setLookAndFeel(string);
                }
            });
            if (lookAndFeelInfoArray[i].getName().equals(UIManager.getLookAndFeel().getName())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        logger.exit();
    }

    private void addHelpMenu() {
        logger.entry();
        JMenu jMenu = this.add(new JMenu(mxResources.get((String)"help")));
        this.aboutItem = jMenu.add(this.mainPanel.bind(mxResources.get((String)"about"), new ActionLogger(new BasicActions.AboutAction())));
        jMenu.add(this.mainPanel.bind(mxResources.get((String)"manual"), new ActionLogger(new BasicActions.ShowManualAction())));
        logger.exit();
    }

    public void invoke(Object object, mxEventObject mxEventObject2) {
        logger.entry(new Object[]{object, mxEventObject2});
        if (object != null && object instanceof mxUndoManager) {
            mxUndoManager mxUndoManager2 = (mxUndoManager)object;
            this.redoItem.setEnabled(mxUndoManager2.canRedo());
            this.undoItem.setEnabled(mxUndoManager2.canUndo());
        }
        logger.exit();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        logger.entry(new Object[]{propertyChangeEvent});
        switch (propertyChangeEvent.getPropertyName()) {
            case "Fullscreen": {
                this.aboutItem.setEnabled((Boolean)propertyChangeEvent.getNewValue() == false);
            }
        }
        logger.exit();
    }
}

