/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxResources;
import editor.GraphViewPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import simulator.graphs.GraphVertexBasicData;
import simulator.gui.VariablesPanel;

public class InformationPanel
extends JPanel {
    public static String dequeToString(Deque<mxCell> deque) {
        if (deque == null) {
            return "[]";
        }
        Iterator<mxCell> iterator = deque.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (true) {
            mxCell mxCell2;
            if ((mxCell2 = iterator.next()).isVertex()) {
                stringBuilder.append(((GraphVertexBasicData)mxCell2.getValue()).getName());
            } else {
                mxCell mxCell3 = (mxCell)mxCell2.getSource();
                mxCell mxCell4 = (mxCell)mxCell2.getTarget();
                stringBuilder.append('(');
                stringBuilder.append(((GraphVertexBasicData)mxCell3.getValue()).getName());
                stringBuilder.append(", ");
                stringBuilder.append(((GraphVertexBasicData)mxCell4.getValue()).getName());
                stringBuilder.append(')');
            }
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    public InformationPanel(final GraphViewPanel graphViewPanel) {
        this.setLayout(new GridLayout(1, 0));
        JSplitPane jSplitPane = new JSplitPane(0);
        final VariablesPanel.VariablesTableModel variablesTableModel = new VariablesPanel.VariablesTableModel(new String[]{mxResources.get((String)"node"), mxResources.get((String)"neighbourlist")});
        final JTable jTable = new JTable(variablesTableModel);
        jTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    ((JTable)keyEvent.getSource()).clearSelection();
                }
                if (keyEvent.getKeyCode() == 127 && jTable.getSelectedRow() >= 0) {
                    String string = variablesTableModel.getValueAt(jTable.getSelectedRow(), 0).toString();
                    for (Object object : graphViewPanel.getGraph().getChildVertices(graphViewPanel.getGraph().getDefaultParent())) {
                        mxCell mxCell2 = (mxCell)object;
                        String string2 = ((GraphVertexBasicData)mxCell2.getValue()).getName();
                        if (!string.equals(string2)) continue;
                        graphViewPanel.getGraph().removeCells(new Object[]{object});
                        break;
                    }
                }
            }
        });
        jTable.getColumnModel().getColumn(0).setMinWidth(50);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        jTable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        jTable.getColumnModel().getColumn(1).setMinWidth(90);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(Short.MAX_VALUE);
        Font font = new Font("SansSerif", 0, 16);
        jTable.setFont(font);
        jTable.setRowHeight(jTable.getFontMetrics(font).getHeight());
        graphViewPanel.getGraph().addListener(null, new mxEventSource.mxIEventListener(){

            public void invoke(Object object, mxEventObject mxEventObject2) {
                switch (mxEventObject2.getName()) {
                    case "repaint": {
                        variablesTableModel.getData().clear();
                        for (Object object2 : graphViewPanel.getGraph().getChildVertices(graphViewPanel.getGraph().getDefaultParent())) {
                            mxCell mxCell2 = (mxCell)object2;
                            String string = ((GraphVertexBasicData)mxCell2.getValue()).getName();
                            LinkedList<mxCell> linkedList = new LinkedList<mxCell>();
                            for (int i = 0; i < graphViewPanel.getGraph().getModel().getEdgeCount((Object)mxCell2); ++i) {
                                mxCell mxCell3 = (mxCell)graphViewPanel.getGraph().getModel().getEdgeAt((Object)mxCell2, i);
                                mxCell mxCell4 = (mxCell)mxCell3.getSource();
                                mxCell mxCell5 = (mxCell)mxCell3.getTarget();
                                if (mxCell4 == mxCell2 && !linkedList.contains(mxCell5)) {
                                    linkedList.addFirst(mxCell5);
                                    continue;
                                }
                                if (graphViewPanel.getGraph().isOriented() || mxCell5 != mxCell2 || linkedList.contains(mxCell4)) continue;
                                linkedList.addFirst(mxCell4);
                            }
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put(variablesTableModel.getColumnName(0), string);
                            hashMap.put(variablesTableModel.getColumnName(1), InformationPanel.dequeToString(linkedList));
                            variablesTableModel.getData().put(string, hashMap);
                        }
                        variablesTableModel.fireTableDataChanged();
                    }
                }
            }
        });
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (jTable.getSelectedRow() >= 0) {
                    String string = variablesTableModel.getValueAt(jTable.getSelectedRow(), 0).toString();
                    for (Object object : graphViewPanel.getGraph().getChildVertices(graphViewPanel.getGraph().getDefaultParent())) {
                        mxCell mxCell2 = (mxCell)object;
                        String string2 = ((GraphVertexBasicData)mxCell2.getValue()).getName();
                        if (!string.equals(string2)) continue;
                        graphViewPanel.getGraph().setSelectionCell(object);
                        break;
                    }
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(new JScrollPane(jTable));
        jSplitPane.setTopComponent(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add((Component)graphViewPanel.getGraphOutline());
        jSplitPane.setBottomComponent(jPanel2);
        jSplitPane.setContinuousLayout(true);
        this.add(jSplitPane);
    }
}

