/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.OutputStream;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.DatagramOutputStream;

public class DatagramSocketManager
extends AbstractSocketManager {
    private static final DatagramSocketManagerFactory FACTORY = new DatagramSocketManagerFactory();

    protected DatagramSocketManager(OutputStream os, String name, String host, int port) {
        super(name, os, null, host, port);
    }

    public static DatagramSocketManager getSocketManager(String host, int port) {
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("A port value is required");
        }
        return (DatagramSocketManager)DatagramSocketManager.getManager("UDP:" + host + ":" + port, new FactoryData(host, port), FACTORY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatagramSocketManagerFactory
    implements ManagerFactory<DatagramSocketManager, FactoryData> {
        private DatagramSocketManagerFactory() {
        }

        @Override
        public DatagramSocketManager createManager(String name, FactoryData data) {
            DatagramOutputStream os = new DatagramOutputStream(data.host, data.port);
            return new DatagramSocketManager(os, name, data.host, data.port);
        }
    }

    private static class FactoryData {
        private final String host;
        private final int port;

        public FactoryData(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

