/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AppenderRuntimeException;
import org.apache.logging.log4j.status.StatusLogger;

public class DatagramOutputStream
extends OutputStream {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final int SHIFT_1 = 8;
    private static final int SHIFT_2 = 16;
    private static final int SHIFT_3 = 24;
    private DatagramSocket ds;
    private final InetAddress address;
    private final int port;
    private byte[] data;

    public DatagramOutputStream(String host, int port) {
        this.port = port;
        try {
            this.address = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            String msg = "Could not find host " + host;
            LOGGER.error(msg, (Throwable)ex);
            throw new AppenderRuntimeException(msg, ex);
        }
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException ex) {
            String msg = "Could not instantiate DatagramSocket to " + host;
            LOGGER.error(msg, (Throwable)ex);
            throw new AppenderRuntimeException(msg, ex);
        }
    }

    public synchronized void write(byte[] bytes, int offset, int length) throws IOException {
        this.copy(bytes, offset, length);
    }

    public synchronized void write(int i) throws IOException {
        this.copy(new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i}, 0, 4);
    }

    public synchronized void write(byte[] bytes) throws IOException {
        this.copy(bytes, 0, bytes.length);
    }

    public synchronized void flush() throws IOException {
        if (this.ds != null && this.address != null) {
            DatagramPacket packet = new DatagramPacket(this.data, this.data.length, this.address, this.port);
            this.ds.send(packet);
        }
        this.data = null;
    }

    public synchronized void close() throws IOException {
        if (this.ds != null) {
            if (this.data != null) {
                this.flush();
            }
            this.ds.close();
            this.ds = null;
        }
    }

    private void copy(byte[] bytes, int offset, int length) {
        int index = this.data == null ? 0 : this.data.length;
        byte[] copy = new byte[length + index];
        if (this.data != null) {
            System.arraycopy(this.data, 0, copy, 0, index);
        }
        System.arraycopy(bytes, offset, copy, index, length);
        this.data = copy;
    }
}

