/*
 * Decompiled with CFR 0.152.
 */
package simulator.graphs;

import simulator.graphs.GraphCell;
import simulator.graphs.GraphEdgeBasicData;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexBasicData;
import simulator.graphs.GraphVertexData;

public abstract class AbstractGraphCell
implements GraphCell {
    protected boolean editable = false;
    protected GraphVertexData vertexData = new GraphVertexData();
    protected GraphEdgeData edgeData = new GraphEdgeData();

    public AbstractGraphCell() {
        this("");
    }

    public AbstractGraphCell(String string) {
        this(string, false);
    }

    public AbstractGraphCell(String string, Boolean bl) {
        this.vertexData.setName(string);
        this.vertexData.setSelected(bl);
    }

    public AbstractGraphCell(Double d) {
        this.edgeData.setDistance(d);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public String toString() {
        return "AbstractGraphCell{editable=" + this.editable + ", vertexData=" + this.vertexData + ", edgeData=" + this.edgeData + '}';
    }

    @Override
    public String getName() {
        return this.vertexData.getName();
    }

    @Override
    public void setName(String string) {
        this.vertexData.setName(string);
    }

    @Override
    public Boolean isSelected() {
        return this.vertexData.isSelected();
    }

    @Override
    public Boolean getSelected() {
        return this.vertexData.getSelected();
    }

    @Override
    public void setSelected(Boolean bl) {
        this.vertexData.setSelected(bl);
    }

    @Override
    public GraphVertexBasicData getBasicVertexData() {
        return this.vertexData.getBasicVertexData();
    }

    @Override
    public Double getDistance() {
        return this.edgeData.getDistance();
    }

    @Override
    public void setDistance(Double d) {
        this.edgeData.setDistance(d);
    }

    @Override
    public GraphEdgeBasicData getBasicEdgeData() {
        return this.edgeData.getBasicEdgeData();
    }

    @Override
    public void edit(String string) {
    }
}

