/*
 * Decompiled with CFR 0.152.
 */
package simulator.controllers;

import com.mxgraph.model.mxCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import simulator.controllers.AbstractController;
import simulator.controllers.AbstractShortestPathController;
import simulator.controllers.SelectCellsMouseAdapter;
import simulator.controllers.VariableObject;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.AlgorithmGraphComponent;
import simulator.graphs.GraphCell;
import simulator.graphs.bellmanford.BellmanFordGraphEdge;
import simulator.graphs.bellmanford.BellmanFordGraphVertex;
import simulator.gui.VariablesPanel;
import simulator.gui.VisualizationPseudocodePanel;

public class BellmanFordController
extends AbstractShortestPathController {
    protected Deque<mxCell> userEdgeList = new LinkedList<mxCell>();
    protected Integer variableI = 3;
    protected Integer variableN = 4;
    protected BellmanFordState state;
    protected boolean wasChange;

    public BellmanFordController(AlgorithmGraphComponent algorithmGraphComponent, JLabel jLabel, VisualizationPseudocodePanel visualizationPseudocodePanel, VariablesPanel variablesPanel) {
        super(algorithmGraphComponent, jLabel, visualizationPseudocodePanel, variablesPanel);
        this.resetControllerImpl();
        this.interactiveMode = false;
        AbstractController.LabelInstruction labelInstruction = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction2 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction3 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction4 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction5 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction6 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("i", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("n", false));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 12), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 4), Color.GREEN));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 5), Color.GREEN));
        this.tape.add(new AbstractController.SelectStartNodeInstruction());
        this.tape.add(new AbstractShortestPathController.InitInstruction(this.stylesheet.getSelectedVertexStyle()));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 1)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Initialization of all nodes"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction3);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 1), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 5), this.doneColor));
        this.tape.add(new AbstractController.SetIntRegisterInstruction(this.variableI, 0));
        this.tape.add(new AbstractController.SetIntRegisterInstruction(this.variableN, this.graph.getChildVertices(this.graph.getDefaultParent()).length));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("i", true));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("n", true));
        AbstractController.LabelInstruction labelInstruction7 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction7);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Main cycle based on the number of nodes in the graph"));
        this.tape.add(new SetChangedInstruction(false));
        this.tape.add(new AbstractController.IncIntRegisterInstruction(this.variableI));
        this.tape.add(new AbstractController.ClearQueueInstruction(this.cellList));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 2)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.AddAllEdgesListInstruction(this.cellList));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        AbstractController.LabelInstruction labelInstruction8 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction9 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction8);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Cycle for relaxation of all edges"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 3)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction9, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return BellmanFordController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(new SelectNextEdgeInstruction(this.cellList));
        this.tape.add(new OrderCellListInstruction(this.cellList, this.userEdgeList));
        this.tape.add(new AbstractController.DequeueInstruction(this.cellList));
        this.tape.add(new EnqueueBellmanFordInstruction(this.userEdgeList));
        this.tape.add(new AbstractShortestPathController.EdgeToRegistersInstruction(this.variableU, this.variableV));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", true));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getHighlighEdgeStyle()));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction2, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction4);
        this.tape.add(new AbstractShortestPathController.ColorPathsInstruction(this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 5)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction8, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !BellmanFordController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(labelInstruction9);
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new SetBellmanFordAlgStateInstruction(BellmanFordState.RUN));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 6)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction5, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                Object[] objectArray;
                int n;
                int n2 = (Integer)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableI);
                int n3 = (Integer)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableN) - 1;
                return !BellmanFordController.this.wasChange && n3 > n2 && (n = JOptionPane.showOptionDialog((Component)((Object)BellmanFordController.this.graphComponent), "In this step were no changes, do you want to skip them?", "Tracking of changes", 0, 3, null, objectArray = new Object[]{"Yes", "No"}, objectArray[0])) == 0;
            }
        }));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction7, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                int n = (Integer)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableI);
                int n2 = (Integer)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableN) - 1;
                return n2 > n;
            }
        }));
        this.tape.add(labelInstruction5);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 6), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(1, 1), this.algorithm.getRealLineNumber(1, 4), this.doneColor));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("i", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("n", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.AddAllEdgesListInstruction(this.cellList));
        this.tape.add(new OrderCellListInstruction(this.cellList, this.userEdgeList));
        AbstractController.LabelInstruction labelInstruction10 = new AbstractController.LabelInstruction();
        AbstractController.LabelInstruction labelInstruction11 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction10);
        this.tape.add(new AbstractController.SetLabelTextInstruction("Check negative cycle"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 7)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction11, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return BellmanFordController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.DequeueInstruction(this.cellList));
        this.tape.add(new AbstractShortestPathController.EdgeToRegistersInstruction(this.variableU, this.variableV));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("u", true));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getHighlighEdgeStyle()));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 8)));
        this.tape.add(new AbstractController.PauseInstruction());
        AbstractController.LabelInstruction labelInstruction12 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction12, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                BellmanFordGraphVertex bellmanFordGraphVertex = (BellmanFordGraphVertex)((mxCell)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableU)).getValue();
                BellmanFordGraphVertex bellmanFordGraphVertex2 = (BellmanFordGraphVertex)((mxCell)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableV)).getValue();
                BellmanFordGraphEdge bellmanFordGraphEdge = (BellmanFordGraphEdge)((mxCell)BellmanFordController.this.activeVariable).getValue();
                return bellmanFordGraphVertex2.getDistance() <= bellmanFordGraphVertex.getDistance() + bellmanFordGraphEdge.getDistance();
            }
        }));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 8), this.doneColor));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 10), this.algorithm.getRealLineNumber(0, 12), this.doneColor));
        this.tape.add(new AbstractController.SetLabelTextInstruction("Negative cycle"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 9)));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getBreakConEdgeStyle()));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction6, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction12);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 10)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 11)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractShortestPathController.ColorPathsInstruction(this.stylesheet.getPathEdgeStyle(), this.stylesheet.getEdgeStyle()));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction10, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !BellmanFordController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(labelInstruction11);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 12), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(0, 12)));
        this.tape.add(new AbstractController.SetLabelTextInstruction("No negative cycle"));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(labelInstruction6);
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(0, 1), this.algorithm.getRealLineNumber(0, 12), this.doneColor));
        this.tape.add(new AbstractController.EndInstruction());
        this.tape.add(labelInstruction);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", true));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", true));
        this.tape.add(new AbstractController.AddAllVertexListInstruction(this.cellList));
        AbstractController.LabelInstruction labelInstruction13 = new AbstractController.LabelInstruction();
        this.tape.add(labelInstruction13);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 1)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.DequeueInstruction(this.cellList));
        this.tape.add(new AbstractController.ActiveToRegisterInstruction(this.variableV));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 2)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetVertexEnableInstruction());
        this.tape.add(new AbstractShortestPathController.SetDistanceInstruction(Double.POSITIVE_INFINITY));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 3)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetVertexToolTipsInstruction());
        this.tape.add(new AbstractShortestPathController.SetPathInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction13, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return !BellmanFordController.this.cellList.isEmpty();
            }
        }));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("v", false));
        this.tape.add(new AbstractController.ShowOrHideVariableInstruction("Iterative list", false));
        this.tape.add(new AbstractController.SetColorHighlighInstruction(this.algorithm.getRealLineNumber(2, 1), this.algorithm.getRealLineNumber(2, 4), this.doneColor));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(2, 5)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.RegisterToActiveInstruction(this.variableS));
        this.tape.add(new AbstractShortestPathController.SetDistanceInstruction(0.0));
        this.tape.add(new AbstractController.SetColorInstruction(this.stylesheet.getVertexStyle()));
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction3, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
        this.tape.add(labelInstruction2);
        this.tape.add(new AbstractController.SetLabelTextInstruction("The method of relaxation writes new distance from the node, until it is smaller than the previous"));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 0)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 1)));
        this.tape.add(new SetVertexDistanceInstruction());
        this.tape.add(new AbstractController.PauseInstruction());
        AbstractController.LabelInstruction labelInstruction14 = new AbstractController.LabelInstruction();
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction14, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                BellmanFordGraphVertex bellmanFordGraphVertex = (BellmanFordGraphVertex)((mxCell)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableU)).getValue();
                BellmanFordGraphVertex bellmanFordGraphVertex2 = (BellmanFordGraphVertex)((mxCell)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableV)).getValue();
                BellmanFordGraphEdge bellmanFordGraphEdge = (BellmanFordGraphEdge)((mxCell)BellmanFordController.this.activeVariable).getValue();
                return bellmanFordGraphVertex2.getDistance() <= bellmanFordGraphVertex.getDistance() + bellmanFordGraphEdge.getDistance();
            }
        }));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 2)));
        this.tape.add(new SetChangedInstruction(true));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add((AbstractShortestPathController)this.new AbstractShortestPathController.SetDistanceInstruction((int)this.variableV, this.variableU));
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 3)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractShortestPathController.SetPathInstruction(this.variableV, this.variableU));
        this.tape.add(labelInstruction14);
        this.tape.add(new AbstractController.SetCursorInstruction(this.algorithm.getRealLineNumber(1, 4)));
        this.tape.add(new AbstractController.PauseInstruction());
        this.tape.add(new AbstractController.LabelInstruction(labelInstruction4, new AbstractController.Condition(){

            @Override
            public boolean isFulfil() {
                return true;
            }
        }));
    }

    private void resetControllerImpl() {
        this.graphComponentLabel.setText("Bellman-Ford algorithm");
        this.codePanel.setCurrentLine(1);
        this.variables.put("s", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BellmanFordController.this.getNodeName(BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableS));
            }
        });
        this.variables.put("u", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BellmanFordController.this.getNodeName(BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableU));
            }
        });
        this.variables.put("v", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BellmanFordController.this.getNodeName(BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableV));
            }
        });
        this.variables.put("Iterative list", new VariableObject(){

            @Override
            public String getVariableValue() {
                return AbstractController.dequeToString(BellmanFordController.this.cellList);
            }
        });
        this.variables.put("i", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableI) != null ? BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableI).toString() : "";
            }
        });
        this.variables.put("n", new VariableObject(){

            @Override
            public String getVariableValue() {
                return BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableI) != null ? BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableN).toString() : "";
            }
        });
        for (Map.Entry entry : this.variables.entrySet()) {
            if (!((VariableObject)entry.getValue()).isEnabled()) continue;
            this.variablesPanel.addVariable((String)entry.getKey());
        }
        this.cellList.clear();
        this.userEdgeList.clear();
        this.state = BellmanFordState.FIRST_RUN;
        this.wasChange = false;
    }

    @Override
    public void resetController() {
        super.resetController();
        this.resetControllerImpl();
    }

    protected final class SetChangedEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected boolean oldChanged;
        protected boolean changed;

        public SetChangedEdit(boolean bl) {
            this.changed = bl;
            this.oldChanged = BellmanFordController.this.wasChange;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            BellmanFordController.this.wasChange = this.oldChanged;
        }

        @Override
        protected void action() {
            BellmanFordController.this.wasChange = this.changed;
        }
    }

    protected class SetChangedInstruction
    extends AbstractController.BasicInstruction {
        protected boolean changed;

        public SetChangedInstruction(boolean bl) {
            this.changed = bl;
        }

        @Override
        public void preform() {
            BellmanFordController.this.editBlock.addEdit(new SetChangedEdit(this.changed));
        }
    }

    protected final class SetBellmanFordAlgStateEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected BellmanFordState newState;
        protected BellmanFordState oldState;

        public SetBellmanFordAlgStateEdit(BellmanFordState bellmanFordState) {
            this.newState = bellmanFordState;
            this.oldState = BellmanFordController.this.state;
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            BellmanFordController.this.state = this.oldState;
        }

        @Override
        protected void action() {
            BellmanFordController.this.state = this.newState;
        }
    }

    protected class SetBellmanFordAlgStateInstruction
    extends AbstractController.BasicInstruction {
        protected BellmanFordState newState;

        public SetBellmanFordAlgStateInstruction(BellmanFordState bellmanFordState) {
            this.newState = bellmanFordState;
        }

        @Override
        public void preform() {
            BellmanFordController.this.editBlock.addEdit(new SetBellmanFordAlgStateEdit(this.newState));
        }
    }

    protected class EnqueueBellmanFordInstruction
    extends AbstractController.BasicInstruction {
        protected Deque<mxCell> q;

        public EnqueueBellmanFordInstruction(Deque<mxCell> deque) {
            this.q = deque;
        }

        @Override
        public void preform() {
            if (BellmanFordController.this.state == BellmanFordState.FIRST_RUN) {
                BellmanFordController.this.editBlock.addEdit(new AbstractController.EnqueueEdit(this.q, true));
            }
        }
    }

    protected final class OrderCellListEdit
    extends AbstractController.AlgorithmUndoableEdit {
        protected Deque<mxCell> list;
        protected Deque<mxCell> oldList;
        protected Deque<mxCell> orderPosition;

        public OrderCellListEdit(Deque<mxCell> deque, Deque<mxCell> deque2) {
            this.list = deque;
            this.orderPosition = deque2;
            this.oldList = new LinkedList<mxCell>();
            this.oldList.addAll(deque);
            this.action();
        }

        @Override
        public void undo() {
            super.undo();
            this.list.clear();
            this.list.addAll(this.oldList);
        }

        @Override
        protected void action() {
            LinkedList<mxCell> linkedList = new LinkedList<mxCell>();
            linkedList.addAll(this.orderPosition);
            linkedList.retainAll(this.list);
            this.list.clear();
            this.list.addAll(linkedList);
        }
    }

    protected class OrderCellListInstruction
    extends AbstractController.BasicInstruction {
        protected Deque<mxCell> list;
        protected Deque<mxCell> orderPosition;

        public OrderCellListInstruction(Deque<mxCell> deque, Deque<mxCell> deque2) {
            this.list = deque;
            this.orderPosition = deque2;
        }

        @Override
        public void preform() {
            if (BellmanFordController.this.state == BellmanFordState.FIRST_RUN) {
                new AbstractController.SetSelectedCellFirstInstruction(this.list).preform();
            } else {
                BellmanFordController.this.editBlock.addEdit(new OrderCellListEdit(this.list, this.orderPosition));
            }
        }
    }

    protected class SelectNextEdgeInstruction
    extends AbstractController.InteractiveInstruction {
        protected SelectCellsMouseAdapter adapter;
        protected Deque<mxCell> edgeList;

        public SelectNextEdgeInstruction(Deque<mxCell> deque) {
            this.edgeList = deque;
            this.adapter = new SelectCellsMouseAdapter(1, BellmanFordController.this.graphComponent, BellmanFordController.this.graph, false, true);
            this.adapter.setActivated(false);
            BellmanFordController.this.graphComponent.getGraphControl().addMouseListener((MouseListener)this.adapter);
        }

        @Override
        public void preform() {
            if (BellmanFordController.this.state != BellmanFordState.FIRST_RUN) {
                return;
            }
            if (!this.adapter.isActivated()) {
                BellmanFordController.this.graphComponentLabel.setText(BellmanFordController.this.getTextForLabel("Select the next edge for relaxation\n[u\u017eivatelsk\u00e1 akce]"));
                BellmanFordController.this.timer.setEnabled(false);
                this.adapter.setActivated(true);
            } else if (this.adapter.getLastSelected() != null) {
                mxCell mxCell2 = this.adapter.getLastSelected();
                if (this.edgeList.contains(mxCell2)) {
                    BellmanFordController.this.graph.traverseAllCells(new AlgorithmGraph.AlgorithmGraphCellVisitor(){

                        @Override
                        public boolean visit(mxCell mxCell2, GraphCell graphCell) {
                            if (mxCell2.isEdge()) {
                                if (mxCell2 == SelectNextEdgeInstruction.this.adapter.getLastSelected()) {
                                    graphCell.setSelected(true);
                                } else {
                                    graphCell.setSelected(false);
                                }
                            }
                            return true;
                        }

                        @Override
                        public boolean allowEdge() {
                            return true;
                        }
                    });
                    this.stop();
                    return;
                }
                BellmanFordController.this.graphComponentLabel.setText(BellmanFordController.this.getTextForLabel("The edge has been relaxed\n[u\u017eivatelsk\u00e1 akce]"));
            }
            BellmanFordController.this.pause = true;
        }

        @Override
        public int nextTapePos() {
            if (this.adapter.isActivated()) {
                return BellmanFordController.this.tapePosition;
            }
            return super.nextTapePos();
        }

        @Override
        public void stop() {
            if (this.adapter.isActivated()) {
                this.adapter.setActivated(false);
                this.adapter.resetStyles();
                this.adapter.reset();
                BellmanFordController.this.timer.setEnabled(true);
            }
        }
    }

    protected class SetVertexDistanceInstruction
    extends AbstractController.InteractiveInstruction {
        protected Double newDistance;
        protected Double oldDistance;
        protected BellmanFordGraphVertex v;

        protected SetVertexDistanceInstruction() {
        }

        @Override
        public void preform() {
            if (!BellmanFordController.this.graph.isCellsEditable()) {
                BellmanFordController.this.graphComponentLabel.setText(BellmanFordController.this.getTextForLabel("Enter the value of the distance into the nodes for the process of relaxation\n[u\u017eivatelsk\u00e1 akce]"));
                BellmanFordController.this.graph.setCellsEditable(true, true, false);
                BellmanFordController.this.timer.setEnabled(false);
                BellmanFordGraphVertex bellmanFordGraphVertex = (BellmanFordGraphVertex)((mxCell)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableU)).getValue();
                this.v = (BellmanFordGraphVertex)((mxCell)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableV)).getValue();
                BellmanFordGraphEdge bellmanFordGraphEdge = (BellmanFordGraphEdge)((mxCell)BellmanFordController.this.activeVariable).getValue();
                this.v.setEditable(true);
                this.oldDistance = this.v.getDistance();
                this.newDistance = this.v.getDistance() > bellmanFordGraphVertex.getDistance() + bellmanFordGraphEdge.getDistance() ? Double.valueOf(bellmanFordGraphVertex.getDistance() + bellmanFordGraphEdge.getDistance()) : this.v.getDistance();
            } else {
                this.v = (BellmanFordGraphVertex)((mxCell)BellmanFordController.this.getRegisterValue(BellmanFordController.this.variableV)).getValue();
                if (BellmanFordController.this.isDoublesEquals(this.newDistance, this.v.getDistance())) {
                    this.v.setDistance(this.oldDistance);
                    this.stop();
                    return;
                }
                this.v.setDistance(this.oldDistance);
                BellmanFordController.this.graph.refresh();
                BellmanFordController.this.graphComponentLabel.setText(BellmanFordController.this.getTextForLabel("Entered value is wrong\n[u\u017eivatelsk\u00e1 akce]"));
            }
            BellmanFordController.this.pause = true;
        }

        @Override
        public void stop() {
            if (BellmanFordController.this.graph.isCellsEditable()) {
                if (this.v != null) {
                    this.v.setEditable(false);
                }
                BellmanFordController.this.graph.setCellsEditable(false);
                BellmanFordController.this.timer.setEnabled(true);
            }
        }

        @Override
        public int nextTapePos() {
            if (BellmanFordController.this.graph.isCellsEditable()) {
                return BellmanFordController.this.tapePosition;
            }
            return super.nextTapePos();
        }
    }

    public static enum BellmanFordState {
        FIRST_RUN,
        RUN;

    }
}

