/*
 * Decompiled with CFR 0.152.
 */
package program.actions;

import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxResources;
import com.mxgraph.view.mxGraph;
import editor.GraphIO;
import editor.GraphViewPanel;
import editor.StyleDialogMaker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import program.MainPanel;
import program.Program;
import program.actions.GraphComponentAction;
import simulator.graphs.AlgorithmGraph;
import simulator.graphs.BasicStylesheet;
import simulator.graphs.GraphEdgeData;
import simulator.graphs.GraphVertexData;
import simulator.gui.AlgorithmFrame;
import simulator.gui.panels.BellmanFordPanel;
import simulator.gui.panels.BfsPanel;
import simulator.gui.panels.DfsPanel;
import simulator.gui.panels.DijkstraPanel;
import simulator.gui.panels.SccPanel;
import simulator.gui.panels.TopologicalSortPanel;

public class BasicActions {
    private static void simulatorGraphError(MainPanel mainPanel) {
        JOptionPane.showMessageDialog((Component)mainPanel.getGraphComponent(), mxResources.get((String)"SimulatorInputGraphError"), mxResources.get((String)"error"), 0);
    }

    public static class ParallelEdgeLabelAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphViewPanel graphViewPanel = ParallelEdgeLabelAction.getMainPanel(actionEvent).getGraphPanel();
            graphViewPanel.doParallelEdgeLayout();
        }
    }

    public static class HideVertexLabelAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphViewPanel graphViewPanel;
            graphViewPanel.setVertexLabel(!(graphViewPanel = HideVertexLabelAction.getMainPanel(actionEvent).getGraphPanel()).isVertexLabel());
        }
    }

    public static class HideEdgeLabelAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GraphViewPanel graphViewPanel;
            graphViewPanel.setEdgeLabel(!(graphViewPanel = HideEdgeLabelAction.getMainPanel(actionEvent).getGraphPanel()).isEdgeLabel());
        }
    }

    public static class BellmanFordSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph algorithmGraph) {
            Object[] objectArray = algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent());
            return objectArray.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = BellmanFordSimulatorAction.getMainPanel(actionEvent);
            AlgorithmGraph algorithmGraph = new AlgorithmGraph();
            BasicStylesheet basicStylesheet = BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet());
            algorithmGraph.addCells(mainPanel.getGraph().cloneCells(mainPanel.getGraph().getChildCells(mainPanel.getGraph().getDefaultParent())));
            algorithmGraph.setStylesheet(basicStylesheet);
            if (this.isGraphOk(algorithmGraph)) {
                JFrame jFrame = AlgorithmFrame.getAlgorithmFrame(new BellmanFordPanel(algorithmGraph), mxResources.get((String)"BellmanFordSimulatorFrame"));
                jFrame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(mainPanel);
            }
        }
    }

    public static class DijkstraSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph algorithmGraph) {
            Object[] objectArray = algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent());
            return objectArray.length != 0;
        }

        private boolean isNegativeEdgeInGraph(AlgorithmGraph algorithmGraph) {
            for (Object object : algorithmGraph.getChildEdges(algorithmGraph.getDefaultParent())) {
                GraphEdgeData graphEdgeData = (GraphEdgeData)((mxCell)object).getValue();
                if (!(graphEdgeData.getDistance() < 0.0)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = DijkstraSimulatorAction.getMainPanel(actionEvent);
            AlgorithmGraph algorithmGraph = new AlgorithmGraph();
            BasicStylesheet basicStylesheet = BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet());
            algorithmGraph.addCells(mainPanel.getGraph().cloneCells(mainPanel.getGraph().getChildCells(mainPanel.getGraph().getDefaultParent())));
            algorithmGraph.setStylesheet(basicStylesheet);
            if (this.isGraphOk(algorithmGraph)) {
                int n;
                if (this.isNegativeEdgeInGraph(algorithmGraph) && (n = JOptionPane.showConfirmDialog((Component)mainPanel.getGraphComponent(), mxResources.get((String)"SimulatorDijkstraNonValidGraph"), mxResources.get((String)"warning"), 0)) != 0) {
                    return;
                }
                JFrame jFrame = AlgorithmFrame.getAlgorithmFrame(new DijkstraPanel(algorithmGraph), mxResources.get((String)"DijkstraSimulatorFrame"));
                jFrame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(mainPanel);
            }
        }
    }

    public static class TopologicalSortSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph algorithmGraph) {
            Object[] objectArray = algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent());
            return objectArray.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = TopologicalSortSimulatorAction.getMainPanel(actionEvent);
            AlgorithmGraph algorithmGraph = new AlgorithmGraph();
            BasicStylesheet basicStylesheet = BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet());
            algorithmGraph.addCells(mainPanel.getGraph().cloneCells(mainPanel.getGraph().getChildCells(mainPanel.getGraph().getDefaultParent())));
            algorithmGraph.setStylesheet(basicStylesheet);
            if (this.isGraphOk(algorithmGraph)) {
                int n;
                mxAnalysisGraph mxAnalysisGraph2 = new mxAnalysisGraph();
                mxAnalysisGraph2.setGraph((mxGraph)algorithmGraph);
                if (mxGraphStructure.isCyclicDirected((mxAnalysisGraph)mxAnalysisGraph2) && (n = JOptionPane.showConfirmDialog((Component)mainPanel.getGraphComponent(), mxResources.get((String)"SimulatorTopoSortNonValidGraph"), mxResources.get((String)"warning"), 0)) != 0) {
                    return;
                }
                JFrame jFrame = AlgorithmFrame.getAlgorithmFrame(new TopologicalSortPanel(algorithmGraph), mxResources.get((String)"TopologicalSortSimulatorFrame"));
                jFrame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(mainPanel);
            }
        }
    }

    public static class SccSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph algorithmGraph) {
            Object[] objectArray = algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent());
            return objectArray.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = SccSimulatorAction.getMainPanel(actionEvent);
            AlgorithmGraph algorithmGraph = new AlgorithmGraph();
            BasicStylesheet basicStylesheet = BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet());
            algorithmGraph.addCells(mainPanel.getGraph().cloneCells(mainPanel.getGraph().getChildCells(mainPanel.getGraph().getDefaultParent())));
            algorithmGraph.setStylesheet(basicStylesheet);
            if (this.isGraphOk(algorithmGraph)) {
                JFrame jFrame = AlgorithmFrame.getAlgorithmFrame(new SccPanel(algorithmGraph), mxResources.get((String)"SccSimulatorFrame"));
                jFrame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(mainPanel);
            }
        }
    }

    public static class DfsSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph algorithmGraph) {
            Object[] objectArray = algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent());
            return objectArray.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = DfsSimulatorAction.getMainPanel(actionEvent);
            AlgorithmGraph algorithmGraph = new AlgorithmGraph();
            BasicStylesheet basicStylesheet = BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet());
            algorithmGraph.addCells(mainPanel.getGraph().cloneCells(mainPanel.getGraph().getChildCells(mainPanel.getGraph().getDefaultParent())));
            algorithmGraph.setStylesheet(basicStylesheet);
            if (this.isGraphOk(algorithmGraph)) {
                JFrame jFrame = AlgorithmFrame.getAlgorithmFrame(new DfsPanel(algorithmGraph), mxResources.get((String)"DfsSimulatorFrame"));
                jFrame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(mainPanel);
            }
        }
    }

    public static class BfsSimulatorAction
    extends GraphComponentAction {
        private boolean isGraphOk(AlgorithmGraph algorithmGraph) {
            Object[] objectArray = algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent());
            return objectArray.length != 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = BfsSimulatorAction.getMainPanel(actionEvent);
            AlgorithmGraph algorithmGraph = new AlgorithmGraph();
            BasicStylesheet basicStylesheet = BasicStylesheet.getFromMxStylesheet(mainPanel.getGraph().getStylesheet());
            algorithmGraph.addCells(mainPanel.getGraph().cloneCells(mainPanel.getGraph().getChildCells(mainPanel.getGraph().getDefaultParent())));
            algorithmGraph.setStylesheet(basicStylesheet);
            if (this.isGraphOk(algorithmGraph)) {
                JFrame jFrame = AlgorithmFrame.getAlgorithmFrame(new BfsPanel(algorithmGraph), mxResources.get((String)"BfsSimulatorFrame"));
                jFrame.setVisible(true);
            } else {
                BasicActions.simulatorGraphError(mainPanel);
            }
        }
    }

    public static class SetCellSelectedAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = SetCellSelectedAction.getMainPanel(actionEvent);
            mxCell mxCell2 = (mxCell)mainPanel.getGraph().getSelectionCell();
            if (mxCell2 != null) {
                if (mxCell2.isVertex()) {
                    mainPanel.getGraph().getModel().beginUpdate();
                    for (Object object : mainPanel.getGraph().getChildVertices(mainPanel.getGraph().getDefaultParent())) {
                        mxCell mxCell3 = (mxCell)object;
                        GraphVertexData graphVertexData = (GraphVertexData)mxCell3.getValue();
                        if (mxCell3 == mxCell2 && !graphVertexData.getSelected().booleanValue()) {
                            mainPanel.getGraph().getModel().setValue((Object)mxCell3, (Object)new GraphVertexData(graphVertexData.getName(), true));
                            mainPanel.getGraph().getModel().setStyle((Object)mxCell3, "SELECTED_VERTEX_STYLE");
                            continue;
                        }
                        if (!graphVertexData.getSelected().booleanValue()) continue;
                        mainPanel.getGraph().getModel().setValue((Object)mxCell3, (Object)new GraphVertexData(graphVertexData.getName(), false));
                        mainPanel.getGraph().getModel().setStyle((Object)mxCell3, "VERTEX_STYLE");
                    }
                    mainPanel.getGraph().getModel().endUpdate();
                    mainPanel.getGraph().refresh();
                } else {
                    JOptionPane.showMessageDialog((Component)mainPanel.getGraphComponent(), mxResources.get((String)"SelectedEdgeError"), mxResources.get((String)"error"), 0);
                }
            }
        }
    }

    public static class ZoomAction
    extends GraphComponentAction {
        private double zoom;

        public ZoomAction(double d) {
            this.zoom = d;
        }

        public double getZoom() {
            return this.zoom;
        }

        public void setZoom(double d) {
            this.zoom = d;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.zoom > 0.0) {
                mxGraphComponent mxGraphComponent2 = ZoomAction.getMainPanel(actionEvent).getGraphComponent();
                mxGraphComponent2.zoomTo(this.zoom, mxGraphComponent2.isCenterZoom());
            }
        }
    }

    public static class SetStyleAction
    extends GraphComponentAction {
        protected StyleDialogMaker.StyleDialog styleDialog = null;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.styleDialog == null) {
                this.styleDialog = StyleDialogMaker.getStyleDialog(SetStyleAction.getProgramFrame(actionEvent), SetStyleAction.getMainPanel(actionEvent));
            }
            if (!this.styleDialog.isVisible()) {
                this.styleDialog.setStyles(SetStyleAction.getMainPanel(actionEvent).getGraphComponent().getGraph().getStylesheet());
                this.styleDialog.setVisible(true);
            }
        }
    }

    public static class MaximizeAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Program program;
            program.setMaximize(!(program = MaximizeAction.getProgramFrame(actionEvent)).isMaximize());
        }
    }

    public static class EnglishLanguageAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Program program = EnglishLanguageAction.getProgramFrame(actionEvent);
            mxResources.add((String)"resources/english_language");
        }
    }

    public static class CzechLanguageAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Program program = CzechLanguageAction.getProgramFrame(actionEvent);
            mxResources.add((String)"resources/czech_language");
        }
    }

    public static class FullScreenAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Program program;
            program.setFullscreen(!(program = FullScreenAction.getProgramFrame(actionEvent)).isFullScreen());
        }
    }

    public static class ToolBarLabelsAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolBarLabelsAction.getProgramFrame(actionEvent).showOrHideLabels();
        }
    }

    public static class RedoAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RedoAction.getMainPanel(actionEvent).getEditorUndoManager().redo();
        }
    }

    public static class UndoAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UndoAction.getMainPanel(actionEvent).getEditorUndoManager().undo();
        }
    }

    public static class SaveAction
    extends GraphComponentAction {
        protected boolean showDialog;
        protected String lastDir = null;

        public SaveAction(boolean bl) {
            this.showDialog = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            MainPanel mainPanel = SaveAction.getMainPanel(actionEvent);
            mxGraphComponent mxGraphComponent2 = mainPanel.getGraphComponent();
            mxGraph mxGraph2 = mxGraphComponent2.getGraph();
            String string2 = null;
            boolean bl = false;
            if (this.showDialog || mainPanel.getCurrentFile() == null) {
                string = this.lastDir != null ? this.lastDir : (mainPanel.getCurrentFile() != null ? mainPanel.getCurrentFile().getParent() : System.getProperty("user.dir"));
                JFileChooser jFileChooser = new JFileChooser(string);
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return mxResources.get((String)"FileDesc") + " (.xml)";
                    }
                };
                jFileChooser.addChoosableFileFilter(fileFilter);
                jFileChooser.setFileFilter(fileFilter);
                int n = jFileChooser.showDialog(null, mxResources.get((String)"save"));
                bl = true;
                if (n != 0) {
                    return;
                }
                this.lastDir = jFileChooser.getSelectedFile().getParent();
                string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                if (!string2.toLowerCase().endsWith(".xml")) {
                    string2 = string2 + ".xml";
                }
                if (new File(string2).exists() && JOptionPane.showConfirmDialog((Component)mxGraphComponent2, mxResources.get((String)"overwriteExistingFile")) != 0) {
                    return;
                }
            } else {
                string2 = mainPanel.getCurrentFile().getAbsolutePath();
            }
            try {
                string = string2.substring(string2.lastIndexOf(46) + 1);
                if (string.equalsIgnoreCase("xml")) {
                    GraphIO.writeGraph(mxGraph2, Paths.get(string2, new String[0]));
                    mainPanel.setModified(false);
                    mainPanel.setCurrentFile(new File(string2));
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog((Component)mainPanel.getGraphComponent(), iOException.getMessage(), mxResources.get((String)"error"), 0);
            }
        }
    }

    public static class OpenAction
    extends GraphComponentAction {
        protected String lastDir;

        private boolean checkGraphNames(AlgorithmGraph algorithmGraph) {
            for (Object object : algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent())) {
                for (Object object2 : algorithmGraph.getChildVertices(algorithmGraph.getDefaultParent())) {
                    if (object == object2) continue;
                    GraphVertexData graphVertexData = (GraphVertexData)((mxCell)object).getValue();
                    GraphVertexData graphVertexData2 = (GraphVertexData)((mxCell)object2).getValue();
                    if (!graphVertexData.getName().isEmpty() && !graphVertexData.getName().equalsIgnoreCase(graphVertexData2.getName())) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean checkGraphCells(AlgorithmGraph algorithmGraph) {
            for (Object object : algorithmGraph.getChildEdges(algorithmGraph.getDefaultParent())) {
                mxCell mxCell2 = (mxCell)object;
                if (mxCell2.isVertex()) {
                    if (mxCell2.getValue() instanceof GraphVertexData) continue;
                    return false;
                }
                if (!(mxCell2.getValue() instanceof GraphEdgeData)) {
                    return false;
                }
                if (mxCell2.getSource() != null && mxCell2.getTarget() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            mxGraph mxGraph2;
            MainPanel mainPanel = OpenAction.getMainPanel(actionEvent);
            if (!(mainPanel.isModified() && JOptionPane.showConfirmDialog(mainPanel, mxResources.get((String)"loseChanges"), mxResources.get((String)"warningSaveTitle"), 0) != 0 || (mxGraph2 = mainPanel.getGraphComponent().getGraph()) == null)) {
                String string = this.lastDir != null ? this.lastDir : System.getProperty("user.dir");
                JFileChooser jFileChooser = new JFileChooser(string);
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
                    }

                    @Override
                    public String getDescription() {
                        return mxResources.get((String)"FileDesc") + " (.xml)";
                    }
                };
                jFileChooser.addChoosableFileFilter(fileFilter);
                jFileChooser.setFileFilter(fileFilter);
                int n = jFileChooser.showDialog(null, mxResources.get((String)"openFile"));
                if (n == 0) {
                    this.lastDir = jFileChooser.getSelectedFile().getParent();
                    try {
                        AlgorithmGraph algorithmGraph = GraphIO.readGraph(Paths.get(jFileChooser.getSelectedFile().getAbsolutePath(), new String[0]));
                        if (!this.checkGraphNames(algorithmGraph)) {
                            JOptionPane.showMessageDialog((Component)mainPanel.getGraphComponent(), mxResources.get((String)"badVertexNameLoadError"), mxResources.get((String)"error"), 0);
                            return;
                        }
                        if (!this.checkGraphCells(algorithmGraph)) {
                            JOptionPane.showMessageDialog((Component)mainPanel.getGraphComponent(), mxResources.get((String)"badCellLoadError"), mxResources.get((String)"error"), 0);
                            return;
                        }
                        mainPanel.setGraph(algorithmGraph);
                        mainPanel.setCurrentFile(jFileChooser.getSelectedFile());
                        mainPanel.setModified(false);
                        mainPanel.getEditorUndoManager().clear();
                        mainPanel.getGraphComponent().zoomAndCenter();
                    }
                    catch (GraphIO.GraphIOBadXmlException | IOException | ParserConfigurationException | SAXException exception) {
                        JOptionPane.showMessageDialog((Component)mainPanel.getGraphComponent(), exception.getMessage(), mxResources.get((String)"error"), 0);
                    }
                }
            }
        }
    }

    public static class NewAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = NewAction.getMainPanel(actionEvent);
            if (!(mainPanel == null || mainPanel.isModified() && JOptionPane.showConfirmDialog(mainPanel, mxResources.get((String)"loseChanges")) != 0)) {
                mainPanel.getGraphPanel().clearGraph();
                mainPanel.getEditorUndoManager().clear();
                mainPanel.setModified(false);
                mainPanel.setCurrentFile(null);
                mainPanel.getGraphComponent().zoomAndCenter();
            }
        }
    }

    public static class ShowManualAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShowManualAction.getProgramFrame(actionEvent).manual();
        }
    }

    public static class AboutAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AboutAction.getProgramFrame(actionEvent).about();
        }
    }

    public static class ExitAction
    extends GraphComponentAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel mainPanel = ExitAction.getMainPanel(actionEvent);
            if (!mainPanel.isModified() || JOptionPane.showConfirmDialog(mainPanel, mxResources.get((String)"loseChanges"), mxResources.get((String)"warningSaveTitle"), 0) == 0) {
                System.exit(0);
            }
        }
    }
}

