<?php

require_once("Database_Base.php");

class Database_Json extends Database_Base
{
    public function __construct($name, $ns)
    {
        parent::__construct($name, $ns);
        if (!@file_exists($this->getPath()))
        {
            $json = array("nextP" => 1, "nextA" => 1,
                "publications" => array(), "authors" => array());
            $this->save($json);
        }
    }

    public function getExtension() { return "json"; }

    public function get($id)
    {
        $json = $this->load();
        foreach ($json['publications'] as $zdroj)
            if ($zdroj['id'] == $id)
            {
                $this->normalize($zdroj, 'comment');
                $this->normalize($zdroj, 'file');
                if (!empty($zdroj['author']))
                    foreach ($zdroj['author'] as &$author)
                        $author = $this->getAuthor($json, $author);
                if (!empty($zdroj['crossref']) && $zdroj['crossref'] != $id)
                    $zdroj['crossref'] = $this->get($zdroj['crossref']);
                return $zdroj;
            }
        return null;
    }

    private function getAuthor($json, $id)
    {
        foreach ($json['authors'] as $author)
            if ($author['id'] == $id)
                return $author;
        return null;
    }

    private function normalize(&$array, $field)
    {
        if (empty($array[$field]))
            $array[$field] = array();
        elseif (!is_array($array[$field]))
            $array[$field] = array($array[$field]);
    }

    public function find($data)
    {
        $json = $this->load();
        $result = array();

        foreach ($json['publications'] as $zdroj)
        {
            foreach ($zdroj['author'] as &$author)
                $author = $this->getAuthor($json, $author);
            if ($this->findFilter($zdroj, $data))
                $result[] = $zdroj;
        }
        return $result;
    }

    private function findFilter($zdroj, $data)
    {
        foreach ($data as $key => $value)
        {
            if ($key == 'author')
            {
                $filter = false;
                foreach ($zdroj[$key] as $author)
                    if (stripos($author['name'], $value) !== false)
                        $filter = true;
                if (!$filter)
                    return false;
            }
            else if (stripos($zdroj[$key], $value) === false)
                return false;
        }
        return true;
    }

    public function add($data)
    {
        $json = $this->load();

        $authors = array();
        if (!empty($data['author']))
            foreach ($data['author'] as $author)
                $authors[] = $this->addAuthor($json, $author);
        $data['author'] = $authors;

        $data['id'] = $json["nextP"]++;
        $json['publications'][] = $data;
        $this->save($json);
        return $data['id'];
    }

    private function addAuthor(&$json, $data)
    {
        foreach ($json['authors'] as &$author)
            if ($author['name'] == $data['name'])
            {
                if (!empty($data['url']))
                {
                    if (filter_var($data['url'], FILTER_VALIDATE_URL) === FALSE)
                        $data['url'] = null;
                    $author['url'] = $data['url'];
                }
                return $author['id'];
            }

        if (filter_var($data['url'], FILTER_VALIDATE_URL) === FALSE)
            $data['url'] = null;
        $data['id'] = $json["nextA"]++;
        $json['authors'][] = $data;
        return $data['id'];
    }

    public function edit($id, $data)
    {
        $json = $this->load();
        foreach ($json['publications'] as &$zdroj)
            if ($zdroj['id'] == $id)
            {
                $authors = array();
                if (!empty($data['author']))
                    foreach ($data['author'] as $author)
                        $authors[] = $this->addAuthor($json, $author);
                $data['author'] = $authors;

                $data['id'] = $id;
                $data['comment'] = $zdroj['comment'];
                $data['file'] = $zdroj['file'];
                $zdroj = $data;
                $this->save($json);
                return;
            }
    }

    public function remove($id)
    {
        $json = $this->load();
        foreach ($json['publications'] as $index => $zdroj)
            if ($zdroj['id'] == $id)
            {
                if (!empty($zdroj['author']))
                    foreach ($zdroj['author'] as $author)
                        $this->removeAuthor($json, $author, $id);

                unset($json['publications'][$index]);
                $this->save($json);
                return;
            }
    }

    private function removeAuthor(&$json, $id, $currentId)
    {
        foreach ($json['publications'] as $zdroj)
            if (!empty($zdroj['author']))
                foreach ($zdroj['author'] as $author)
                    if ($author == $id && $zdroj['id'] != $currentId)
                        return;

        foreach ($json['authors'] as $index => $author)
            if ($author['id'] == $id)
                unset($json['authors'][$index]);
    }

    public function addComment($id, $author, $text)
    {
        $json = $this->load();
        foreach ($json['publications'] as &$zdroj)
            if ($zdroj['id'] == $id)
            {
                $zdroj['comment'][] = array('author' => $author, 'text' => $text, 'date' => time());
                $this->save($json);
                return;
            }
    }

    public function editComment($id, $date, $text)
    {
        $json = $this->load();
        foreach ($json['publications'] as &$zdroj)
            if ($zdroj['id'] == $id)
                foreach ($zdroj['comment'] as &$comment)
                    if ($comment['date'] == $date)
                    {
                        $comment['text'] = $text;
                        $this->save($json);
                        return;
                    }
    }

    public function removeComment($id, $date)
    {
        $json = $this->load();
        foreach ($json['publications'] as &$zdroj)
            if ($zdroj['id'] == $id)
                foreach ($zdroj['comment'] as $index => $comment)
                    if ($comment['date'] == $date)
                    {
                        unset($zdroj['comment'][$index]);
                        $this->save($json);
                        return;
                    }
    }

    public function addFile($id, $name, $date)
    {
        $json = $this->load();
        foreach ($json['publications'] as &$zdroj)
            if ($zdroj['id'] == $id)
            {
                foreach ($zdroj['file'] as $index => $file)
                    if ($file['name'] == $name)
                    {
                        $zdroj['file'][$index] = $date;
                        $this->save($json);
                        return;
                    }
                $zdroj['file'][] = array('name' => $name, 'date' => $date);
                $this->save($json);
                return;
            }
    }

    public function removeFile($id, $name)
    {
        $json = $this->load();
        foreach ($json['publications'] as &$zdroj)
            if ($zdroj['id'] == $id)
                foreach ($zdroj['file'] as $index => $file)
                    if ($file['name'] == $name)
                    {
                        unset($zdroj['file'][$index]);
                        $this->save($json);
                        return;
                    }
    }

    public function isPublicFile($name)
    {
        $json = $this->load();
        foreach ($json['publications'] as $zdroj)
        {
            if (!array_key_exists('file', $zdroj))
                continue;

            foreach ($zdroj['file'] as $file)
                if ($file['name'] == $name)
                    return new DateTime($file['date']) <= new DateTime();
        }
        return true;
    }

    protected function load() { return json_decode(parent::load(), true); }
    protected function save($data) { parent::save(json_encode($data)); }
}