<?php

if (!defined('DOKU_INC'))
    die();

require_once('db/Databases.php');
require_once('db/Publications.php');
require_once('config.php');

class syntax_plugin_publications extends DokuWiki_Syntax_Plugin
{
    public function getType() { return 'substition'; }
    public function getSort() { return 0; }

    public function connectTo($mode)
    {
        $this->Lexer->addSpecialPattern('\{\{' . Config::get('insertStr') . '>[^}]*\}\}', $mode, 'plugin_publications');
    }

    public function handle($match, $state, $pos, Doku_Handler &$handler)
    {
        preg_match('/\{\{' . Config::get('insertStr') . '>(.*)\}\}/', $match, $matches);
        return array('db' => $matches[1]);
    }

    public function render($mode, Doku_Renderer &$renderer, $data)
    {
        if ($mode != 'xhtml')
            return false;

        $renderer->info['cache'] = false;
        $renderer->doc .= "<h1>$data[db]</h1>";

        $db = Databases::get($data['db']);
        if ($db == null)
        {
            $renderer->doc .= '<p>' . sprintf($this->getLang('dbNotFound'), $data['db']) . '</p>';
            return true;
        }

        if ($this->getAuth($db) < AUTH_READ)
        {
            $renderer->doc .= '<p>' . $this->getLang('authDenied') . '</p>';
            return true;
        }

        global $INPUT;
        switch ($INPUT->str('mode', 'search'))
        {
            case 'show':
                $this->renderShow($db, $renderer);
                break;
            case 'add':
                $this->renderAdd($db, $renderer);
                break;
            case 'search':
                $this->renderSearch($db, $renderer);
                break;
        }
        return true;
    }

    /* ------------------------------------ */
    /* --------------- SHOW --------------- */
    /* ------------------------------------ */
    private function renderShow(Database_Base $db, Doku_Renderer &$renderer)
    {
        global $INPUT, $ID;
        if ($INPUT->str('remove') == $db->getName() && $this->getAuth($db) >= AUTH_EDIT)
        {
            $db->remove($INPUT->int('itemID'));
            $renderer->doc .= sprintf('<p>%s <a class="publications-redirect" href="%s">%s</a></p>',
                $this->getLang("itemRemoved"), wl($ID), $this->getLang("redirecting"));
            return;
        }
        if ($INPUT->str('save') == $db->getName() && $this->getAuth($db) >= AUTH_EDIT)
            $db->edit($INPUT->int('itemID'), $this->getData());

        $result = $db->get($INPUT->int('itemID'));
        if (empty($result))
        {
            $renderer->doc .= $this->getLang("invalidId");
            return;
        }

        $link = wl($ID, array('mode' => 'show', 'itemID' => $INPUT->int('itemID')), false, "&");
        $renderer->doc .= sprintf('<div id="publications-%s">', $INPUT->has('edit') ? 'edit' : 'show');
        $renderer->doc .= '<form action="' . $link . '" method="post">';

        $renderer->doc .= '<table>';
        $this->renderInfo($renderer, $INPUT->str('edit') == $db->getName() ? $db : null, $result);

        $renderer->doc .= '<table>';
        $renderer->doc .= '<tr>';
        if ($this->getAuth($db) >= AUTH_EDIT)
        {
            if ($INPUT->has('edit'))
            {
                $renderer->doc .= sprintf('  <td><button type="submit" name="save" value="%s">%s</button></td>',
                    $db->getName(), $this->getLang("btnSave"));
                $renderer->doc .= sprintf('  <td><button type="submit" name="cancel" value="%s">%s</button></td>',
                    $db->getName(), $this->getLang("btnCancel"));
            }
            else
                $renderer->doc .= sprintf('  <td><button type="submit" name="edit" value="%s">%s</button></td>',
                    $db->getName(), $this->getLang("btnEdit"));
            $renderer->doc .= sprintf('  <td><button type="submit" name="remove" value="%s">%s</button></td>',
                $db->getName(), $this->getLang("btnRemove"));
        }
        $renderer->doc .= '</tr>';
        $renderer->doc .= '</table>';

        $renderer->doc .= '</form>';
        $renderer->doc .= '</div>';

        $renderer->doc .= '<div id="publications-tabs">';
        $renderer->doc .= '  <ul>';
        $renderer->doc .= '    <li><a href="#tabs-1">' . $this->getLang('tabComments') . '</a></li>';
        $renderer->doc .= '    <li><a href="#tabs-2">' . $this->getLang('tabFiles') . '</a></li>';
        $renderer->doc .= '    <li><a href="#tabs-3">' . $this->getLang('tabChildren') . '</a></li>';
        if (!$INPUT->has('edit'))
            $renderer->doc .= '    <li><a href="#tabs-4">BibTeX</a></li>';
        $renderer->doc .= '  </ul>';

        $renderer->doc .= '  <div id="tabs-1">';
        $this->renderComments($db, $renderer);
        $renderer->doc .= '  </div>';
        $renderer->doc .= '  <div id="tabs-2">';
        $this->renderFiles($db, $renderer);
        $renderer->doc .= '  </div>';
        $renderer->doc .= '  <div id="tabs-3">';
        $this->renderChildren($db, $renderer);
        $renderer->doc .= '  </div>';
        if (!$INPUT->has('edit'))
        {
            $renderer->doc .= '  <div id="tabs-4">';
            $renderer->doc .= '    <p id="publications-export"></p>';
            $renderer->doc .= '  </div>';
        }
        $renderer->doc .= '</div>';
    }

    private function renderChildren(Database_Base $db, Doku_Renderer &$renderer)
    {
        global $ID, $INPUT;
        $renderer->doc .= '<div id="publications-children">';
        $this->renderResults($db, $renderer, array('crossref' => $INPUT->str('itemID')));
        if ($this->getAuth($db) >= AUTH_EDIT)
        {
            $renderer->doc .= '  <form action="' . wl($ID) . '" method="get">';
            $renderer->doc .= '    <input type="hidden" name="id" value="' . $ID . '">';
            $renderer->doc .= '    <input type="hidden" name="crossref" value="' . $INPUT->int('itemID') . '">';
            $renderer->doc .= sprintf('<button type="submit" name="mode" value="add">%s</button>', $this->getLang("btnAdd"));
            $renderer->doc .= '  </form>';
        }
        $renderer->doc .= '</div>';
    }

    private function renderFiles(Database_Base $db, Doku_Renderer &$renderer)
    {
        global $ID, $INPUT;
        if ($INPUT->has('addFile') && $this->getAuth($db) >= AUTH_EDIT)
        {
            $name = cleanID($_FILES['file']['name']);
            $path = mediaFN($db->getNS() . ':' . $name);
            if (!file_exists($path) || $INPUT->has('overrideFile'))
            {
                move_uploaded_file($_FILES['file']['tmp_name'], $path);
                $db->removeFile($INPUT->int('itemID'), $name);
                $db->addFile($INPUT->int('itemID'), $name, $INPUT->str('date'));
            }
            else
                $fileError = "File already exists!";
        }

        if ($INPUT->str('removeFile', '', true) != '' && $this->getAuth($db) >= AUTH_EDIT)
        {
            $db->removeFile($INPUT->int('itemID'), $INPUT->str('removeFile'));
            @unlink(mediaFN($db->getNS() . ':' . $INPUT->str('removeFile')));
        }
        $result = $db->get($INPUT->int('itemID'));

        $link = wl($ID, array('mode' => 'show', 'itemID' => $INPUT->int('itemID')), false, "&");
        $renderer->doc .= '<div id="publications-files">';
        $renderer->doc .= '<form action="' . $link . '#tabs-2" method="post" enctype="multipart/form-data">';
        $renderer->doc .= '<table>';
        foreach ($result['file'] as $file)
        {
            if ($this->getAuth($db, $file['name']) < AUTH_READ)
                continue;
            $renderer->doc .= '<tr>';
            $renderer->doc .= '  <td>';
            $renderer->internalmedia($db->getNS($file['name']), null, null, null, null, null, 'linkonly');
            $renderer->doc .= '  </td>';
            if ($this->getAuth($db) >= AUTH_EDIT)
            {
                $renderer->doc .= '  <td>' . $file['date'] . '</td>';
                $renderer->doc .= sprintf('<td><button type="submit" name="removeFile" value="%s">%s</button></td>',
                    $file['name'], $this->getLang("btnRemove"));
            }
            $renderer->doc .= '</tr>';
        }
        if ($this->getAuth($db) >= AUTH_EDIT)
        {
            $renderer->doc .= '<tr>';
            $renderer->doc .= '  <td><input type="file" name="file"></td>';
            $renderer->doc .= '  <td><input name="date"></td>';
            $renderer->doc .= '  <td><button type="submit" name="addFile">' . $this->getLang("btnSend") . '</button></td>';
            $renderer->doc .= '  <td><input type="checkbox" name="overrideFile">' . $this->getLang("btnOverride") . '</td>';
            $renderer->doc .= '</tr>';
        }
        if (!empty($fileError))
            $renderer->doc .= '<tr><td colspan="4">' . $fileError . '</td></tr>';
        $renderer->doc .= '</table>';
        $renderer->doc .= '</form>';
        $renderer->doc .= '</div>';
    }

    private function renderComments(Database_Base $db, Doku_Renderer &$renderer)
    {
        global $ID, $INPUT, $USERINFO;
        if ($INPUT->has('addComment') && $this->getAuth($db) >= AUTH_EDIT)
            $db->addComment($INPUT->int('itemID'), $USERINFO['name'], $INPUT->str('comment'));

        if ($INPUT->int('saveComment') != 0 && $this->getAuth($db) >= AUTH_EDIT)
            $db->editComment($INPUT->int('itemID'), $INPUT->int('saveComment'), $INPUT->str('commentEdit'));

        if ($INPUT->int('removeComment') != 0 && $this->getAuth($db) >= AUTH_EDIT)
            $db->removeComment($INPUT->int('itemID'), $INPUT->int('removeComment'));

        $result = $db->get($INPUT->int('itemID'));

        $link = wl($ID, array('mode' => 'show', 'itemID' => $INPUT->int('itemID')), false, "&");
        $renderer->doc .= '<div id="publications-comments">';
        $renderer->doc .= '<table>';
        $renderer->doc .= '<form action="' . $link . '" method="post">';
        foreach ($result['comment'] as $comment)
        {
            $renderer->doc .= '<tr>';
            $renderer->doc .= sprintf('<th>%s:</th>', $comment['author']);
            $renderer->doc .= '<td colspan="1">';
            $renderer->doc .= sprintf('<span>(%s) </span>', date('d F Y H:i:s', $comment['date']));
            if ($comment['author'] == $USERINFO['name'])
            {
                if ($INPUT->int('editComment') == $comment['date'])
                    $renderer->doc .= sprintf('<button type="submit" name="saveComment" value="%s">%s</button>',
                        $comment['date'], $this->getLang("btnSave"));
                else
                    $renderer->doc .= sprintf('<button type="submit" name="editComment" value="%s">%s</button>',
                        $comment['date'], $this->getLang("btnEdit"));
                $renderer->doc .= sprintf('<button type="submit" name="removeComment" value="%s">%s</button>',
                    $comment['date'], $this->getLang("btnRemove"));
            }
            $renderer->doc .= '</td>';
            $renderer->doc .= '</tr>';

            $renderer->doc .= '<tr>';
            if ($INPUT->int('editComment') == $comment['date'])
            {
                $renderer->doc .= '<td colspan="2">';
                $renderer->doc .= '  <textarea name="commentEdit">' . $comment['text'] . '</textarea>';
                $renderer->doc .= '</td>';
            }
            else
                $renderer->doc .= '<td colspan="2">' . $renderer->render_text($comment['text']) . '</td>';
            $renderer->doc .= '</tr>';
        }
        $renderer->doc .= '</form>';

        if ($this->getAuth($db) >= AUTH_EDIT)
        {
            $renderer->doc .= '<form action="' . $link . '" method="post">';
            $renderer->doc .= '<tr><td colspan="2"><textarea name="comment"></textarea></td></tr>';
            $renderer->doc .= sprintf('<tr><td colspan="2"><button type="submit" name="addComment">%s</button></td></tr>',
                $this->getLang("btnSend"));
            $renderer->doc .= '</form>';
        }
        $renderer->doc .= '</table>';
        $renderer->doc .= '</div>';
    }
    /* ----------------------------------- */
    /* --------------- ADD --------------- */
    /* ----------------------------------- */
    private function renderAdd(Database_Base $db, Doku_Renderer &$renderer)
    {
        if ($this->getAuth($db) < AUTH_EDIT)
        {
            $renderer->doc .= '<p>' . $this->getLang('authDenied') . '</p>';
            return true;
        }

        global $ID, $INPUT;
        if ($INPUT->str('add') == $db->getName())
        {
            $id = $db->add($this->getData());
            $link = wl($ID, array("mode" => "show", "itemID" => $id), false, "&");
            $renderer->doc .= sprintf('<p>%s <a class="publications-redirect" href="%s">%s</a></p>',
                $this->getLang("itemAdded"), $link, $this->getLang("redirecting"));
            return;
        }

        $link = wl($ID, array("mode" => 'add'), false, "&");
        $renderer->doc .= '<div id="publications-add">';
        $renderer->doc .= '<form action="' . $link . '" method="post">';

        $renderer->doc .= '<table>';
        $this->renderInfo($renderer, $db);
        $renderer->doc .= '<tr>';
        $renderer->doc .= sprintf('  <td><button type="submit" name="add" value="%s">%s</button></td>',
            $db->getName(), $this->getLang("btnAdd"));
        $renderer->doc .= '  <td><button type="button" id="publications-import">' . $this->getLang("btnImport") . '</button></td>';
        $renderer->doc .= '</tr>';
        $renderer->doc .= '</table>';

        $renderer->doc .= '</form>';
        $renderer->doc .= '</div>';

        $renderer->doc .= '<div id="publications-dialog" title="Import">';
        $renderer->doc .= '  <p>Insert bibtex citation</p>';
        $renderer->doc .= '  <textarea></textarea>';
        $renderer->doc .= '</div>';
    }

    private function renderInfo(Doku_Renderer &$renderer, Database_Base $db = null, $result = null, $search = false)
    {
        $renderer->doc .= '<colgroup><col><col></colgroup>';
        $renderer->doc .= '<tr>';
        $renderer->doc .= '<td><table>';
        $renderer->doc .= $this->renderCrossref($db, $result);
        $renderer->doc .= $this->renderType($db, $result, $search);
        $renderer->doc .= '  <tr>' . $this->renderRow("title", $db, $result) . '</tr>';
        $renderer->doc .= '  <tr>' . $this->renderRow("booktitle", $db, $result) . '</tr>';
        $renderer->doc .= '  <tr>' . $this->renderRow("series", $db, $result) . '</tr>';
        $renderer->doc .= '  <tr>' . $this->renderRow("journal", $db, $result) . '</tr>';
        $renderer->doc .= '</table></td>';
        $renderer->doc .= '<td>' . $this->renderAuthors($db, $result, $search) . '</td>';
        $renderer->doc .= '</tr>';

        $renderer->doc .= '<tr>';
        $renderer->doc .= '<td><table>';
        $renderer->doc .= $this->renderRow("volume", $db, $result);
        $renderer->doc .= $this->renderRow("number", $db, $result);
        $renderer->doc .= '  </tr>';
        $renderer->doc .= '  <tr>';
        $renderer->doc .= $this->renderRow("chapter", $db, $result);
        $renderer->doc .= $this->renderRow("pages", $db, $result);
        $renderer->doc .= '  </tr>';
        $renderer->doc .= '  <tr>';
        $renderer->doc .= $this->renderRow("edition", $db, $result);
        $renderer->doc .= $this->renderRow("doi", $db, $result);
        $renderer->doc .= '  </tr>';
        $renderer->doc .= '  <tr>';
        $renderer->doc .= $this->renderRow("isbn", $db, $result);
        $renderer->doc .= $this->renderRow("issn", $db, $result);
        $renderer->doc .= '  </tr>';
        $renderer->doc .= '  <tr>' . $this->renderRow("url", $db, $result, 3, true) . '</tr>';
        $renderer->doc .= '</table></td>';

        $renderer->doc .= '<td><table>';
        $renderer->doc .= '  <tr>' . $this->renderRow("editor", $db, $result, 3) . '</tr>';
        $renderer->doc .= '  <tr>' . $this->renderRow("publisher", $db, $result, 3) . '</tr>';
        $renderer->doc .= '  <tr>';
        $renderer->doc .= $this->renderRow("location", $db, $result);
        $renderer->doc .= $this->renderRow("year", $db, $result);
        $renderer->doc .= '  </tr>';
        $renderer->doc .= '  <tr>' . $this->renderRow("institution", $db, $result, 3) . '</tr>';
        $renderer->doc .= '  <tr>' . $this->renderRow("note", $db, $result, 3) . '</tr>';
        $renderer->doc .= '</table></td>';
        $renderer->doc .= '</tr>';
    }

    private function renderCrossref(Database_Base $db = null, $result = null)
    {
        global $INPUT, $ID;
        $str = '  <tr>';
        $str .= '    <th>' . $this->getLang("crossref") . ':</th>';
        $str .= '    <td>';
        $crossref = $INPUT->str("crossref");
        if ($result != null)
            $crossref = $result['crossref'];
        if ($db != null)
        {
            if (!empty($crossref))
                $crossref = $crossref['id'];
            $str .= sprintf('<input name="crossref" value="%s" title="Insert URL of parent publication"/>', $crossref);
        }
        else if (!empty($crossref))
        {
            $link = wl($ID, array('mode' => 'show', 'itemID' => $crossref['id']), false, '&');
            $title = $crossref['title'];
            if (empty($title))
                $title = $crossref['id'];
            $str .= sprintf('<a href="%s">%s</a>', $link, $title);
        }
        $str .= '    </td>';
        $str .= '  </tr>';
        return $str;
    }

    private function renderType(Database_Base $db = null, $result = null, $search = false)
    {
        global $INPUT;
        $str = '  <tr>';
        $str .= '    <th>' . $this->getLang("type") . ':</th>';
        $str .= '    <td>';
        $type = $INPUT->str("type", "misc");
        if ($result != null)
            $type = $result['type'];
        if ($db != null)
        {
            $str .= '<select name="type">';
            if ($search)
            {
                $type = $INPUT->str("type");
                $str .= '<option value="" selected="selected">';
            }
            foreach (Publications::getTypes() as $t)
            {
                $selected = $type == $t ? ' selected="selected"' : '';
                $str .= sprintf('<option value="%s"%s>%s', $t, $selected, $this->getLang($t));
            }
            $str .= '</select>';
        }
        else
            $str .= sprintf('<span id="publications-field-type-%s">%s</span>', $type, $this->getLang($type));
        $str .= '    </td>';
        $str .= '  </tr>';
        return $str;
    }

    private function renderAuthors(Database_Base $db = null, $result = null, $search = false)
    {
        $str = '<table class="publications-authors">';
        if ($search)
            $str .= $this->renderAuthorsSearch($db);
        else if ($db == null)
            $str .= $this->renderAuthorsShow($result);
        else if ($result == null)
            $str .= $this->renderAuthorsAdd($db);
        else
            $str .= $this->renderAuthorsEdit($db, $result);
        $str .= '</table>';
        return $str;
    }

    private function renderAuthorsSearch(Database_Base $db = null)
    {
        global $INPUT;
        $str = sprintf('<tr><th></th><th>%s</th></tr>', $this->getLang("author"));
        $str .= '<tr>';
        $str .= '  <th class="publications-authors-fill"></th>';
        $str .= sprintf('<td><input type="text" id="%s" name="author" value="%s" class="publications-autocomplete"></td>',
            $db->getName(), $INPUT->str('author'));
        $str .= ' </tr>';
        return $str;
    }

    private function renderAuthorsShow($result = null)
    {
        $str = sprintf('<tr><th></th><th>%s</th></tr>', $this->getLang("author"));
        foreach ($result['author'] as $index => $author)
        {
            $str .= '<tr>';
            $str .= '  <th class="publications-authors-fill"></th>';
            $str .= '  <td>';
            $url = $author['url'];
            if (empty($url))
                $str .= sprintf('<span id="publications-field-author">%s</span>', $author['name']);
            else
                $str .= sprintf('<a id="publications-field-author" href="%s">%s</a>', $url, $author['name']);
            $str .= '  </td>';
            $str .= ' </tr>';
        }
        return $str;
    }

    private function renderAuthorsAdd(Database_Base $db = null)
    {
        global $INPUT;
        $str = sprintf('<tr><th></th><th>%s</th><th>%s</th><th></th></tr>',
            $this->getLang("author"), $this->getLang("homepage"));
        $str .= '<tr>';
        $str .= '  <th class="publications-authors-fill"></th>';
        $str .= sprintf('<td><input type="text" id="%s" name="author[0]" value="%s" class="publications-autocomplete"></td>',
            $db->getName(), $INPUT->str('author'));
        $str .= sprintf('<td><input type="text" id="%s" name="authorUrl[0]" value="%s"></td>',
            $db->getName(), $INPUT->str('authorUrl'));
        $str .= '  <td><button type="button" class="ui-icon ui-icon-circle-plus publications-authors-add"></button></td>';
        $str .= '</tr>';
        return $str;
    }

    private function renderAuthorsEdit(Database_Base $db = null, $result = null)
    {
        $str = '<tr><td></td><th>Author</th><th>Homepage</th><td></td></tr>';
        if (empty($result['author']))
            $result['author'][] = '';
        foreach ($result['author'] as $index => $value)
        {
            $str .= '<tr>';
            $str .= '  <th class="publications-authors-fill"></th>';
            $str .= sprintf('<td><input type="text" id="%s" name="author[%s]" class="publications-autocomplete" value="%s"></td>',
                $db->getName(), $index, $value['name']);
            $str .= sprintf('<td><input type="text" id="%s" name="authorUrl[%s]" value="%s"></td>',
                $db->getName(), $index, $value['url']);
            if ($index == 0)
                $str .= '<td><button type="button" class="ui-icon ui-icon-circle-plus publications-authors-add"></button></td>';
            else
                $str .= '<td><button type="button" class="ui-icon ui-icon-circle-minus publications-authors-rem"></button></td>';
            $str .= '</tr>';
        }
        return $str;
    }

    /* -------------------------------------- */
    /* --------------- SEARCH --------------- */
    /* -------------------------------------- */
    private function renderSearch(Database_Base $db, Doku_Renderer &$renderer)
    {
        global $ID;
        $link = wl($ID, array(), false, '&');
        $renderer->doc .= '<div id="publications-search">';
        $renderer->doc .= '<form action="' . $link . '" method="get">';
        $renderer->doc .= '<input type="hidden" name="id" value="' . $ID . '">';

        $renderer->doc .= '<table>';
        $this->renderInfo($renderer, $db, null, true);
        $renderer->doc .= '<tr>';
        $renderer->doc .= '  <td><button type="submit">' . $this->getLang("btnSearch") . '</button></td>';
        if ($this->getAuth($db) >= AUTH_EDIT)
        {
            $link = wl($ID, array("mode" => "add"), false, '&');
            $renderer->doc .= sprintf('  <td><a href="%s">%s</a></td>',
                $link, $this->getLang("btnAdd"));
        }
        $renderer->doc .= '</tr>';
        $renderer->doc .= '</table>';

        $renderer->doc .= '</form>';
        $renderer->doc .= '</div>';

        $this->renderResults($db, $renderer, $this->getData(), Config::get('pageCount', 25));
    }

    private function renderResults(Database_Base $db, Doku_Renderer &$renderer, $data, $count = -1)
    {
        global $ID, $INPUT;
        $renderer->doc .= '<div id="publications-results">';
        $renderer->doc .= '<table>';
        $renderer->doc .= '  <tr>';
        $renderer->doc .= '    <th></th>';
        $this->renderHeader($renderer, 'type');
        $this->renderHeader($renderer, 'title');
        $this->renderHeader($renderer, 'author');
        $this->renderHeader($renderer, 'publisher');
        $this->renderHeader($renderer, 'year');
        $renderer->doc .= '  </tr>';

        $data = $db->find($data);
        if ($INPUT->has('sort'))
            usort($data, array($this, 'sortResults'));

        $start = $INPUT->int('start');
        if ($count == -1)
            $end = count($data) - $start;
        else
            $end = $start + $count;
        for ($index = $start; $index < min($end, count($data)); $index++)
        {
            $row = $data[$index];
            $link = wl($ID, array('mode' => 'show', 'itemID' => $row['id']), false, '&');

            $renderer->doc .= '  <tr>';
            $renderer->doc .= '    <td><a class="ui-icon ui-icon-extlink" href="' . $link . '"/></td>';
            $renderer->doc .= '    <td>' . $this->getLang($row['type']) . '</td>';
            $renderer->doc .= '    <td>' . $row['title'] . '</a></td>';

            $authors = '';
            foreach ($row['author'] as $i => $author)
            {
                if ($i == 1)
                    $authors .= '<button type="button" class="ui-icon ui-icon-triangle-1-w publications-collapser"></button>';
                $class = $i == 0 ? '' : ' class="publications-collapse"';
                $url = $author['url'];
                if (empty($url))
                    $authors .= sprintf('<span %s>%s</span>', $class, $author['name']);
                else
                    $authors .= sprintf('<a %s href="%s">%s</a>', $class, $url, $author['name']);
            }
            $renderer->doc .= '    <td>' . $authors . '</td>';
            $renderer->doc .= '    <td>' . $row['publisher'] . '</a></td>';
            $renderer->doc .= '    <td>' . $row['year'] . '</a></td>';
            $renderer->doc .= '  </tr>';
        }

        if ($count != -1)
        {
            $renderer->doc .= '  <tr><td colspan="7" class="publications-page">';
            for ($index = 0; $index < ceil(count($data) / $count); $index++)
            {
                $link = $this->getUrl(array('start' => $index * $count));
                if (ceil($start / $count) == $index)
                    $renderer->doc .= sprintf('<span> %d </span>', $index + 1);
                else
                    $renderer->doc .= sprintf('<a href="%s"> %d </a>', $link, $index + 1);
            }
            $renderer->doc .= '  </td></tr>';
        }
        $renderer->doc .= '</table>';
        $renderer->doc .= '</div>';
    }

    private function renderHeader(Doku_Renderer &$renderer, $name)
    {
        global $INPUT;
        $dir = $INPUT->str('dir', 'desc');
        if ($INPUT->str('sort') == $name)
            $dir = $dir == 'desc' ? 'asc' : 'desc';
        else
            $dir = 'desc';

        $renderer->doc .= '<th>';
        $renderer->doc .= sprintf('<a href="%s">', $this->getUrl(array('sort' => $name, 'dir' => $dir)));
        $renderer->doc .= $this->getLang($name);
        $renderer->doc .= '</a>';
        $renderer->doc .= '</th>';
    }

    private function getUrl($array)
    {
        global $ID;
        $values = $_GET;
        unset($values['id']);
        foreach ($array as $key => $value)
            $values[$key] = $value;
        return $link = wl($ID, $values, false, '&');
    }

    private function sortResults($a, $b)
    {
        global $INPUT;
        $sort = $INPUT->str('sort');
        $direction = $INPUT->str('dir', 'desc') == 'desc' ? 1 : -1;

        if (empty($a[$sort]))
            return $direction;
        if (empty($b[$sort]))
            return -$direction;

        if ($sort != 'author')
            return strcmp($a[$sort], $b[$sort]) * $direction;
        return strcmp($a[$sort][0]['name'], $b[$sort][0]['name']) * $direction;
    }
    /* -------------------------------------- */
    /* --------------- HELPER --------------- */
    /* -------------------------------------- */
    private function renderRow($name, Database_Base $db = null, $result = null, $colspan = 1, $url = false)
    {
        global $INPUT;
        if (empty($result))
            $value = $INPUT->str($name);
        else
            $value = $result[$name];

        $str = '<th>' . $this->getLang($name) . ':</th>';
        $str .= '<td colspan="' . $colspan . '"">';
        if ($db != null)
            $str .= sprintf('<input class="publications-autocomplete" id="%s" name="%s" value="%s"/>',
                $db->getName(), $name, $value);
        else
        {
            if ($url)
                $str .= sprintf('<a href="%s" id="publications-field-%s">%s</a>', $result[$name], $name, $result[$name]);
            else
                $str .= sprintf('<span id="publications-field-%s">%s</span>', $name, $result[$name]);
        }

        $str .= '</td>';
        return $str;
    }

    private function getData()
    {
        global $INPUT;
        $data = array();
        foreach (Publications::getFields() as $field)
        {
            $value = $INPUT->param($field);
            if (is_array($value))
            {
                $authors = $INPUT->arr('author');
                $urls = $INPUT->arr('authorUrl');
                $value = array();
                foreach ($authors as $index => $name)
                    if (!empty($name))
                        $value[] = array('name' => $name, 'url' => $urls[$index]);
            }
            else
                $value = $INPUT->str($field);
            if (!empty($value))
                $data[$field] = $value;
        }
        return $data;
    }

    private function getAuth(Database_Base $db, $id = '**') { return auth_quickaclcheck($db->getNS($id)); }
}