/* DOKUWIKI:include_once bibtexParse.js */

jQuery(function ()
{
    jQuery('div[id="publications-tabs"]').tabs();
    jQuery('.publications-redirect').each(function ()
    {
        var link = jQuery(this).attr('href');
        setTimeout(function () { location.href = link; }, 1000);
    });

    jQuery('#publications-files input[name="date"]').datepicker(
        {
            changeMonth: true,
            changeYear: true
        });

    jQuery('#publications-search input[name="crossref"]').change(crossref);
    jQuery('#publications-add input[name="crossref"]').change(crossref);
    jQuery('#publications-show input[name="crossref"]').change(crossref);
    jQuery('#publications-edit input[name="crossref"]').change(crossref);
    function crossref()
    {
        var input = jQuery(this);
        var match = input.val().match(/itemID=(\d+)/i);
        if (match != null)
            input.val(match[1]);
    }

    /* -------------------------------------- */
    /* --------------- AUTOCOMPLETE --------- */
    /* -------------------------------------- */
    addAutocomplete(jQuery('.publications-autocomplete'));
    function addAutocomplete(obj)
    {
        obj.autocomplete({
            source: function (request, response)
            {
                var name = this.element.attr('name').replace(/\[\d+\]$/, '');
                var id = this.element.attr('id');
                jQuery.post
                (
                    DOKU_BASE + 'lib/exe/ajax.php',
                    {
                        call: 'plugin_publications',
                        name: name,
                        term: request.term,
                        id: id
                    },
                    function (data) { response(data); },
                    'json'
                );
            },
            create: function ()
            {
                try
                {
                    jQuery(this).data('ui-autocomplete')._renderItem = function (ul, item)
                    {
                        var re = new RegExp('(' + this.term + ')', 'gi');
                        var str = item.value.replace(re, '<b>$1</b>');
                        return jQuery("<li>").append(str).appendTo(ul);
                    };
                }
                catch (ex)
                { console.log(ex); }
            },
            minLength: 2
        });
    }

    /* -------------------------------------- */
    /* --------------- AUTHORS -------------- */
    /* -------------------------------------- */
    jQuery('.publications-authors-add').click(function () {addAuthor(jQuery(this)); });
    jQuery('.publications-authors-rem').click(removeAuthor);

    function removeAuthor() { jQuery(this).closest('tr').remove(); }

    function addAuthor(addButton)
    {
        var row = addButton.closest('tbody');

        var newRow = row.find('tr:last').clone(false);
        newRow.find('button').removeClass('ui-icon ui-icon-circle-plus');
        newRow.find('button').addClass('ui-icon ui-icon-circle-minus');
        newRow.find('button').click(removeAuthor);

        newRow.find('input').val('');
        newRow.find('input').attr('name', function (i, val)
        {
            return val.replace(/\d+/, function (match) { return parseInt(match) + 1; });
        });
        addAutocomplete(newRow.find('input'));

        row.append(newRow);
    }

    /* -------------------------------------- */
    /* --------------- BIBTEX --------------- */
    /* -------------------------------------- */
    jQuery('p[id="publications-export"]').html(function ()
    {
        var entry = {entryType: 'misc', entryTags: {}};

        var prevShow = jQuery(this).closest('#publications-tabs').prev('#publications-show');
        prevShow.find('[id*="publications-field-"]').each(function (index, value)
        {
            var field = jQuery(value).attr('id').replace(/publications-field-/, '');
            var text = jQuery(value).text().trim();

            if (field.match(/type-/))
                entry.entryType = field.replace(/type-/, '').toUpperCase();
            else if (field == 'author')
            {
                if ('author' in entry.entryTags)
                    entry.entryTags['author'] += ' and ' + text;
                else
                    entry.entryTags['author'] = text;
            }
            else if (text)
                entry.entryTags[field] = text;
        });

        return bibTeX.toBibTeX(entry).replace(/\n/g, '<br>').replace(/\t/g, '&nbsp;&nbsp;&nbsp;');
    });

    jQuery('div[id="publications-dialog"]').each(function (index, value)
    {
        var prevAdd = jQuery(value).prev('#publications-add');
        var dialog = jQuery(value).dialog(
            {
                autoOpen: false,
                width: 600,
                height: 400,
                modal: true,
                buttons: {
                    'Import': function () { importBibtex(prevAdd, dialog); },
                    'Cancel': function () { dialog.dialog('close'); }
                },
                close: function () { dialog.find('textarea').val(''); }
            });

        prevAdd.find('#publications-import').click(function () {dialog.dialog('open'); });
    });

    function importBibtex(prevAdd, dialog)
    {
        try
        { var bib = bibTeX.toJSON(dialog.find('textarea').val()); }
        catch (err)
        { alert(err); }

        if (bib.length < 1)
            return;
        bib = bib[0];

        prevAdd.find('select[name="type"]').val(getType(bib.entryType));
        for (var entryTag in bib.entryTags)
        {
            var tag = entryTag.toLowerCase();

            for (var alias in aliases)
                if (tag == alias)
                    tag = aliases[alias];

            var input = prevAdd.find('input[name*="' + tag + '"]');
            if (input.length < 1)
                continue;

            if (tag == 'author')
            {
                var str = bib.entryTags[tag].split(' and ');
                for (var i = 0; i < str.length - (input.length / 2); i++)
                    addAuthor(prevAdd.find('.publications-authors-add'));

                input = prevAdd.find('input[name*="' + tag + '["]');
                input.each(function (index, value) { jQuery(value).val(str[index]); });
            }
            else
                jQuery(input[0]).val(bib.entryTags[entryTag]);
        }
        dialog.dialog('close');
    }

    function getType(type)
    {
        type = type.toLowerCase();
        for (var t in types)
            if (type == t || jQuery.inArray(type, types[t]) != -1)
                return t;
        return 'misc';
    }

    var aliases =
    {
        howpublished: "url",
        address: "location"
    };

    var types =
    {
        online: [],
        thesis: ['mastersthesis', 'phdthesis'],
        book: ['booklet'],
        inbook: ['incollection'],
        proceedings: [],
        inproceedings: ['conference'],
        periodical: [],
        article: []
    };
    /* -------------------------------------- */
    /* --------------- SEARCH --------------- */
    /* -------------------------------------- */
    jQuery('#publications-search form').submit(function ()
    {
        jQuery(this).find('input').each(function (index, value)
        {
            value = jQuery(value);
            value.attr('disabled', value.val() == "");
        });
    });

    jQuery('.publications-collapse').hide();
    jQuery('.publications-collapser').click(function ()
    {
        jQuery(this).toggleClass('ui-icon-triangle-1-w');
        jQuery(this).toggleClass('ui-icon-triangle-1-s');
        jQuery(this).closest('td').find('.publications-collapse').toggle();
    });
});