<?php

abstract class Database_Base
{
    protected $name, $ns;
    public function __construct($name, $ns)
    {
        $this->name = $name;
        $this->ns = $ns;
    }

    public function getPath() { return sprintf("%s/.%s.%s", mediaFN($this->ns), $this->name, $this->getExtension()); }
    public function getName() { return $this->name; }
    public function getNS($id = null)
    {
        $str = $this->ns;
        if ($id != null)
            $str .= ":" . $id;
        return $str;
    }

    public abstract function getExtension();

    public abstract function get($id);
    public abstract function find($data);
    public abstract function add($data);
    public abstract function edit($id, $data);
    public abstract function remove($id);

    public abstract function addComment($id, $author, $text);
    public abstract function editComment($id, $date, $text);
    public abstract function removeComment($id, $date);

    public abstract function addFile($id, $name, $date);
    public abstract function removeFile($id, $name);
    public abstract function isPublicFile($name);

    protected function load()
    {
        $file = fopen(self::getPath(), 'rb');
        if (flock($file, LOCK_SH))
        {
            clearstatcache();
            $data = fread($file, filesize(self::getPath()));
            flock($file, LOCK_UN);
        }
        else
            die("Couldn't open file for reading.");
        fclose($file);
        return $data;
    }

    protected function save($data)
    {
        $file = fopen(self::getPath(), 'c+b');
        if (flock($file, LOCK_EX))
        {
            ftruncate($file, 0);
            fwrite($file, $data);
            flock($file, LOCK_UN);
        }
        else
            die("Couldn't open file for writing.");
        fclose($file);
    }
}