<?php

class Config
{
    public static function get($name, $default = null)
    {
        $json = self::load();
        if (array_key_exists($name, $json))
            return $json[$name];
        return $default;
    }

    public static function set($name, $value)
    {
        $json = self::load();
        $json[$name] = $value;
        file_put_contents(self::getPath(), json_encode($json));
    }

    private static function load()
    {
        if (!file_exists(self::getPath()))
            return array("insertStr" => "publications", "db" => array());
        return json_decode(file_get_contents(self::getPath()), true);
    }

    private static function getPath()
    {
        return __DIR__ . DIRECTORY_SEPARATOR . "config.json";
    }
}