<?php

if (!defined('DOKU_INC'))
    die();

require_once('db/Databases.php');
require_once('Importing.php');
require_once('config.php');

class action_plugin_publications extends DokuWiki_Action_Plugin
{
    function register(Doku_Event_Handler $controller)
    {
        $controller->register_hook('AJAX_CALL_UNKNOWN', 'BEFORE', $this, 'ajax_call');
        $controller->register_hook('AUTH_ACL_CHECK', 'AFTER', $this, 'auth_acl_check');
        $controller->register_hook('FETCH_MEDIA_STATUS', 'BEFORE', $this, 'fetch_media_status');
    }

    function fetch_media_status(Doku_Event &$event, $param)
    {
        if (auth_quickaclcheck($event->data['media']) < AUTH_READ)
        {
            $event->data['status'] = 401;
            $event->data['statusmessage'] = 'Access forbidden!';
        }
    }

    function auth_acl_check(Doku_Event &$event, $param)
    {
        if ($event->result != AUTH_READ)
            return;

        $id = $event->data['id'];
        foreach (Config::get('db') as $name => $ns)
            if ($ns == getNS($id))
            {
                $noNS = noNS($id);
                if ($noNS == '*' || !Databases::get($name)->isPublicFile($noNS))
                    $event->result = AUTH_NONE;
            }
    }

    function ajax_call(Doku_Event &$event, $param)
    {
        if ($event->data !== 'plugin_publications')
            return;

        $event->stopPropagation();
        $event->preventDefault();

        global $INPUT;
        $name = $INPUT->str('name');
        $term = $INPUT->str('term');
        $id = $INPUT->str('id');

        $data = array();
        foreach (Databases::get($id)->find((array($name => $term))) as $res)
        {
            $item = $res[$name];
            if (is_array($item))
            {
                foreach ($item as $i)
                    if (!in_array($i['name'], $data) && stripos($i['name'], $term) !== false)
                        $data[] = $i['name'];
            }
            else if (!in_array($item, $data) && stripos($item, $term) !== false)
                $data[] = $item;
        }

        header('Content-Type: application/json');
        echo json_encode($data);
    }
}