<?php

require_once("PHPExcel.php");
require_once("PHPExcel/IOFactory.php");
require_once("db/Publications.php");

class Importing
{
    public static function import($file, $db)
    {
        $fileName = $file['name'];
        $filePath = $file['tmp_name'];
        if (strcasecmp(pathinfo($fileName, PATHINFO_EXTENSION), "csv") == 0)
        {
            $reader = new PHPExcel_Reader_CSV();
            $reader->setDelimiter(';');
            $excel = $reader->load($filePath);
        }
        else
        {
            PHPExcel_Settings::setZipClass(PHPExcel_Settings::PCLZIP);
            $excel = PHPExcel_IOFactory::load($filePath);
        }

        $sheet = $excel->getActiveSheet();
        $columns = array();
        $firstRow = $sheet->getRowIterator()->current();
        foreach ($firstRow->getCellIterator() as $column => $cell)
            $columns[$column] = $cell->getValue();

        $headers = self::getTranslations(Publications::getFields());
        foreach ($columns as $index => $value)
            $columns[$index] = self::getKey($headers, $columns[$index]);

        $types = self::getTranslations(Publications::getTypes());
        $data = array();
        for ($row = 2; $row <= $sheet->getHighestRow(); $row++)
        {
            $item = array();
            foreach ($columns as $index => $value)
                if (!empty($value))
                {
                    $content = $sheet->getCellByColumnAndRow($index, $row)->getValue();
                    if (!empty($content))
                        $item[$value] = $content;
                }

            if (empty($item))
                continue;

            $item['type'] = self::getKey($types, $item['type'], 'misc');
            if (!empty($item['author']))
                $item['author'] = self::getAuthors($item['author']);

            $data[] = $item;
        }

        $db = Databases::get($db);
        foreach ($data as $item)
            $db->add($item);

        return array('columns' => $columns, "count" => count($data));
    }

    private static function getAuthors($authors)
    {
        $result = array();
        foreach (explode(" and ", $authors) as $author)
            $result[] = array('name' => $author);
        return $result;
    }

    private static function getKey($values, $value, $default = null)
    {
        foreach ($values as $key => $names)
            foreach ($names as $name)
                if (strcasecmp($value, $name) == 0)
                    return $key;
        return $default;
    }

    private static function getTranslations($values)
    {
        $cs = self::loadLang('cs');
        $en = self::loadLang('en');
        $translations = array();
        foreach ($values as $translation)
            $translations[$translation] = array($en[$translation], $cs[$translation]);
        return $translations;
    }

    private static function loadLang($language)
    {
        $path = __DIR__ . '/lang/';
        $lang = array();
        @include($path . $language . '/lang.php');
        return $lang;
    }
}
