<?php

if (!defined('DOKU_INC'))
    die();

require_once('db' . DIRECTORY_SEPARATOR . 'Databases.php');
require_once('Importing.php');
require_once('config.php');

class admin_plugin_publications extends DokuWiki_Admin_Plugin
{
    private $cfgOutput = '', $dbOutput = '';

    public function forAdminOnly() { return false; }
    public function html()
    {
        global $ID;
        $link = wl($ID, array('do' => 'admin', 'page' => $this->getPluginName()), false, '&');

        ptln('<h1>' . $this->getLang('pluginName') . '</h1>');
        ptln('<div id="publications-admin">');
        ptln('<form action="' . $link . '" method="post" enctype="multipart/form-data">');
        formSecurityToken();

        ptln('<fieldset>');
        ptln('<legend>' . $this->getLang('adminDbs') . ':</legend>');
        ptln('<table>');
        ptln('  <tr>');
        ptln('    <td colspan="4">');
        ptln('      <select size="8" name="db">');
        foreach (Databases::all() as $name => $ns)
            ptln(sprintf('      <option value="%s">%s (%s)', $name, $name, $ns));
        ptln('      </select>');
        ptln('    </td>');
        ptln('  </tr>');
        ptln('  <tr>');
        ptln('    <td>' . $this->getLang('adminDb') . ':</td>');
        ptln('    <td colspan="2"><input type="text" name="name"></td>');
        ptln('    <td><button type="submit" name="cmd" value="remove">' . $this->getLang('btnRemove') . '</button></td>');
        ptln('  </tr>');
        ptln('  <tr>');
        ptln('    <td>' . $this->getLang('adminNS') . ':</td>');
        ptln('    <td><input type="text" name="ns"></td>');
        ptln('    <td>');
        ptln('      <select name="ext">');
        foreach (Databases::getExtensions() as $ext)
            ptln('      <option>' . $ext);
        ptln('      </select>');
        ptln('    </td>');
        ptln('    <td><button type="submit" name="cmd" value="add">' . $this->getLang('btnAdd') . '</button></td>');
        ptln('  </tr>');
        ptln('  <tr>');
        ptln('    <td colspan="3"><input type="file" name="import"></td>');
        ptln('    <td><button type="submit" name="cmd" value="import">' . $this->getLang('btnImport') . '</button></td>');
        ptln('  </tr>');
        ptln('  <tr>');
        ptln('    <td colspan="4"><span>' . $this->dbOutput . '</span></td>');
        ptln('  </tr>');
        ptln('</table>');
        ptln('</fieldset>');

        ptln('<fieldset>');
        ptln('<legend>' . $this->getLang('adminCfg') . '</legend>');
        ptln('<table>');
        ptln('  <tr>');
        ptln('    <td><span>' . $this->getLang('adminStr') . ':</span></td>');
        ptln('    <td><input type="text" name="insert" value="' . Config::get('insertStr') . '"></td>');
        ptln('  </tr>');
        ptln('  <tr>');
        ptln('    <td><span>' . $this->getLang('adminPages') . ':</span></td>');
        ptln('    <td><input type="text" name="pageCount" value="' . Config::get('pageCount', 25) . '"></td>');
        ptln('  </tr>');
        ptln('  <tr>');
        ptln('    <td><span>' . $this->cfgOutput . '</span></td>');
        ptln('    <td><button type="submit" name="cmd" value="save">' . $this->getLang('btnSave') . '</button></td>');
        ptln('  </tr>');
        ptln('</table>');
        ptln('</fieldset>');

        ptln('</form>');
        ptln('</div>');
    }

    public function handle()
    {
        global $INPUT;
        if (!$INPUT->has('cmd') || !checkSecurityToken())
            return;

        switch ($INPUT->str('cmd'))
        {
            case 'add' :
                $this->dbOutput = $this->add($INPUT->str('name'), $INPUT->str('ext'), $INPUT->str('ns'));
                break;
            case 'remove' :
                $this->dbOutput = $this->remove($INPUT->str('db'));
                break;
            case 'import':
                $this->dbOutput = $this->import($INPUT->str('db'));
                break;
            case 'save':
                $this->cfgOutput = $this->save($INPUT->str('insert'), $INPUT->int('pageCount'));
                break;
        }
    }

    private function add($name, $ext, $ns)
    {
        if (empty($name))
            return $this->getLang('invalidName');
        if (Databases::create($name, $ext, $ns) == null)
            return sprintf($this->getLang('dbCreateError'), $name);
        return sprintf($this->getLang('dbAdd'), $name);
    }

    private function remove($db)
    {
        if (empty($db))
            return $this->getLang('invalidSelect');
        Databases::remove($db);
        return sprintf($this->getLang('dbRemove'), $db);
    }

    private function import($db)
    {
        if (empty($db))
            return $this->getLang('invalidSelect');

        $result = Importing::import($_FILES['import'], $db);
        $str = sprintf($this->getLang('dbImport'), $db, $result['count']);
        foreach ($result['columns'] as $index => $column)
        {
            if (empty($column))
                $column = '!ignored!';
            $str .= sprintf('<br>%d: %s', $index, $column);
        }
        return $str;
    }

    private function save($insert, $pageCount)
    {
        if (empty($insert))
            return $this->getLang('invalidInsert');

        if ($pageCount < 1)
            $pageCount = 25;

        Config::set('insertStr', $insert);
        Config::set('pageCount', $pageCount);
        return $this->getLang('cfgSaved');
    }
}