//
// Register Declarations for Microchip 16C781 Processor
//
//
// This header file was automatically generated by:
//
//	inc2h.pl V4783
//
//	Copyright (c) 2002, Kevin L. Pauba, All Rights Reserved
//
//	SDCC is licensed under the GNU Public license (GPL) v2.  Note that
//	this license covers the code to the compiler and other executables,
//	but explicitly does not cover any code or objects generated by sdcc.
//	We have not yet decided on a license for the run time libraries, but
//	it will not put any requirements on code linked against it. See:
// 
//	http://www.gnu.org/copyleft/gpl/html
//
//	See http://sdcc.sourceforge.net/ for the latest information on sdcc.
//
// 
#ifndef P16C781_H
#define P16C781_H

//
// Register addresses.
//
#define INDF_ADDR	0x0000
#define TMR0_ADDR	0x0001
#define PCL_ADDR	0x0002
#define STATUS_ADDR	0x0003
#define FSR_ADDR	0x0004
#define PORTA_ADDR	0x0005
#define PORTB_ADDR	0x0006
#define PCLATH_ADDR	0x000A
#define INTCON_ADDR	0x000B
#define PIR1_ADDR	0x000C
#define TMR1L_ADDR	0x000E
#define TMR1H_ADDR	0x000F
#define T1CON_ADDR	0x0010
#define ADRES_ADDR	0x001E
#define ADCON0_ADDR	0x001F
#define OPTION_REG_ADDR	0x0081
#define TRISA_ADDR	0x0085
#define TRISB_ADDR	0x0086
#define PIE1_ADDR	0x008C
#define PCON_ADDR	0x008E
#define WPUB_ADDR	0x0095
#define IOCB_ADDR	0x0096
#define REFCON_ADDR	0x009B
#define LVDCON_ADDR	0x009C
#define ANSEL_ADDR	0x009D
#define ADCON1_ADDR	0x009F
#define PMDATL_ADDR	0x010C
#define PMADRL_ADDR	0x010D
#define PMDATH_ADDR	0x010E
#define PMADRH_ADDR	0x010F
#define CALCON_ADDR	0x0110
#define PSMCCON0_ADDR	0x0111
#define PSMCCON1_ADDR	0x0112
#define CM1CON0_ADDR	0x0119
#define CM2CON0_ADDR	0x011A
#define CM2CON1_ADDR	0x011B
#define OPACON_ADDR	0x011C
#define DAC_ADDR	0x011E
#define DACON0_ADDR	0x011F
#define PMCON1_ADDR	0x018C

//
// Memory organization.
//



//         LIST
// P16C782.INC  Standard Header File, Version 1.00    Microchip Technology, Inc.
//         NOLIST

// This header file defines configurations, registers, and other useful bits of
// information for the PIC16C782 microcontroller.  These names are taken to match 
// the data sheets as closely as possible.  

// Note that the processor must be selected before this file is 
// included.  The processor may be selected the following ways:

//       1. Command line switch:
//               C:\ MPASM MYFILE.ASM /PIC16C782
//       2. LIST directive in the source file
//               LIST   P=PIC16C782
//       3. Processor Type entry in the MPASM full-screen interface

//==========================================================================
//
//       Revision History
//
//==========================================================================

//Rev:   Date:    Reason:

//1.00   16May2001 Initial Release

//==========================================================================
//
//       Verify Processor
//
//==========================================================================

//        IFNDEF __16C781
//            MESSG "Processor-header file mismatch.  Verify selected processor."
//         ENDIF

//==========================================================================
//
//       Register Definitions
//
//==========================================================================

#define W                    0x0000
#define F                    0x0001

//----- Register Files------------------------------------------------------

extern __sfr  __at (INDF_ADDR)                    INDF;
extern __sfr  __at (TMR0_ADDR)                    TMR0;
extern __sfr  __at (PCL_ADDR)                     PCL;
extern __sfr  __at (STATUS_ADDR)                  STATUS;
extern __sfr  __at (FSR_ADDR)                     FSR;
extern __sfr  __at (PORTA_ADDR)                   PORTA;
extern __sfr  __at (PORTB_ADDR)                   PORTB;
extern __sfr  __at (PCLATH_ADDR)                  PCLATH;
extern __sfr  __at (INTCON_ADDR)                  INTCON;
extern __sfr  __at (PIR1_ADDR)                    PIR1;
extern __sfr  __at (TMR1L_ADDR)                   TMR1L;
extern __sfr  __at (TMR1H_ADDR)                   TMR1H;
extern __sfr  __at (T1CON_ADDR)                   T1CON;
extern __sfr  __at (ADRES_ADDR)                   ADRES;
extern __sfr  __at (ADCON0_ADDR)                  ADCON0;

extern __sfr  __at (OPTION_REG_ADDR)              OPTION_REG;
extern __sfr  __at (TRISA_ADDR)                   TRISA;
extern __sfr  __at (TRISB_ADDR)                   TRISB;
extern __sfr  __at (PIE1_ADDR)                    PIE1;
extern __sfr  __at (PCON_ADDR)                    PCON;
extern __sfr  __at (WPUB_ADDR)                    WPUB;
extern __sfr  __at (IOCB_ADDR)                    IOCB;
extern __sfr  __at (REFCON_ADDR)                  REFCON;
extern __sfr  __at (LVDCON_ADDR)                  LVDCON;
extern __sfr  __at (ANSEL_ADDR)                   ANSEL;
extern __sfr  __at (ADCON1_ADDR)                  ADCON1;

extern __sfr  __at (PMDATL_ADDR)                  PMDATL;
extern __sfr  __at (PMADRL_ADDR)                  PMADRL;
extern __sfr  __at (PMDATH_ADDR)                  PMDATH;
extern __sfr  __at (PMADRH_ADDR)                  PMADRH;
extern __sfr  __at (CALCON_ADDR)                  CALCON;
extern __sfr  __at (PSMCCON0_ADDR)                PSMCCON0;
extern __sfr  __at (PSMCCON1_ADDR)                PSMCCON1;
extern __sfr  __at (CM1CON0_ADDR)                 CM1CON0;
extern __sfr  __at (CM2CON0_ADDR)                 CM2CON0;
extern __sfr  __at (CM2CON1_ADDR)                 CM2CON1;
extern __sfr  __at (OPACON_ADDR)                  OPACON;
extern __sfr  __at (DAC_ADDR)                     DAC;
extern __sfr  __at (DACON0_ADDR)                  DACON0;

extern __sfr  __at (PMCON1_ADDR)                  PMCON1;

//----- STATUS Bits --------------------------------------------------------


//----- INTCON Bits --------------------------------------------------------


//----- PIR1 Bits ----------------------------------------------------------


//----- T1CON Bits ---------------------------------------------------------


//----- ADCON0 Bits --------------------------------------------------------


//----- OPTION_REG Bits ----------------------------------------------------


//----- PIE1 Bits ----------------------------------------------------------


//----- PCON Bits ----------------------------------------------------------


//----- REFCON Bits --------------------------------------------------------


//----- LVDCON Bits --------------------------------------------------------


//----- ADCON1 Bits --------------------------------------------------------


//----- CALCON Bits --------------------------------------------------------


//----- PSMCCON0 Bits ------------------------------------------------------


//----- PSMCCON1 Bits ------------------------------------------------------


//----- CM1CON0 Bits ------------------------------------------------------


//----- CM2CON0 Bits ------------------------------------------------------


//----- CM2CON1 Bits ------------------------------------------------------


//----- OPACON Bits -------------------------------------------------------


//----- DACON Bits --------------------------------------------------------


//----- PMCON1 Bits -------------------------------------------------------


//==========================================================================
//
//       RAM Definition
//
//==========================================================================

//         __MAXRAM H'1FF'
// 	__BADRAM H'07'-H'09', H'0D', H'11'-H'1D'
// 	__BADRAM H'87'-H'89', H'8D'
//         __BADRAM H'8F'-H'94', H'97'-H'9A', H'9E', H'C0'-H'EF'
//         __BADRAM H'105', H'107'-H'109', H'113'-H'118'
//         __BADRAM H'11D', H'120'-H'16F'
//         __BADRAM H'185', H'187'-H'189', H'18D'-H'1EF'

//==========================================================================
//
//       Configuration Bits
//
//==========================================================================

#define _BODEN_ON            0x3FFF
#define _BODEN_OFF           0x3FBF
#define _CP_ALL              0x0CFF
#define _CP_OFF              0x3FFF
#define _VBOR_25             0x3FFF
#define _VBOR_27             0x3BFF
#define _VBOR_42             0x37FF
#define _VBOR_45             0x33FF
#define _PWRTE_OFF           0x3FFF
#define _PWRTE_ON            0x3FEF
#define _MCLRE_OFF           0x3FDF
#define _MCLRE_ON            0x3FFF
#define _WDT_ON              0x3FFF
#define _WDT_OFF             0x3FF7
#define _ER_OSC_CLKOUT       0x3FFF
#define _ER_OSC_NOCLKOUT     0x3FFE
#define _INTRC_OSC_CLKOUT    0x3FFD
#define _INTRC_OSC_NOCLKOUT  0x3FFC
#define _EXTCLK_OSC          0x3FFB
#define _HS_OSC              0x3FFA
#define _XT_OSC              0x3FF9
#define _LP_OSC              0x3FF8

//         LIST

// ----- ADCON0 bits --------------------
typedef union {
  struct {
    unsigned char ADON:1;
    unsigned char CHS3:1;
    unsigned char GO:1;
    unsigned char CHS0:1;
    unsigned char CHS1:1;
    unsigned char CHS2:1;
    unsigned char ADCS0:1;
    unsigned char ADCS1:1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_DONE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char GO_DONE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __ADCON0_bits_t;
extern volatile __ADCON0_bits_t __at(ADCON0_ADDR) ADCON0_bits;

#ifndef NO_BIT_DEFINES
#define ADON                 ADCON0_bits.ADON
#define CHS3                 ADCON0_bits.CHS3
#define GO                   ADCON0_bits.GO
#define NOT_DONE             ADCON0_bits.NOT_DONE
#define GO_DONE              ADCON0_bits.GO_DONE
#define CHS0                 ADCON0_bits.CHS0
#define CHS1                 ADCON0_bits.CHS1
#define CHS2                 ADCON0_bits.CHS2
#define ADCS0                ADCON0_bits.ADCS0
#define ADCS1                ADCON0_bits.ADCS1
#endif /* NO_BIT_DEFINES */

// ----- ADCON1 bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char VCFG0:1;
    unsigned char VCFG1:1;
    unsigned char :1;
    unsigned char :1;
  };
} __ADCON1_bits_t;
extern volatile __ADCON1_bits_t __at(ADCON1_ADDR) ADCON1_bits;

#ifndef NO_BIT_DEFINES
#define VCFG0                ADCON1_bits.VCFG0
#define VCFG1                ADCON1_bits.VCFG1
#endif /* NO_BIT_DEFINES */

// ----- CALCON bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char CALREF:1;
    unsigned char CALERR:1;
    unsigned char CAL:1;
  };
} __CALCON_bits_t;
extern volatile __CALCON_bits_t __at(CALCON_ADDR) CALCON_bits;

#ifndef NO_BIT_DEFINES
#define CALREF               CALCON_bits.CALREF
#define CALERR               CALCON_bits.CALERR
#define CAL                  CALCON_bits.CAL
#endif /* NO_BIT_DEFINES */

// ----- CM1CON0 bits --------------------
typedef union {
  struct {
    unsigned char C1CH0:1;
    unsigned char C1CH1:1;
    unsigned char C1R:1;
    unsigned char C1SP:1;
    unsigned char C1POL:1;
    unsigned char C1OE:1;
    unsigned char C1OUT:1;
    unsigned char C1ON:1;
  };
} __CM1CON0_bits_t;
extern volatile __CM1CON0_bits_t __at(CM1CON0_ADDR) CM1CON0_bits;

#ifndef NO_BIT_DEFINES
#define C1CH0                CM1CON0_bits.C1CH0
#define C1CH1                CM1CON0_bits.C1CH1
#define C1R                  CM1CON0_bits.C1R
#define C1SP                 CM1CON0_bits.C1SP
#define C1POL                CM1CON0_bits.C1POL
#define C1OE                 CM1CON0_bits.C1OE
#define C1OUT                CM1CON0_bits.C1OUT
#define C1ON                 CM1CON0_bits.C1ON
#endif /* NO_BIT_DEFINES */

// ----- CM2CON0 bits --------------------
typedef union {
  struct {
    unsigned char C2CH0:1;
    unsigned char C2CH1:1;
    unsigned char C2R:1;
    unsigned char C2SP:1;
    unsigned char C2POL:1;
    unsigned char C2OE:1;
    unsigned char C2OUT:1;
    unsigned char C2ON:1;
  };
} __CM2CON0_bits_t;
extern volatile __CM2CON0_bits_t __at(CM2CON0_ADDR) CM2CON0_bits;

#ifndef NO_BIT_DEFINES
#define C2CH0                CM2CON0_bits.C2CH0
#define C2CH1                CM2CON0_bits.C2CH1
#define C2R                  CM2CON0_bits.C2R
#define C2SP                 CM2CON0_bits.C2SP
#define C2POL                CM2CON0_bits.C2POL
#define C2OE                 CM2CON0_bits.C2OE
#define C2OUT                CM2CON0_bits.C2OUT
#define C2ON                 CM2CON0_bits.C2ON
#endif /* NO_BIT_DEFINES */

// ----- CM2CON1 bits --------------------
typedef union {
  struct {
    unsigned char C2SYNC:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char MC2OUT:1;
    unsigned char MC1OUT:1;
  };
} __CM2CON1_bits_t;
extern volatile __CM2CON1_bits_t __at(CM2CON1_ADDR) CM2CON1_bits;

#ifndef NO_BIT_DEFINES
#define C2SYNC               CM2CON1_bits.C2SYNC
#define MC2OUT               CM2CON1_bits.MC2OUT
#define MC1OUT               CM2CON1_bits.MC1OUT
#endif /* NO_BIT_DEFINES */

// ----- DACON0 bits --------------------
typedef union {
  struct {
    unsigned char DARS0:1;
    unsigned char DARS1:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char DAOE:1;
    unsigned char DAON:1;
  };
} __DACON0_bits_t;
extern volatile __DACON0_bits_t __at(DACON0_ADDR) DACON0_bits;

#ifndef NO_BIT_DEFINES
#define DARS0                DACON0_bits.DARS0
#define DARS1                DACON0_bits.DARS1
#define DAOE                 DACON0_bits.DAOE
#define DAON                 DACON0_bits.DAON
#endif /* NO_BIT_DEFINES */

// ----- INTCON bits --------------------
typedef union {
  struct {
    unsigned char RBIF:1;
    unsigned char INTF:1;
    unsigned char T0IF:1;
    unsigned char RBIE:1;
    unsigned char INTE:1;
    unsigned char T0IE:1;
    unsigned char PEIE:1;
    unsigned char GIE:1;
  };
} __INTCON_bits_t;
extern volatile __INTCON_bits_t __at(INTCON_ADDR) INTCON_bits;

#ifndef NO_BIT_DEFINES
#define RBIF                 INTCON_bits.RBIF
#define INTF                 INTCON_bits.INTF
#define T0IF                 INTCON_bits.T0IF
#define RBIE                 INTCON_bits.RBIE
#define INTE                 INTCON_bits.INTE
#define T0IE                 INTCON_bits.T0IE
#define PEIE                 INTCON_bits.PEIE
#define GIE                  INTCON_bits.GIE
#endif /* NO_BIT_DEFINES */

// ----- LVDCON bits --------------------
typedef union {
  struct {
    unsigned char LV0:1;
    unsigned char LV1:1;
    unsigned char LV2:1;
    unsigned char LV3:1;
    unsigned char LVDEN:1;
    unsigned char BGST:1;
    unsigned char :1;
    unsigned char :1;
  };
} __LVDCON_bits_t;
extern volatile __LVDCON_bits_t __at(LVDCON_ADDR) LVDCON_bits;

#ifndef NO_BIT_DEFINES
#define LV0                  LVDCON_bits.LV0
#define LV1                  LVDCON_bits.LV1
#define LV2                  LVDCON_bits.LV2
#define LV3                  LVDCON_bits.LV3
#define LVDEN                LVDCON_bits.LVDEN
#define BGST                 LVDCON_bits.BGST
#endif /* NO_BIT_DEFINES */

// ----- OPACON bits --------------------
typedef union {
  struct {
    unsigned char GBWP:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char CMPEN:1;
    unsigned char OPAON:1;
  };
} __OPACON_bits_t;
extern volatile __OPACON_bits_t __at(OPACON_ADDR) OPACON_bits;

#ifndef NO_BIT_DEFINES
#define GBWP                 OPACON_bits.GBWP
#define CMPEN                OPACON_bits.CMPEN
#define OPAON                OPACON_bits.OPAON
#endif /* NO_BIT_DEFINES */

// ----- OPTION_REG bits --------------------
typedef union {
  struct {
    unsigned char PS0:1;
    unsigned char PS1:1;
    unsigned char PS2:1;
    unsigned char PSA:1;
    unsigned char T0SE:1;
    unsigned char T0CS:1;
    unsigned char INTEDG:1;
    unsigned char NOT_RBPU:1;
  };
} __OPTION_REG_bits_t;
extern volatile __OPTION_REG_bits_t __at(OPTION_REG_ADDR) OPTION_REG_bits;

#ifndef NO_BIT_DEFINES
#define PS0                  OPTION_REG_bits.PS0
#define PS1                  OPTION_REG_bits.PS1
#define PS2                  OPTION_REG_bits.PS2
#define PSA                  OPTION_REG_bits.PSA
#define T0SE                 OPTION_REG_bits.T0SE
#define T0CS                 OPTION_REG_bits.T0CS
#define INTEDG               OPTION_REG_bits.INTEDG
#define NOT_RBPU             OPTION_REG_bits.NOT_RBPU
#endif /* NO_BIT_DEFINES */

// ----- PCON bits --------------------
typedef union {
  struct {
    unsigned char NOT_BO:1;
    unsigned char NOT_POR:1;
    unsigned char :1;
    unsigned char OSCF:1;
    unsigned char WDTON:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char NOT_BOR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PCON_bits_t;
extern volatile __PCON_bits_t __at(PCON_ADDR) PCON_bits;

#ifndef NO_BIT_DEFINES
#define NOT_BO               PCON_bits.NOT_BO
#define NOT_BOR              PCON_bits.NOT_BOR
#define NOT_POR              PCON_bits.NOT_POR
#define OSCF                 PCON_bits.OSCF
#define WDTON                PCON_bits.WDTON
#endif /* NO_BIT_DEFINES */

// ----- PIE1 bits --------------------
typedef union {
  struct {
    unsigned char TMR1IE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char C1IE:1;
    unsigned char C2IE:1;
    unsigned char ADIE:1;
    unsigned char LVDIE:1;
  };
} __PIE1_bits_t;
extern volatile __PIE1_bits_t __at(PIE1_ADDR) PIE1_bits;

#ifndef NO_BIT_DEFINES
#define TMR1IE               PIE1_bits.TMR1IE
#define C1IE                 PIE1_bits.C1IE
#define C2IE                 PIE1_bits.C2IE
#define ADIE                 PIE1_bits.ADIE
#define LVDIE                PIE1_bits.LVDIE
#endif /* NO_BIT_DEFINES */

// ----- PIR1 bits --------------------
typedef union {
  struct {
    unsigned char TMR1IF:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char C1IF:1;
    unsigned char C2IF:1;
    unsigned char ADIF:1;
    unsigned char LVDIF:1;
  };
} __PIR1_bits_t;
extern volatile __PIR1_bits_t __at(PIR1_ADDR) PIR1_bits;

#ifndef NO_BIT_DEFINES
#define TMR1IF               PIR1_bits.TMR1IF
#define C1IF                 PIR1_bits.C1IF
#define C2IF                 PIR1_bits.C2IF
#define ADIF                 PIR1_bits.ADIF
#define LVDIF                PIR1_bits.LVDIF
#endif /* NO_BIT_DEFINES */

// ----- PMCON1 bits --------------------
typedef union {
  struct {
    unsigned char RD:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PMCON1_bits_t;
extern volatile __PMCON1_bits_t __at(PMCON1_ADDR) PMCON1_bits;

#ifndef NO_BIT_DEFINES
#define RD                   PMCON1_bits.RD
#endif /* NO_BIT_DEFINES */

// ----- PORTA bits --------------------
typedef union {
  struct {
    unsigned char RA0:1;
    unsigned char RA1:1;
    unsigned char RA2:1;
    unsigned char RA3:1;
    unsigned char RA4:1;
    unsigned char RA5:1;
    unsigned char :1;
    unsigned char :1;
  };
} __PORTA_bits_t;
extern volatile __PORTA_bits_t __at(PORTA_ADDR) PORTA_bits;

#ifndef NO_BIT_DEFINES
#define RA0                  PORTA_bits.RA0
#define RA1                  PORTA_bits.RA1
#define RA2                  PORTA_bits.RA2
#define RA3                  PORTA_bits.RA3
#define RA4                  PORTA_bits.RA4
#define RA5                  PORTA_bits.RA5
#endif /* NO_BIT_DEFINES */

// ----- PORTB bits --------------------
typedef union {
  struct {
    unsigned char RB0:1;
    unsigned char RB1:1;
    unsigned char RB2:1;
    unsigned char RB3:1;
    unsigned char RB4:1;
    unsigned char RB5:1;
    unsigned char RB6:1;
    unsigned char RB7:1;
  };
} __PORTB_bits_t;
extern volatile __PORTB_bits_t __at(PORTB_ADDR) PORTB_bits;

#ifndef NO_BIT_DEFINES
#define RB0                  PORTB_bits.RB0
#define RB1                  PORTB_bits.RB1
#define RB2                  PORTB_bits.RB2
#define RB3                  PORTB_bits.RB3
#define RB4                  PORTB_bits.RB4
#define RB5                  PORTB_bits.RB5
#define RB6                  PORTB_bits.RB6
#define RB7                  PORTB_bits.RB7
#endif /* NO_BIT_DEFINES */

// ----- PSMCCON0 bits --------------------
typedef union {
  struct {
    unsigned char DC0:1;
    unsigned char DC1:1;
    unsigned char MAXDC0:1;
    unsigned char MAXDC1:1;
    unsigned char MINDC0:1;
    unsigned char MINDC1:1;
    unsigned char SMCCL0:1;
    unsigned char SMCCL1:1;
  };
} __PSMCCON0_bits_t;
extern volatile __PSMCCON0_bits_t __at(PSMCCON0_ADDR) PSMCCON0_bits;

#ifndef NO_BIT_DEFINES
#define DC0                  PSMCCON0_bits.DC0
#define DC1                  PSMCCON0_bits.DC1
#define MAXDC0               PSMCCON0_bits.MAXDC0
#define MAXDC1               PSMCCON0_bits.MAXDC1
#define MINDC0               PSMCCON0_bits.MINDC0
#define MINDC1               PSMCCON0_bits.MINDC1
#define SMCCL0               PSMCCON0_bits.SMCCL0
#define SMCCL1               PSMCCON0_bits.SMCCL1
#endif /* NO_BIT_DEFINES */

// ----- PSMCCON1 bits --------------------
typedef union {
  struct {
    unsigned char SMCCS:1;
    unsigned char PWM:1;
    unsigned char SMCOM:1;
    unsigned char SCEN:1;
    unsigned char :1;
    unsigned char S1BPOL:1;
    unsigned char S1APOL:1;
    unsigned char SMCON:1;
  };
  struct {
    unsigned char :1;
    unsigned char PSM:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char NOT_PSM:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PSMCCON1_bits_t;
extern volatile __PSMCCON1_bits_t __at(PSMCCON1_ADDR) PSMCCON1_bits;

#ifndef NO_BIT_DEFINES
#define SMCCS                PSMCCON1_bits.SMCCS
#define PWM                  PSMCCON1_bits.PWM
#define PSM                  PSMCCON1_bits.PSM
#define NOT_PSM              PSMCCON1_bits.NOT_PSM
#define SMCOM                PSMCCON1_bits.SMCOM
#define SCEN                 PSMCCON1_bits.SCEN
#define S1BPOL               PSMCCON1_bits.S1BPOL
#define S1APOL               PSMCCON1_bits.S1APOL
#define SMCON                PSMCCON1_bits.SMCON
#endif /* NO_BIT_DEFINES */

// ----- REFCON bits --------------------
typedef union {
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char VREFOE:1;
    unsigned char VREFEN:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __REFCON_bits_t;
extern volatile __REFCON_bits_t __at(REFCON_ADDR) REFCON_bits;

#ifndef NO_BIT_DEFINES
#define VREFOE               REFCON_bits.VREFOE
#define VREFEN               REFCON_bits.VREFEN
#endif /* NO_BIT_DEFINES */

// ----- STATUS bits --------------------
typedef union {
  struct {
    unsigned char C:1;
    unsigned char DC:1;
    unsigned char Z:1;
    unsigned char NOT_PD:1;
    unsigned char NOT_TO:1;
    unsigned char RP0:1;
    unsigned char RP1:1;
    unsigned char IRP:1;
  };
} __STATUS_bits_t;
extern volatile __STATUS_bits_t __at(STATUS_ADDR) STATUS_bits;

#ifndef NO_BIT_DEFINES
#define C                    STATUS_bits.C
#define DC                   STATUS_bits.DC
#define Z                    STATUS_bits.Z
#define NOT_PD               STATUS_bits.NOT_PD
#define NOT_TO               STATUS_bits.NOT_TO
#define RP0                  STATUS_bits.RP0
#define RP1                  STATUS_bits.RP1
#define IRP                  STATUS_bits.IRP
#endif /* NO_BIT_DEFINES */

// ----- T1CON bits --------------------
typedef union {
  struct {
    unsigned char TMR1ON:1;
    unsigned char TMR1CS:1;
    unsigned char NOT_T1SYNC:1;
    unsigned char T1OSCEN:1;
    unsigned char T1CKPS0:1;
    unsigned char T1CKPS1:1;
    unsigned char TMR1GE:1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char T1INSYNC:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __T1CON_bits_t;
extern volatile __T1CON_bits_t __at(T1CON_ADDR) T1CON_bits;

#ifndef NO_BIT_DEFINES
#define TMR1ON               T1CON_bits.TMR1ON
#define TMR1CS               T1CON_bits.TMR1CS
#define NOT_T1SYNC           T1CON_bits.NOT_T1SYNC
#define T1INSYNC             T1CON_bits.T1INSYNC
#define T1OSCEN              T1CON_bits.T1OSCEN
#define T1CKPS0              T1CON_bits.T1CKPS0
#define T1CKPS1              T1CON_bits.T1CKPS1
#define TMR1GE               T1CON_bits.TMR1GE
#endif /* NO_BIT_DEFINES */

// ----- TRISA bits --------------------
typedef union {
  struct {
    unsigned char TRISA0:1;
    unsigned char TRISA1:1;
    unsigned char TRISA2:1;
    unsigned char TRISA3:1;
    unsigned char TRISA4:1;
    unsigned char TRISA5:1;
    unsigned char :1;
    unsigned char :1;
  };
} __TRISA_bits_t;
extern volatile __TRISA_bits_t __at(TRISA_ADDR) TRISA_bits;

#ifndef NO_BIT_DEFINES
#define TRISA0               TRISA_bits.TRISA0
#define TRISA1               TRISA_bits.TRISA1
#define TRISA2               TRISA_bits.TRISA2
#define TRISA3               TRISA_bits.TRISA3
#define TRISA4               TRISA_bits.TRISA4
#define TRISA5               TRISA_bits.TRISA5
#endif /* NO_BIT_DEFINES */

// ----- TRISB bits --------------------
typedef union {
  struct {
    unsigned char TRISB0:1;
    unsigned char TRISB1:1;
    unsigned char TRISB2:1;
    unsigned char TRISB3:1;
    unsigned char TRISB4:1;
    unsigned char TRISB5:1;
    unsigned char TRISB6:1;
    unsigned char TRISB7:1;
  };
} __TRISB_bits_t;
extern volatile __TRISB_bits_t __at(TRISB_ADDR) TRISB_bits;

#ifndef NO_BIT_DEFINES
#define TRISB0               TRISB_bits.TRISB0
#define TRISB1               TRISB_bits.TRISB1
#define TRISB2               TRISB_bits.TRISB2
#define TRISB3               TRISB_bits.TRISB3
#define TRISB4               TRISB_bits.TRISB4
#define TRISB5               TRISB_bits.TRISB5
#define TRISB6               TRISB_bits.TRISB6
#define TRISB7               TRISB_bits.TRISB7
#endif /* NO_BIT_DEFINES */

#endif
