/*
 * pic18f14k50.h - device specific declarations
 *
 * This file is part of the GNU PIC library for SDCC,
 * originally devised by Vangelis Rokas <vrokas AT otenet.gr>
 *
 * It has been automatically generated by inc2h-pic16.pl,
 * (c) 2007 by Raphael Neider <rneider AT web.de>
 */

#ifndef __PIC18F14K50_H__
#define __PIC18F14K50_H__ 1



// Configuration Bits
#define	__CONFIG1L          	0x300000
#define	__CONFIG1H          	0x300001
#define	__CONFIG2L          	0x300002
#define	__CONFIG2H          	0x300003
#define	__CONFIG3H          	0x300005
#define	__CONFIG4L          	0x300006
#define	__CONFIG5L          	0x300008
#define	__CONFIG5H          	0x300009
#define	__CONFIG6L          	0x30000A
#define	__CONFIG6H          	0x30000B
#define	__CONFIG7L          	0x30000C
#define	__CONFIG7H          	0x30000D

// CONFIG1L Options
#define	_CPUDIV_NOCLKDIV_1L 	0xE7	 // No CPU System Clock divide
#define	_CPUDIV_CLKDIV2_1L  	0xEF	 // CPU System Clock divided by 2
#define	_CPUDIV_CLKDIV3_1L  	0xF7	 // CPU System Clock divided by 3
#define	_CPUDIV_CLKDIV4_1L  	0xFF	 // CPU System Clock divided by 4
#define	_USBDIV_OFF_1L      	0xDF	 // USB Clock comes directly from the OSC1/OSC2 oscillator block; no divide
#define	_USBDIV_ON_1L       	0xFF	 // USB clock comes from the OSC1/OSC2 divided by 2

// CONFIG1H Options
#define	_FOSC_LP_1H         	0xF0	 // LP oscillator
#define	_FOSC_XT_1H         	0xF1	 // XT oscillator
#define	_FOSC_HS_1H         	0xF2	 // HS oscillator
#define	_FOSC_ERCCLKOUT_1H  	0xF3	 // External RC oscillator, CLKOUT function on OSC2
#define	_FOSC_ECCLKOUTH_1H  	0xF4	 // EC, CLKOUT function on OSC2 (high)
#define	_FOSC_ECH_1H        	0xF5	 // EC (high)
#define	_FOSC_ERC_1H        	0xF7	 // External RC oscillator
#define	_FOSC_IRC_1H        	0xF8	 // Internal RC oscillator
#define	_FOSC_IRCCLKOUT_1H  	0xF9	 // Internal RC oscillator, CLKOUT function on OSC2
#define	_FOSC_ECCLKOUTM_1H  	0xFA	 // EC, CLKOUT function on OSC2 (medium)
#define	_FOSC_ECM_1H        	0xFB	 // EC (medium)
#define	_FOSC_ECCLKOUTL_1H  	0xFC	 // EC, CLKOUT function on OSC2 (low)
#define	_FOSC_ECL_1H        	0xFD	 // EC (low)
#define	_PLLEN_OFF_1H       	0xEF	 // PLL is under software control
#define	_PLLEN_ON_1H        	0xFF	 // Oscillator multiplied by 4
#define	_PCLKEN_OFF_1H      	0xDF	 // Primary clock is under software control
#define	_PCLKEN_ON_1H       	0xFF	 // Primary clock enabled
#define	_FCMEN_OFF_1H       	0xBF	 // Fail-Safe Clock Monitor disabled
#define	_FCMEN_ON_1H        	0xFF	 // Fail-Safe Clock Monitor enabled
#define	_IESO_OFF_1H        	0x7F	 // Oscillator Switchover mode disabled
#define	_IESO_ON_1H         	0xFF	 // Oscillator Switchover mode enabled

// CONFIG2L Options
#define	_PWRTEN_ON_2L       	0xFE	 // PWRT enabled
#define	_PWRTEN_OFF_2L      	0xFF	 // PWRT disabled
#define	_BOREN_OFF_2L       	0xF9	 // Brown-out Reset disabled in hardware and software
#define	_BOREN_ON_2L        	0xFB	 // Brown-out Reset enabled and controlled by software (SBOREN is enabled)
#define	_BOREN_NOSLP_2L     	0xFD	 // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled)
#define	_BOREN_SBORDIS_2L   	0xFF	 // Brown-out Reset enabled in hardware only (SBOREN is disabled)
#define	_BORV_30_2L         	0xE7	 // VBOR set to 3.0 V nominal
#define	_BORV_27_2L         	0xEF	 // VBOR set to 2.7 V nominal
#define	_BORV_22_2L         	0xF7	 // VBOR set to 2.2 V nominal
#define	_BORV_19_2L         	0xFF	 // VBOR set to 1.9 V nominal

// CONFIG2H Options
#define	_WDTEN_OFF_2H       	0xFE	 // WDT is controlled by SWDTEN bit of the WDTCON register
#define	_WDTEN_ON_2H        	0xFF	 // WDT is always enabled. SWDTEN bit has no effect.
#define	_WDTPS_1_2H         	0xE1	 // 1:1
#define	_WDTPS_2_2H         	0xE3	 // 1:2
#define	_WDTPS_4_2H         	0xE5	 // 1:4
#define	_WDTPS_8_2H         	0xE7	 // 1:8
#define	_WDTPS_16_2H        	0xE9	 // 1:16
#define	_WDTPS_32_2H        	0xEB	 // 1:32
#define	_WDTPS_64_2H        	0xED	 // 1:64
#define	_WDTPS_128_2H       	0xEF	 // 1:128
#define	_WDTPS_256_2H       	0xF1	 // 1:256
#define	_WDTPS_512_2H       	0xF3	 // 1:512
#define	_WDTPS_1024_2H      	0xF5	 // 1:1024
#define	_WDTPS_2048_2H      	0xF7	 // 1:2048
#define	_WDTPS_4096_2H      	0xF9	 // 1:4096
#define	_WDTPS_8192_2H      	0xFB	 // 1:8192
#define	_WDTPS_16384_2H     	0xFD	 // 1:16384
#define	_WDTPS_32768_2H     	0xFF	 // 1:32768

// CONFIG3H Options
#define	_MCLRE_OFF_3H       	0x7F	 // RE3 input pin enabled; MCLR disabled
#define	_MCLRE_ON_3H        	0xFF	 // MCLR pin enabled, RE3 input pin disabled
#define	_HFOFST_OFF_3H      	0xF7	 // The system clock is held off until the HFINTOSC is stable.
#define	_HFOFST_ON_3H       	0xFF	 // HFINTOSC starts clocking the CPU without waiting for the oscillator to stablize.

// CONFIG4L Options
#define	_STVREN_OFF_4L      	0xFE	 // Stack full/underflow will not cause Reset
#define	_STVREN_ON_4L       	0xFF	 // Stack full/underflow will cause Reset
#define	_LVP_OFF_4L         	0xFB	 // Single-Supply ICSP disabled
#define	_LVP_ON_4L          	0xFF	 // Single-Supply ICSP enabled
#define	_BBSIZ_OFF_4L       	0xF7	 // 1kW boot block size
#define	_BBSIZ_ON_4L        	0xFF	 // 2kW boot block size
#define	_XINST_OFF_4L       	0xBF	 // Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
#define	_XINST_ON_4L        	0xFF	 // Instruction set extension and Indexed Addressing mode enabled

// CONFIG5L Options
#define	_CP0_ON_5L          	0xFE	 // Block 0 code-protected
#define	_CP0_OFF_5L         	0xFF	 // Block 0 not code-protected
#define	_CP1_ON_5L          	0xFD	 // Block 1 code-protected
#define	_CP1_OFF_5L         	0xFF	 // Block 1 not code-protected

// CONFIG5H Options
#define	_CPB_ON_5H          	0xBF	 // Boot block code-protected
#define	_CPB_OFF_5H         	0xFF	 // Boot block not code-protected
#define	_CPD_ON_5H          	0x7F	 // Data EEPROM code-protected
#define	_CPD_OFF_5H         	0xFF	 // Data EEPROM not code-protected

// CONFIG6L Options
#define	_WRT0_ON_6L         	0xFE	 // Block 0 write-protected
#define	_WRT0_OFF_6L        	0xFF	 // Block 0 not write-protected
#define	_WRT1_ON_6L         	0xFD	 // Block 1 write-protected
#define	_WRT1_OFF_6L        	0xFF	 // Block 1 not write-protected

// CONFIG6H Options
#define	_WRTB_ON_6H         	0xBF	 // Boot block write-protected
#define	_WRTB_OFF_6H        	0xFF	 // Boot block not write-protected
#define	_WRTC_ON_6H         	0xDF	 // Configuration registers write-protected
#define	_WRTC_OFF_6H        	0xFF	 // Configuration registers not write-protected
#define	_WRTD_ON_6H         	0x7F	 // Data EEPROM write-protected
#define	_WRTD_OFF_6H        	0xFF	 // Data EEPROM not write-protected

// CONFIG7L Options
#define	_EBTR0_ON_7L        	0xFE	 // Block 0 protected from table reads executed in other blocks
#define	_EBTR0_OFF_7L       	0xFF	 // Block 0 not protected from table reads executed in other blocks
#define	_EBTR1_ON_7L        	0xFD	 // Block 1 protected from table reads executed in other blocks
#define	_EBTR1_OFF_7L       	0xFF	 // Block 1 not protected from table reads executed in other blocks

// CONFIG7H Options
#define	_EBTRB_ON_7H        	0xBF	 // Boot block protected from table reads executed in other blocks
#define	_EBTRB_OFF_7H       	0xFF	 // Boot block not protected from table reads executed in other blocks
#define	_DEVID1             	0x3FFFFE
#define	_DEVID2             	0x3FFFFF
#define	_IDLOC0             	0x200000
#define	_IDLOC1             	0x200001
#define	_IDLOC2             	0x200002
#define	_IDLOC3             	0x200003
#define	_IDLOC4             	0x200004
#define	_IDLOC5             	0x200005
#define	_IDLOC6             	0x200006
#define	_IDLOC7             	0x200007

extern __sfr __at (0xF53) UEP0;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP0bits_t;
extern volatile __UEP0bits_t __at (0xF53) UEP0bits;

extern __sfr __at (0xF54) UEP1;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP1bits_t;
extern volatile __UEP1bits_t __at (0xF54) UEP1bits;

extern __sfr __at (0xF55) UEP2;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP2bits_t;
extern volatile __UEP2bits_t __at (0xF55) UEP2bits;

extern __sfr __at (0xF56) UEP3;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP3bits_t;
extern volatile __UEP3bits_t __at (0xF56) UEP3bits;

extern __sfr __at (0xF57) UEP4;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP4bits_t;
extern volatile __UEP4bits_t __at (0xF57) UEP4bits;

extern __sfr __at (0xF58) UEP5;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP5bits_t;
extern volatile __UEP5bits_t __at (0xF58) UEP5bits;

extern __sfr __at (0xF59) UEP6;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP6bits_t;
extern volatile __UEP6bits_t __at (0xF59) UEP6bits;

extern __sfr __at (0xF5A) UEP7;
typedef union {
	struct {
		unsigned EPSTALL   	: 1;
		unsigned EPINEN    	: 1;
		unsigned EPOUTEN   	: 1;
		unsigned EPCONDIS  	: 1;
		unsigned EPHSHK    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UEP7bits_t;
extern volatile __UEP7bits_t __at (0xF5A) UEP7bits;

extern __sfr __at (0xF5B) UEIE;
typedef union {
	struct {
		unsigned PIDEE     	: 1;
		unsigned CRC5EE    	: 1;
		unsigned CRC16EE   	: 1;
		unsigned DFN8EE    	: 1;
		unsigned BTOEE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEE     	: 1;
	};
} __UEIEbits_t;
extern volatile __UEIEbits_t __at (0xF5B) UEIEbits;

extern __sfr __at (0xF5C) UADDR;
typedef union {
	struct {
		unsigned ADDR0     	: 1;
		unsigned ADDR1     	: 1;
		unsigned ADDR2     	: 1;
		unsigned ADDR3     	: 1;
		unsigned ADDR4     	: 1;
		unsigned ADDR5     	: 1;
		unsigned ADDR6     	: 1;
		unsigned           	: 1;
	};
} __UADDRbits_t;
extern volatile __UADDRbits_t __at (0xF5C) UADDRbits;

extern __sfr __at (0xF5D) UFRML;
typedef union {
	struct {
		unsigned FRM0      	: 1;
		unsigned FRM1      	: 1;
		unsigned FRM2      	: 1;
		unsigned FRM3      	: 1;
		unsigned FRM4      	: 1;
		unsigned FRM5      	: 1;
		unsigned FRM6      	: 1;
		unsigned FRM7      	: 1;
	};
} __UFRMLbits_t;
extern volatile __UFRMLbits_t __at (0xF5D) UFRMLbits;

extern __sfr __at (0xF5E) UFRMH;
typedef union {
	struct {
		unsigned FRM8      	: 1;
		unsigned FRM9      	: 1;
		unsigned FRM10     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __UFRMHbits_t;
extern volatile __UFRMHbits_t __at (0xF5E) UFRMHbits;

extern __sfr __at (0xF5F) UEIR;
typedef union {
	struct {
		unsigned PIDEF     	: 1;
		unsigned CRC5EF    	: 1;
		unsigned CRC16EF   	: 1;
		unsigned DFN8EF    	: 1;
		unsigned BTOEF     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned BTSEF     	: 1;
	};
} __UEIRbits_t;
extern volatile __UEIRbits_t __at (0xF5F) UEIRbits;

extern __sfr __at (0xF60) UIE;
typedef union {
	struct {
		unsigned URSTIE    	: 1;
		unsigned UERRIE    	: 1;
		unsigned ACTVIE    	: 1;
		unsigned TRNIE     	: 1;
		unsigned IDLEIE    	: 1;
		unsigned STALLIE   	: 1;
		unsigned SOFIE     	: 1;
		unsigned           	: 1;
	};
} __UIEbits_t;
extern volatile __UIEbits_t __at (0xF60) UIEbits;

extern __sfr __at (0xF61) UCFG;
typedef union {
	struct {
		unsigned PPB0      	: 1;
		unsigned PPB1      	: 1;
		unsigned FSEN      	: 1;
		unsigned           	: 1;
		unsigned UPUEN     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned UTEYE     	: 1;
	};
} __UCFGbits_t;
extern volatile __UCFGbits_t __at (0xF61) UCFGbits;

extern __sfr __at (0xF62) UIR;
typedef union {
	struct {
		unsigned URSTIF    	: 1;
		unsigned UERRIF    	: 1;
		unsigned ACTVIF    	: 1;
		unsigned TRNIF     	: 1;
		unsigned IDLEIF    	: 1;
		unsigned STALLIF   	: 1;
		unsigned SOFIF     	: 1;
		unsigned           	: 1;
	};
} __UIRbits_t;
extern volatile __UIRbits_t __at (0xF62) UIRbits;

extern __sfr __at (0xF63) USTAT;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned PPBI      	: 1;
		unsigned DIR       	: 1;
		unsigned ENDP0     	: 1;
		unsigned ENDP1     	: 1;
		unsigned ENDP2     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __USTATbits_t;
extern volatile __USTATbits_t __at (0xF63) USTATbits;

extern __sfr __at (0xF64) UCON;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned SUSPND    	: 1;
		unsigned RESUME    	: 1;
		unsigned USBEN     	: 1;
		unsigned PKTDIS    	: 1;
		unsigned SE0       	: 1;
		unsigned PPBRST    	: 1;
		unsigned           	: 1;
	};
} __UCONbits_t;
extern volatile __UCONbits_t __at (0xF64) UCONbits;

extern __sfr __at (0xF68) SRCON0;
typedef union {
	struct {
		unsigned SRPR      	: 1;
		unsigned SRPS      	: 1;
		unsigned SRNQEN    	: 1;
		unsigned SRQEN     	: 1;
		unsigned SRCLK0    	: 1;
		unsigned SRCLK1    	: 1;
		unsigned SRCLK2    	: 1;
		unsigned SRLEN     	: 1;
	};
} __SRCON0bits_t;
extern volatile __SRCON0bits_t __at (0xF68) SRCON0bits;

extern __sfr __at (0xF69) SRCON1;
typedef union {
	struct {
		unsigned SRRC1E    	: 1;
		unsigned SRRC2E    	: 1;
		unsigned SRRCKE    	: 1;
		unsigned SRRPE     	: 1;
		unsigned SRSC1E    	: 1;
		unsigned SRSC2E    	: 1;
		unsigned SRSCKE    	: 1;
		unsigned SRSPE     	: 1;
	};
} __SRCON1bits_t;
extern volatile __SRCON1bits_t __at (0xF69) SRCON1bits;

extern __sfr __at (0xF6B) CM2CON0;
typedef union {
	struct {
		unsigned C2CH0     	: 1;
		unsigned C2CH1     	: 1;
		unsigned C2R       	: 1;
		unsigned C2SP      	: 1;
		unsigned C2POL     	: 1;
		unsigned C2OE      	: 1;
		unsigned C2OUT     	: 1;
		unsigned C2ON      	: 1;
	};
} __CM2CON0bits_t;
extern volatile __CM2CON0bits_t __at (0xF6B) CM2CON0bits;

extern __sfr __at (0xF6C) CM2CON1;
typedef union {
	struct {
		unsigned C2SYNC    	: 1;
		unsigned C1SYNC    	: 1;
		unsigned C2HYS     	: 1;
		unsigned C1HYS     	: 1;
		unsigned C2RSEL    	: 1;
		unsigned C1RSEL    	: 1;
		unsigned MC2OUT    	: 1;
		unsigned MC1OUT    	: 1;
	};
} __CM2CON1bits_t;
extern volatile __CM2CON1bits_t __at (0xF6C) CM2CON1bits;

extern __sfr __at (0xF6D) CM1CON0;
typedef union {
	struct {
		unsigned C1CH0     	: 1;
		unsigned C1CH1     	: 1;
		unsigned C1R       	: 1;
		unsigned C1SP      	: 1;
		unsigned C1POL     	: 1;
		unsigned C1OE      	: 1;
		unsigned C1OUT     	: 1;
		unsigned C1ON      	: 1;
	};
} __CM1CON0bits_t;
extern volatile __CM1CON0bits_t __at (0xF6D) CM1CON0bits;

extern __sfr __at (0xF6F) SSPMSK;
typedef union {
	struct {
		unsigned MSK0      	: 1;
		unsigned MSK1      	: 1;
		unsigned MSK2      	: 1;
		unsigned MSK3      	: 1;
		unsigned MSK4      	: 1;
		unsigned MSK5      	: 1;
		unsigned MSK6      	: 1;
		unsigned MSK7      	: 1;
	};
} __SSPMSKbits_t;
extern volatile __SSPMSKbits_t __at (0xF6F) SSPMSKbits;

extern __sfr __at (0xF76) SLRCON;
typedef union {
	struct {
		unsigned SLRA      	: 1;
		unsigned SLRB      	: 1;
		unsigned SLRC      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SLRCONbits_t;
extern volatile __SLRCONbits_t __at (0xF76) SLRCONbits;

extern __sfr __at (0xF77) WPUA;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned WPUA3     	: 1;
		unsigned WPUA4     	: 1;
		unsigned WPUA5     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __WPUAbits_t;
extern volatile __WPUAbits_t __at (0xF77) WPUAbits;

extern __sfr __at (0xF78) WPUB;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned WPUB4     	: 1;
		unsigned WPUB5     	: 1;
		unsigned WPUB6     	: 1;
		unsigned WPUB7     	: 1;
	};
} __WPUBbits_t;
extern volatile __WPUBbits_t __at (0xF78) WPUBbits;

extern __sfr __at (0xF79) IOCA;
typedef union {
	struct {
		unsigned IOCA0     	: 1;
		unsigned IOCA1     	: 1;
		unsigned           	: 1;
		unsigned IOCA3     	: 1;
		unsigned IOCA4     	: 1;
		unsigned IOCA5     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __IOCAbits_t;
extern volatile __IOCAbits_t __at (0xF79) IOCAbits;

extern __sfr __at (0xF7A) IOCB;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned IOCB4     	: 1;
		unsigned IOCB5     	: 1;
		unsigned IOCB6     	: 1;
		unsigned IOCB7     	: 1;
	};
} __IOCBbits_t;
extern volatile __IOCBbits_t __at (0xF7A) IOCBbits;

extern __sfr __at (0xF7E) ANSEL;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ANS3      	: 1;
		unsigned ANS4      	: 1;
		unsigned ANS5      	: 1;
		unsigned ANS6      	: 1;
		unsigned ANS7      	: 1;
	};
} __ANSELbits_t;
extern volatile __ANSELbits_t __at (0xF7E) ANSELbits;

extern __sfr __at (0xF7F) ANSELH;
typedef union {
	struct {
		unsigned ANS8      	: 1;
		unsigned ANS9      	: 1;
		unsigned ANS10     	: 1;
		unsigned ANS11     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ANSELHbits_t;
extern volatile __ANSELHbits_t __at (0xF7F) ANSELHbits;

extern __sfr __at (0xF80) PORTA;
typedef union {
	struct {
		unsigned RA0       	: 1;
		unsigned RA1       	: 1;
		unsigned           	: 1;
		unsigned RA3       	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned AN3       	: 1;
		unsigned OSC1      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned OSC2      	: 1;
		unsigned CLKIN     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned CLKOUT    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTAbits_t;
extern volatile __PORTAbits_t __at (0xF80) PORTAbits;

extern __sfr __at (0xF81) PORTB;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SDI       	: 1;
		unsigned RX        	: 1;
		unsigned SCL       	: 1;
		unsigned TX        	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SDA       	: 1;
		unsigned DT        	: 1;
		unsigned SCK       	: 1;
		unsigned CK        	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned AN10      	: 1;
		unsigned AN11      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PORTBbits_t;
extern volatile __PORTBbits_t __at (0xF81) PORTBbits;

extern __sfr __at (0xF82) PORTC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
	struct {
		unsigned AN4       	: 1;
		unsigned AN5       	: 1;
		unsigned AN6       	: 1;
		unsigned AN7       	: 1;
		unsigned C12OUT    	: 1;
		unsigned T0CKI     	: 1;
		unsigned AN8       	: 1;
		unsigned AN9       	: 1;
	};
	struct {
		unsigned C12INP    	: 1;
		unsigned C12IN1M   	: 1;
		unsigned C12IN2M   	: 1;
		unsigned C12IN3M   	: 1;
		unsigned SRQ       	: 1;
		unsigned P1A       	: 1;
		unsigned T13CKI    	: 1;
		unsigned T1OSCO    	: 1;
	};
	struct {
		unsigned INT0      	: 1;
		unsigned INT1      	: 1;
		unsigned INT2      	: 1;
		unsigned PGM       	: 1;
		unsigned P1B       	: 1;
		unsigned CCP1      	: 1;
		unsigned T1OSCI    	: 1;
		unsigned SDO       	: 1;
	};
	struct {
		unsigned VREFP     	: 1;
		unsigned VREFM     	: 1;
		unsigned CVREF     	: 1;
		unsigned P1C       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SS        	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned P1D       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_SS    	: 1;
		unsigned           	: 1;
	};
} __PORTCbits_t;
extern volatile __PORTCbits_t __at (0xF82) PORTCbits;

extern __sfr __at (0xF89) LATA;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LATA4     	: 1;
		unsigned LATA5     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __LATAbits_t;
extern volatile __LATAbits_t __at (0xF89) LATAbits;

extern __sfr __at (0xF8A) LATB;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned LATB4     	: 1;
		unsigned LATB5     	: 1;
		unsigned LATB6     	: 1;
		unsigned LATB7     	: 1;
	};
} __LATBbits_t;
extern volatile __LATBbits_t __at (0xF8A) LATBbits;

extern __sfr __at (0xF8B) LATC;
typedef union {
	struct {
		unsigned LATC0     	: 1;
		unsigned LATC1     	: 1;
		unsigned LATC2     	: 1;
		unsigned LATC3     	: 1;
		unsigned LATC4     	: 1;
		unsigned LATC5     	: 1;
		unsigned LATC6     	: 1;
		unsigned LATC7     	: 1;
	};
} __LATCbits_t;
extern volatile __LATCbits_t __at (0xF8B) LATCbits;

extern __sfr __at (0xF92) DDRA;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RA4       	: 1;
		unsigned RA5       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __DDRAbits_t;
extern volatile __DDRAbits_t __at (0xF92) DDRAbits;

extern __sfr __at (0xF92) TRISA;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TRISA4    	: 1;
		unsigned TRISA5    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __TRISAbits_t;
extern volatile __TRISAbits_t __at (0xF92) TRISAbits;

extern __sfr __at (0xF93) DDRB;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned RB4       	: 1;
		unsigned RB5       	: 1;
		unsigned RB6       	: 1;
		unsigned RB7       	: 1;
	};
} __DDRBbits_t;
extern volatile __DDRBbits_t __at (0xF93) DDRBbits;

extern __sfr __at (0xF93) TRISB;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TRISB4    	: 1;
		unsigned TRISB5    	: 1;
		unsigned TRISB6    	: 1;
		unsigned TRISB7    	: 1;
	};
} __TRISBbits_t;
extern volatile __TRISBbits_t __at (0xF93) TRISBbits;

extern __sfr __at (0xF94) DDRC;
typedef union {
	struct {
		unsigned RC0       	: 1;
		unsigned RC1       	: 1;
		unsigned RC2       	: 1;
		unsigned RC3       	: 1;
		unsigned RC4       	: 1;
		unsigned RC5       	: 1;
		unsigned RC6       	: 1;
		unsigned RC7       	: 1;
	};
} __DDRCbits_t;
extern volatile __DDRCbits_t __at (0xF94) DDRCbits;

extern __sfr __at (0xF94) TRISC;
typedef union {
	struct {
		unsigned TRISC0    	: 1;
		unsigned TRISC1    	: 1;
		unsigned TRISC2    	: 1;
		unsigned TRISC3    	: 1;
		unsigned TRISC4    	: 1;
		unsigned TRISC5    	: 1;
		unsigned TRISC6    	: 1;
		unsigned TRISC7    	: 1;
	};
} __TRISCbits_t;
extern volatile __TRISCbits_t __at (0xF94) TRISCbits;

extern __sfr __at (0xF9B) OSCTUNE;
typedef union {
	struct {
		unsigned TUN0      	: 1;
		unsigned TUN1      	: 1;
		unsigned TUN2      	: 1;
		unsigned TUN3      	: 1;
		unsigned TUN4      	: 1;
		unsigned TUN5      	: 1;
		unsigned SPLLEN    	: 1;
		unsigned INTSRC    	: 1;
	};
} __OSCTUNEbits_t;
extern volatile __OSCTUNEbits_t __at (0xF9B) OSCTUNEbits;

extern __sfr __at (0xF9D) PIE1;
typedef union {
	struct {
		unsigned TMR1IE    	: 1;
		unsigned TMR2IE    	: 1;
		unsigned CCP1IE    	: 1;
		unsigned SSPIE     	: 1;
		unsigned TXIE      	: 1;
		unsigned RCIE      	: 1;
		unsigned ADIE      	: 1;
		unsigned           	: 1;
	};
} __PIE1bits_t;
extern volatile __PIE1bits_t __at (0xF9D) PIE1bits;

extern __sfr __at (0xF9E) PIR1;
typedef union {
	struct {
		unsigned TMR1IF    	: 1;
		unsigned TMR2IF    	: 1;
		unsigned CCP1IF    	: 1;
		unsigned SSPIF     	: 1;
		unsigned TXIF      	: 1;
		unsigned RCIF      	: 1;
		unsigned ADIF      	: 1;
		unsigned           	: 1;
	};
} __PIR1bits_t;
extern volatile __PIR1bits_t __at (0xF9E) PIR1bits;

extern __sfr __at (0xF9F) IPR1;
typedef union {
	struct {
		unsigned TMR1IP    	: 1;
		unsigned TMR2IP    	: 1;
		unsigned CCP1IP    	: 1;
		unsigned SSPIP     	: 1;
		unsigned TXIP      	: 1;
		unsigned RCIP      	: 1;
		unsigned ADIP      	: 1;
		unsigned           	: 1;
	};
} __IPR1bits_t;
extern volatile __IPR1bits_t __at (0xF9F) IPR1bits;

extern __sfr __at (0xFA0) PIE2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned TMR3IE    	: 1;
		unsigned USBIE     	: 1;
		unsigned BCLIE     	: 1;
		unsigned EEIE      	: 1;
		unsigned C2IE      	: 1;
		unsigned C1IE      	: 1;
		unsigned OSCFIE    	: 1;
	};
} __PIE2bits_t;
extern volatile __PIE2bits_t __at (0xFA0) PIE2bits;

extern __sfr __at (0xFA1) PIR2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned TMR3IF    	: 1;
		unsigned USBIF     	: 1;
		unsigned BCLIF     	: 1;
		unsigned EEIF      	: 1;
		unsigned C2IF      	: 1;
		unsigned C1IF      	: 1;
		unsigned OSCFIF    	: 1;
	};
} __PIR2bits_t;
extern volatile __PIR2bits_t __at (0xFA1) PIR2bits;

extern __sfr __at (0xFA2) IPR2;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned TMR3IP    	: 1;
		unsigned USBIP     	: 1;
		unsigned BCLIP     	: 1;
		unsigned EEIP      	: 1;
		unsigned C2IP      	: 1;
		unsigned C1IP      	: 1;
		unsigned OSCFIP    	: 1;
	};
} __IPR2bits_t;
extern volatile __IPR2bits_t __at (0xFA2) IPR2bits;

extern __sfr __at (0xFA6) EECON1;
typedef union {
	struct {
		unsigned RD        	: 1;
		unsigned WR        	: 1;
		unsigned WREN      	: 1;
		unsigned WRERR     	: 1;
		unsigned FREE      	: 1;
		unsigned           	: 1;
		unsigned CFGS      	: 1;
		unsigned EEPGD     	: 1;
	};
} __EECON1bits_t;
extern volatile __EECON1bits_t __at (0xFA6) EECON1bits;

extern __sfr __at (0xFA7) EECON2;

extern __sfr __at (0xFA8) EEDATA;

extern __sfr __at (0xFA9) EEADR;
typedef union {
	struct {
		unsigned EEADR0    	: 1;
		unsigned EEADR1    	: 1;
		unsigned EEADR2    	: 1;
		unsigned EEADR3    	: 1;
		unsigned EEADR4    	: 1;
		unsigned EEADR5    	: 1;
		unsigned EEADR6    	: 1;
		unsigned EEADR7    	: 1;
	};
} __EEADRbits_t;
extern volatile __EEADRbits_t __at (0xFA9) EEADRbits;

extern __sfr __at (0xFAA) EEADRH;
typedef union {
	struct {
		unsigned EEADR8    	: 1;
		unsigned EEADR9    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __EEADRHbits_t;
extern volatile __EEADRHbits_t __at (0xFAA) EEADRHbits;

extern __sfr __at (0xFAB) RCSTA;
typedef union {
	struct {
		unsigned RX9D      	: 1;
		unsigned OERR      	: 1;
		unsigned FERR      	: 1;
		unsigned ADDEN     	: 1;
		unsigned CREN      	: 1;
		unsigned SREN      	: 1;
		unsigned RX9       	: 1;
		unsigned SPEN      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned ADEN      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCSTAbits_t;
extern volatile __RCSTAbits_t __at (0xFAB) RCSTAbits;

extern __sfr __at (0xFAC) TXSTA;
typedef union {
	struct {
		unsigned TX9D      	: 1;
		unsigned TRMT      	: 1;
		unsigned BRGH      	: 1;
		unsigned SENDB     	: 1;
		unsigned SYNC      	: 1;
		unsigned TXEN      	: 1;
		unsigned TX9       	: 1;
		unsigned CSRC      	: 1;
	};
} __TXSTAbits_t;
extern volatile __TXSTAbits_t __at (0xFAC) TXSTAbits;

extern __sfr __at (0xFAD) TXREG;

extern __sfr __at (0xFAE) RCREG;

extern __sfr __at (0xFAF) SPBRG;

extern __sfr __at (0xFB0) SPBRGH;

extern __sfr __at (0xFB1) T3CON;
typedef union {
	struct {
		unsigned TMR3ON    	: 1;
		unsigned TMR3CS    	: 1;
		unsigned T3SYNC    	: 1;
		unsigned T3CCP1    	: 1;
		unsigned T3CKPS0   	: 1;
		unsigned T3CKPS1   	: 1;
		unsigned           	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T3SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T3CONbits_t;
extern volatile __T3CONbits_t __at (0xFB1) T3CONbits;

extern __sfr __at (0xFB2) TMR3L;

extern __sfr __at (0xFB3) TMR3H;

extern __sfr __at (0xFB6) ECCP1AS;
typedef union {
	struct {
		unsigned PSSBD0    	: 1;
		unsigned PSSBD1    	: 1;
		unsigned PSSAC0    	: 1;
		unsigned PSSAC1    	: 1;
		unsigned ECCPAS0   	: 1;
		unsigned ECCPAS1   	: 1;
		unsigned ECCPAS2   	: 1;
		unsigned ECCPASE   	: 1;
	};
} __ECCP1ASbits_t;
extern volatile __ECCP1ASbits_t __at (0xFB6) ECCP1ASbits;

extern __sfr __at (0xFB7) PWM1CON;
typedef union {
	struct {
		unsigned PDC0      	: 1;
		unsigned PDC1      	: 1;
		unsigned PDC2      	: 1;
		unsigned PDC3      	: 1;
		unsigned PDC4      	: 1;
		unsigned PDC5      	: 1;
		unsigned PDC6      	: 1;
		unsigned PRSEN     	: 1;
	};
} __PWM1CONbits_t;
extern volatile __PWM1CONbits_t __at (0xFB7) PWM1CONbits;

extern __sfr __at (0xFB8) BAUDCON;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned CKTXP     	: 1;
		unsigned DTRXP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SCKP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __BAUDCONbits_t;
extern volatile __BAUDCONbits_t __at (0xFB8) BAUDCONbits;

extern __sfr __at (0xFB8) BAUDCTL;
typedef union {
	struct {
		unsigned ABDEN     	: 1;
		unsigned WUE       	: 1;
		unsigned           	: 1;
		unsigned BRG16     	: 1;
		unsigned CKTXP     	: 1;
		unsigned DTRXP     	: 1;
		unsigned RCIDL     	: 1;
		unsigned ABDOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned SCKP      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __BAUDCTLbits_t;
extern volatile __BAUDCTLbits_t __at (0xFB8) BAUDCTLbits;

extern __sfr __at (0xFB9) PSTRCON;
typedef union {
	struct {
		unsigned STRA      	: 1;
		unsigned STRB      	: 1;
		unsigned STRC      	: 1;
		unsigned STRD      	: 1;
		unsigned STRSYNC   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __PSTRCONbits_t;
extern volatile __PSTRCONbits_t __at (0xFB9) PSTRCONbits;

extern __sfr __at (0xFBA) REFCON0;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TSRS      	: 1;
		unsigned TSEN      	: 1;
		unsigned FVR1S0    	: 1;
		unsigned FVR1S1    	: 1;
		unsigned FVR1ST    	: 1;
		unsigned FVR1EN    	: 1;
	};
} __REFCON0bits_t;
extern volatile __REFCON0bits_t __at (0xFBA) REFCON0bits;

extern __sfr __at (0xFBA) VREFCON0;
typedef union {
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned TSRS      	: 1;
		unsigned TSEN      	: 1;
		unsigned FVR1S0    	: 1;
		unsigned FVR1S1    	: 1;
		unsigned FVR1ST    	: 1;
		unsigned FVR1EN    	: 1;
	};
} __VREFCON0bits_t;
extern volatile __VREFCON0bits_t __at (0xFBA) VREFCON0bits;

extern __sfr __at (0xFBB) REFCON1;
typedef union {
	struct {
		unsigned D1NSS     	: 1;
		unsigned           	: 1;
		unsigned D1PSS0    	: 1;
		unsigned D1PSS1    	: 1;
		unsigned           	: 1;
		unsigned DAC1OE    	: 1;
		unsigned D1LPS     	: 1;
		unsigned D1EN      	: 1;
	};
} __REFCON1bits_t;
extern volatile __REFCON1bits_t __at (0xFBB) REFCON1bits;

extern __sfr __at (0xFBB) VREFCON1;
typedef union {
	struct {
		unsigned D1NSS     	: 1;
		unsigned           	: 1;
		unsigned D1PSS0    	: 1;
		unsigned D1PSS1    	: 1;
		unsigned           	: 1;
		unsigned DAC1OE    	: 1;
		unsigned D1LPS     	: 1;
		unsigned D1EN      	: 1;
	};
} __VREFCON1bits_t;
extern volatile __VREFCON1bits_t __at (0xFBB) VREFCON1bits;

extern __sfr __at (0xFBC) REFCON2;
typedef union {
	struct {
		unsigned DAC1R0    	: 1;
		unsigned DAC1R1    	: 1;
		unsigned DAC1R2    	: 1;
		unsigned DAC1R3    	: 1;
		unsigned DAC1R4    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __REFCON2bits_t;
extern volatile __REFCON2bits_t __at (0xFBC) REFCON2bits;

extern __sfr __at (0xFBC) VREFCON2;
typedef union {
	struct {
		unsigned DAC1R0    	: 1;
		unsigned DAC1R1    	: 1;
		unsigned DAC1R2    	: 1;
		unsigned DAC1R3    	: 1;
		unsigned DAC1R4    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __VREFCON2bits_t;
extern volatile __VREFCON2bits_t __at (0xFBC) VREFCON2bits;

extern __sfr __at (0xFBD) CCP1CON;
typedef union {
	struct {
		unsigned CCP1M0    	: 1;
		unsigned CCP1M1    	: 1;
		unsigned CCP1M2    	: 1;
		unsigned CCP1M3    	: 1;
		unsigned DC1B0     	: 1;
		unsigned DC1B1     	: 1;
		unsigned P1M0      	: 1;
		unsigned P1M1      	: 1;
	};
} __CCP1CONbits_t;
extern volatile __CCP1CONbits_t __at (0xFBD) CCP1CONbits;

extern __sfr __at (0xFBE) CCPR1;

extern __sfr __at (0xFBE) CCPR1L;

extern __sfr __at (0xFBF) CCPR1H;

extern __sfr __at (0xFC0) ADCON2;
typedef union {
	struct {
		unsigned ADCS0     	: 1;
		unsigned ADCS1     	: 1;
		unsigned ADCS2     	: 1;
		unsigned ACQT0     	: 1;
		unsigned ACQT1     	: 1;
		unsigned ACQT2     	: 1;
		unsigned           	: 1;
		unsigned ADFM      	: 1;
	};
} __ADCON2bits_t;
extern volatile __ADCON2bits_t __at (0xFC0) ADCON2bits;

extern __sfr __at (0xFC1) ADCON1;
typedef union {
	struct {
		unsigned NVCFG0    	: 1;
		unsigned NVCFG1    	: 1;
		unsigned PVCFG0    	: 1;
		unsigned PVCFG1    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON1bits_t;
extern volatile __ADCON1bits_t __at (0xFC1) ADCON1bits;

extern __sfr __at (0xFC2) ADCON0;
typedef union {
	struct {
		unsigned ADON      	: 1;
		unsigned GO        	: 1;
		unsigned CHS0      	: 1;
		unsigned CHS1      	: 1;
		unsigned CHS2      	: 1;
		unsigned CHS3      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned DONE      	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned NOT_DONE  	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned GO_DONE   	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __ADCON0bits_t;
extern volatile __ADCON0bits_t __at (0xFC2) ADCON0bits;

extern __sfr __at (0xFC3) ADRES;

extern __sfr __at (0xFC3) ADRESL;

extern __sfr __at (0xFC4) ADRESH;

extern __sfr __at (0xFC5) SSPCON2;
typedef union {
	struct {
		unsigned SEN       	: 1;
		unsigned RSEN      	: 1;
		unsigned PEN       	: 1;
		unsigned RCEN      	: 1;
		unsigned ACKEN     	: 1;
		unsigned ACKDT     	: 1;
		unsigned ACKSTAT   	: 1;
		unsigned GCEN      	: 1;
	};
} __SSPCON2bits_t;
extern volatile __SSPCON2bits_t __at (0xFC5) SSPCON2bits;

extern __sfr __at (0xFC6) SSPCON1;
typedef union {
	struct {
		unsigned SSPM0     	: 1;
		unsigned SSPM1     	: 1;
		unsigned SSPM2     	: 1;
		unsigned SSPM3     	: 1;
		unsigned CKP       	: 1;
		unsigned SSPEN     	: 1;
		unsigned SSPOV     	: 1;
		unsigned WCOL      	: 1;
	};
} __SSPCON1bits_t;
extern volatile __SSPCON1bits_t __at (0xFC6) SSPCON1bits;

extern __sfr __at (0xFC7) SSPSTAT;
typedef union {
	struct {
		unsigned BF        	: 1;
		unsigned UA        	: 1;
		unsigned R         	: 1;
		unsigned S         	: 1;
		unsigned P         	: 1;
		unsigned D         	: 1;
		unsigned CKE       	: 1;
		unsigned SMP       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_W     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_A     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned R_W       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned D_A       	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_WRITE 	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_ADDRESS	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __SSPSTATbits_t;
extern volatile __SSPSTATbits_t __at (0xFC7) SSPSTATbits;

extern __sfr __at (0xFC8) SSPADD;

extern __sfr __at (0xFC9) SSPBUF;

extern __sfr __at (0xFCA) T2CON;
typedef union {
	struct {
		unsigned T2CKPS0   	: 1;
		unsigned T2CKPS1   	: 1;
		unsigned TMR2ON    	: 1;
		unsigned T2OUTPS0  	: 1;
		unsigned T2OUTPS1  	: 1;
		unsigned T2OUTPS2  	: 1;
		unsigned T2OUTPS3  	: 1;
		unsigned           	: 1;
	};
} __T2CONbits_t;
extern volatile __T2CONbits_t __at (0xFCA) T2CONbits;

extern __sfr __at (0xFCB) PR2;

extern __sfr __at (0xFCC) TMR2;

extern __sfr __at (0xFCD) T1CON;
typedef union {
	struct {
		unsigned TMR1ON    	: 1;
		unsigned TMR1CS    	: 1;
		unsigned T1SYNC    	: 1;
		unsigned T1OSCEN   	: 1;
		unsigned T1CKPS0   	: 1;
		unsigned T1CKPS1   	: 1;
		unsigned T1RUN     	: 1;
		unsigned RD16      	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_T1SYNC	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __T1CONbits_t;
extern volatile __T1CONbits_t __at (0xFCD) T1CONbits;

extern __sfr __at (0xFCE) TMR1L;

extern __sfr __at (0xFCF) TMR1H;

extern __sfr __at (0xFD0) RCON;
typedef union {
	struct {
		unsigned BOR       	: 1;
		unsigned POR       	: 1;
		unsigned PD        	: 1;
		unsigned TO        	: 1;
		unsigned RI        	: 1;
		unsigned           	: 1;
		unsigned SBOREN    	: 1;
		unsigned IPEN      	: 1;
	};
	struct {
		unsigned NOT_BOR   	: 1;
		unsigned NOT_POR   	: 1;
		unsigned NOT_PD    	: 1;
		unsigned NOT_TO    	: 1;
		unsigned NOT_RI    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __RCONbits_t;
extern volatile __RCONbits_t __at (0xFD0) RCONbits;

extern __sfr __at (0xFD1) WDTCON;
typedef union {
	struct {
		unsigned SWDTEN    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
	struct {
		unsigned SWDTE     	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __WDTCONbits_t;
extern volatile __WDTCONbits_t __at (0xFD1) WDTCONbits;

extern __sfr __at (0xFD2) OSCCON2;
typedef union {
	struct {
		unsigned LFIOFS    	: 1;
		unsigned HFIOFL    	: 1;
		unsigned PRI_SD    	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __OSCCON2bits_t;
extern volatile __OSCCON2bits_t __at (0xFD2) OSCCON2bits;

extern __sfr __at (0xFD3) OSCCON;
typedef union {
	struct {
		unsigned SCS0      	: 1;
		unsigned SCS1      	: 1;
		unsigned IOFS      	: 1;
		unsigned OSTS      	: 1;
		unsigned IRCF0     	: 1;
		unsigned IRCF1     	: 1;
		unsigned IRCF2     	: 1;
		unsigned IDLEN     	: 1;
	};
} __OSCCONbits_t;
extern volatile __OSCCONbits_t __at (0xFD3) OSCCONbits;

extern __sfr __at (0xFD5) T0CON;
typedef union {
	struct {
		unsigned T0PS0     	: 1;
		unsigned T0PS1     	: 1;
		unsigned T0PS2     	: 1;
		unsigned PSA       	: 1;
		unsigned T0SE      	: 1;
		unsigned T0CS      	: 1;
		unsigned T08BIT    	: 1;
		unsigned TMR0ON    	: 1;
	};
} __T0CONbits_t;
extern volatile __T0CONbits_t __at (0xFD5) T0CONbits;

extern __sfr __at (0xFD6) TMR0L;

extern __sfr __at (0xFD7) TMR0H;

extern __sfr __at (0xFD8) STATUS;
typedef union {
	struct {
		unsigned C         	: 1;
		unsigned DC        	: 1;
		unsigned Z         	: 1;
		unsigned OV        	: 1;
		unsigned N         	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
	};
} __STATUSbits_t;
extern volatile __STATUSbits_t __at (0xFD8) STATUSbits;

extern __sfr __at (0xFD9) FSR2L;

extern __sfr __at (0xFDA) FSR2H;

extern __sfr __at (0xFDB) PLUSW2;

extern __sfr __at (0xFDC) PREINC2;

extern __sfr __at (0xFDD) POSTDEC2;

extern __sfr __at (0xFDE) POSTINC2;

extern __sfr __at (0xFDF) INDF2;

extern __sfr __at (0xFE0) BSR;

extern __sfr __at (0xFE1) FSR1L;

extern __sfr __at (0xFE2) FSR1H;

extern __sfr __at (0xFE3) PLUSW1;

extern __sfr __at (0xFE4) PREINC1;

extern __sfr __at (0xFE5) POSTDEC1;

extern __sfr __at (0xFE6) POSTINC1;

extern __sfr __at (0xFE7) INDF1;

extern __sfr __at (0xFE8) WREG;

extern __sfr __at (0xFE9) FSR0L;

extern __sfr __at (0xFEA) FSR0H;

extern __sfr __at (0xFEB) PLUSW0;

extern __sfr __at (0xFEC) PREINC0;

extern __sfr __at (0xFED) POSTDEC0;

extern __sfr __at (0xFEE) POSTINC0;

extern __sfr __at (0xFEF) INDF0;

extern __sfr __at (0xFF0) INTCON3;
typedef union {
	struct {
		unsigned INT1F     	: 1;
		unsigned INT2F     	: 1;
		unsigned           	: 1;
		unsigned INT1E     	: 1;
		unsigned INT2E     	: 1;
		unsigned           	: 1;
		unsigned INT1P     	: 1;
		unsigned INT2P     	: 1;
	};
	struct {
		unsigned INT1IF    	: 1;
		unsigned INT2IF    	: 1;
		unsigned           	: 1;
		unsigned INT1IE    	: 1;
		unsigned INT2IE    	: 1;
		unsigned           	: 1;
		unsigned INT1IP    	: 1;
		unsigned INT2IP    	: 1;
	};
} __INTCON3bits_t;
extern volatile __INTCON3bits_t __at (0xFF0) INTCON3bits;

extern __sfr __at (0xFF1) INTCON2;
typedef union {
	struct {
		unsigned RABIP     	: 1;
		unsigned           	: 1;
		unsigned TMR0IP    	: 1;
		unsigned           	: 1;
		unsigned INTEDG2   	: 1;
		unsigned INTEDG1   	: 1;
		unsigned INTEDG0   	: 1;
		unsigned RABPU     	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned NOT_RABPU 	: 1;
	};
} __INTCON2bits_t;
extern volatile __INTCON2bits_t __at (0xFF1) INTCON2bits;

extern __sfr __at (0xFF2) INTCON;
typedef union {
	struct {
		unsigned RABIF     	: 1;
		unsigned INT0F     	: 1;
		unsigned TMR0IF    	: 1;
		unsigned RABIE     	: 1;
		unsigned INT0E     	: 1;
		unsigned TMR0IE    	: 1;
		unsigned PEIE      	: 1;
		unsigned GIE       	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned INT0IF    	: 1;
		unsigned T0IF      	: 1;
		unsigned           	: 1;
		unsigned INT0IE    	: 1;
		unsigned T0IE      	: 1;
		unsigned GIEL      	: 1;
		unsigned GIEH      	: 1;
	};
} __INTCONbits_t;
extern volatile __INTCONbits_t __at (0xFF2) INTCONbits;

extern __sfr __at (0xFF3) PROD;

extern __sfr __at (0xFF3) PRODL;

extern __sfr __at (0xFF4) PRODH;

extern __sfr __at (0xFF5) TABLAT;

extern __sfr __at (0xFF6) TBLPTR;

extern __sfr __at (0xFF6) TBLPTRL;

extern __sfr __at (0xFF7) TBLPTRH;

extern __sfr __at (0xFF8) TBLPTRU;

extern __sfr __at (0xFF9) PC;

extern __sfr __at (0xFF9) PCL;

extern __sfr __at (0xFFA) PCLATH;

extern __sfr __at (0xFFB) PCLATU;

extern __sfr __at (0xFFC) STKPTR;
typedef union {
	struct {
		unsigned SP0       	: 1;
		unsigned SP1       	: 1;
		unsigned SP2       	: 1;
		unsigned SP3       	: 1;
		unsigned SP4       	: 1;
		unsigned           	: 1;
		unsigned STKUNF    	: 1;
		unsigned STKOVF    	: 1;
	};
	struct {
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned           	: 1;
		unsigned STKFUL    	: 1;
	};
} __STKPTRbits_t;
extern volatile __STKPTRbits_t __at (0xFFC) STKPTRbits;

extern __sfr __at (0xFFD) TOS;

extern __sfr __at (0xFFD) TOSL;

extern __sfr __at (0xFFE) TOSH;

extern __sfr __at (0xFFF) TOSU;


#endif

