/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark.reporters;

import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.Reporter;
import com.thoughtworks.xstream.tools.benchmark.Target;
import java.io.PrintWriter;
import java.io.Writer;

public class TextReporter
implements Reporter {
    private final PrintWriter out;
    private Metric currentMetric;

    public TextReporter(PrintWriter out) {
        this.out = out;
    }

    public TextReporter(Writer out) {
        this(new PrintWriter(out));
    }

    public TextReporter() {
        this(new PrintWriter(System.out));
    }

    public void startBenchmark() {
    }

    public void startMetric(Metric metric) {
        this.currentMetric = metric;
        this.out.println("======================================================================");
        this.out.println(metric);
        this.out.println("======================================================================");
    }

    public void startTarget(Target target) {
        this.out.println("* " + target + "");
    }

    public void metricRecorded(Product product, double result) {
        this.out.println("  - " + this.pad(product.toString()) + " " + result + " " + this.currentMetric.unit());
    }

    public void metricFailed(Product product, Exception e) {
        this.out.println("  - " + this.pad(product.toString()) + " FAILED (" + e + ")");
    }

    public void endTarget(Target target) {
    }

    public void endMetric(Metric metric) {
        this.out.println();
        this.currentMetric = null;
    }

    public void endBenchmark() {
    }

    private String pad(String value) {
        StringBuffer result = new StringBuffer();
        result.append(value);
        while (result.length() < 50) {
            result.append('.');
        }
        return result.toString();
    }
}

