/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark;

import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.Reporter;
import com.thoughtworks.xstream.tools.benchmark.Target;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Harness {
    private List products = new ArrayList();
    private List targets = new ArrayList();
    private List metrics = new ArrayList();

    public synchronized void addProduct(Product product) {
        this.products.add(product);
    }

    public synchronized void addTarget(Target target) {
        this.targets.add(target);
    }

    public synchronized void addMetric(Metric metric) {
        this.metrics.add(metric);
    }

    public synchronized void run(Reporter reporter) {
        reporter.startBenchmark();
        Iterator metricsIt = this.metrics.iterator();
        while (metricsIt.hasNext()) {
            Metric metric = (Metric)metricsIt.next();
            reporter.startMetric(metric);
            Iterator targetIt = this.targets.iterator();
            while (targetIt.hasNext()) {
                Target target = (Target)targetIt.next();
                reporter.startTarget(target);
                Iterator productsIt = this.products.iterator();
                while (productsIt.hasNext()) {
                    Product product = (Product)productsIt.next();
                    this.run(reporter, metric, target, product);
                }
                reporter.endTarget(target);
            }
            reporter.endMetric(metric);
        }
        reporter.endBenchmark();
    }

    private void run(Reporter reporter, Metric metric, Target target, Product product) {
        try {
            double result = metric.run(product, target.target());
            reporter.metricRecorded(product, result);
        }
        catch (Exception e) {
            reporter.metricFailed(product, e);
        }
    }
}

