/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.util.Collection;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class ISODateTimeFormat {
    private static DateTimeFormatter ye;
    private static DateTimeFormatter mye;
    private static DateTimeFormatter dme;
    private static DateTimeFormatter we;
    private static DateTimeFormatter wwe;
    private static DateTimeFormatter dwe;
    private static DateTimeFormatter dye;
    private static DateTimeFormatter hde;
    private static DateTimeFormatter mhe;
    private static DateTimeFormatter sme;
    private static DateTimeFormatter lse;
    private static DateTimeFormatter fse;
    private static DateTimeFormatter ze;
    private static DateTimeFormatter lte;
    private static DateTimeFormatter ym;
    private static DateTimeFormatter ymd;
    private static DateTimeFormatter ww;
    private static DateTimeFormatter wwd;
    private static DateTimeFormatter hm;
    private static DateTimeFormatter hms;
    private static DateTimeFormatter hmsl;
    private static DateTimeFormatter hmsf;
    private static DateTimeFormatter dh;
    private static DateTimeFormatter dhm;
    private static DateTimeFormatter dhms;
    private static DateTimeFormatter dhmsl;
    private static DateTimeFormatter dhmsf;
    private static DateTimeFormatter t;
    private static DateTimeFormatter tx;
    private static DateTimeFormatter tt;
    private static DateTimeFormatter ttx;
    private static DateTimeFormatter dt;
    private static DateTimeFormatter dtx;
    private static DateTimeFormatter wdt;
    private static DateTimeFormatter wdtx;
    private static DateTimeFormatter od;
    private static DateTimeFormatter odt;
    private static DateTimeFormatter odtx;
    private static DateTimeFormatter bd;
    private static DateTimeFormatter bt;
    private static DateTimeFormatter btx;
    private static DateTimeFormatter btt;
    private static DateTimeFormatter bttx;
    private static DateTimeFormatter bdt;
    private static DateTimeFormatter bdtx;
    private static DateTimeFormatter bod;
    private static DateTimeFormatter bodt;
    private static DateTimeFormatter bodtx;
    private static DateTimeFormatter bwd;
    private static DateTimeFormatter bwdt;
    private static DateTimeFormatter bwdtx;
    private static DateTimeFormatter dpe;
    private static DateTimeFormatter tpe;
    private static DateTimeFormatter dp;
    private static DateTimeFormatter tp;
    private static DateTimeFormatter dtp;

    protected ISODateTimeFormat() {
    }

    public static DateTimeFormatter forFields(Collection fields, boolean extended, boolean strictISO) {
        if (fields == null || fields.size() == 0) {
            throw new IllegalArgumentException("The fields must not be null or empty");
        }
        int inputSize = fields.size();
        boolean reducedPrec = false;
        DateTimeFormatterBuilder bld = new DateTimeFormatterBuilder();
        if (fields.contains(DateTimeFieldType.monthOfYear())) {
            reducedPrec = ISODateTimeFormat.dateByMonth(bld, fields, extended, strictISO);
        } else if (fields.contains(DateTimeFieldType.dayOfYear())) {
            reducedPrec = ISODateTimeFormat.dateByOrdinal(bld, fields, extended, strictISO);
        } else if (fields.contains(DateTimeFieldType.weekOfWeekyear())) {
            reducedPrec = ISODateTimeFormat.dateByWeek(bld, fields, extended, strictISO);
        } else if (fields.contains(DateTimeFieldType.dayOfMonth())) {
            reducedPrec = ISODateTimeFormat.dateByMonth(bld, fields, extended, strictISO);
        } else if (fields.contains(DateTimeFieldType.dayOfWeek())) {
            reducedPrec = ISODateTimeFormat.dateByWeek(bld, fields, extended, strictISO);
        } else if (fields.remove(DateTimeFieldType.year())) {
            bld.append(ISODateTimeFormat.yearElement());
            reducedPrec = true;
        } else if (fields.remove(DateTimeFieldType.weekyear())) {
            bld.append(ISODateTimeFormat.weekyearElement());
            reducedPrec = true;
        }
        boolean datePresent = fields.size() < inputSize;
        ISODateTimeFormat.time(bld, fields, extended, strictISO, reducedPrec, datePresent);
        if (!bld.canBuildFormatter()) {
            throw new IllegalArgumentException("No valid format for fields: " + fields);
        }
        return bld.toFormatter();
    }

    private static boolean dateByMonth(DateTimeFormatterBuilder bld, Collection fields, boolean extended, boolean strictISO) {
        boolean reducedPrec = false;
        if (fields.remove(DateTimeFieldType.year())) {
            bld.append(ISODateTimeFormat.yearElement());
            if (fields.remove(DateTimeFieldType.monthOfYear())) {
                if (fields.remove(DateTimeFieldType.dayOfMonth())) {
                    ISODateTimeFormat.appendSeparator(bld, extended);
                    bld.appendMonthOfYear(2);
                    ISODateTimeFormat.appendSeparator(bld, extended);
                    bld.appendDayOfMonth(2);
                } else {
                    bld.appendLiteral('-');
                    bld.appendMonthOfYear(2);
                    reducedPrec = true;
                }
            } else if (fields.remove(DateTimeFieldType.dayOfMonth())) {
                ISODateTimeFormat.checkNotStrictISO(fields, strictISO);
                bld.appendLiteral('-');
                bld.appendLiteral('-');
                bld.appendDayOfMonth(2);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.monthOfYear())) {
            bld.appendLiteral('-');
            bld.appendLiteral('-');
            bld.appendMonthOfYear(2);
            if (fields.remove(DateTimeFieldType.dayOfMonth())) {
                ISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendDayOfMonth(2);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.dayOfMonth())) {
            bld.appendLiteral('-');
            bld.appendLiteral('-');
            bld.appendLiteral('-');
            bld.appendDayOfMonth(2);
        }
        return reducedPrec;
    }

    private static boolean dateByOrdinal(DateTimeFormatterBuilder bld, Collection fields, boolean extended, boolean strictISO) {
        boolean reducedPrec = false;
        if (fields.remove(DateTimeFieldType.year())) {
            bld.append(ISODateTimeFormat.yearElement());
            if (fields.remove(DateTimeFieldType.dayOfYear())) {
                ISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendDayOfYear(3);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.dayOfYear())) {
            bld.appendLiteral('-');
            bld.appendDayOfYear(3);
        }
        return reducedPrec;
    }

    private static boolean dateByWeek(DateTimeFormatterBuilder bld, Collection fields, boolean extended, boolean strictISO) {
        boolean reducedPrec = false;
        if (fields.remove(DateTimeFieldType.weekyear())) {
            bld.append(ISODateTimeFormat.weekyearElement());
            if (fields.remove(DateTimeFieldType.weekOfWeekyear())) {
                ISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendLiteral('W');
                bld.appendWeekOfWeekyear(2);
                if (fields.remove(DateTimeFieldType.dayOfWeek())) {
                    ISODateTimeFormat.appendSeparator(bld, extended);
                    bld.appendDayOfWeek(1);
                } else {
                    reducedPrec = true;
                }
            } else if (fields.remove(DateTimeFieldType.dayOfWeek())) {
                ISODateTimeFormat.checkNotStrictISO(fields, strictISO);
                ISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendLiteral('W');
                bld.appendLiteral('-');
                bld.appendDayOfWeek(1);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.weekOfWeekyear())) {
            bld.appendLiteral('-');
            bld.appendLiteral('W');
            bld.appendWeekOfWeekyear(2);
            if (fields.remove(DateTimeFieldType.dayOfWeek())) {
                ISODateTimeFormat.appendSeparator(bld, extended);
                bld.appendDayOfWeek(1);
            } else {
                reducedPrec = true;
            }
        } else if (fields.remove(DateTimeFieldType.dayOfWeek())) {
            bld.appendLiteral('-');
            bld.appendLiteral('W');
            bld.appendLiteral('-');
            bld.appendDayOfWeek(1);
        }
        return reducedPrec;
    }

    private static void time(DateTimeFormatterBuilder bld, Collection fields, boolean extended, boolean strictISO, boolean reducedPrec, boolean datePresent) {
        boolean hour = fields.remove(DateTimeFieldType.hourOfDay());
        boolean minute = fields.remove(DateTimeFieldType.minuteOfHour());
        boolean second = fields.remove(DateTimeFieldType.secondOfMinute());
        boolean milli = fields.remove(DateTimeFieldType.millisOfSecond());
        if (!(hour || minute || second || milli)) {
            return;
        }
        if (hour || minute || second || milli) {
            if (strictISO && reducedPrec) {
                throw new IllegalArgumentException("No valid ISO8601 format for fields because Date was reduced precision: " + fields);
            }
            if (datePresent) {
                bld.appendLiteral('T');
            }
        }
        if (!(hour && minute && second || hour && !second && !milli)) {
            if (strictISO && datePresent) {
                throw new IllegalArgumentException("No valid ISO8601 format for fields because Time was truncated: " + fields);
            }
            if (!(!hour && (minute && second || minute && !milli || second) || !strictISO)) {
                throw new IllegalArgumentException("No valid ISO8601 format for fields: " + fields);
            }
        }
        if (hour) {
            bld.appendHourOfDay(2);
        } else if (minute || second || milli) {
            bld.appendLiteral('-');
        }
        if (extended && hour && minute) {
            bld.appendLiteral(':');
        }
        if (minute) {
            bld.appendMinuteOfHour(2);
        } else if (second || milli) {
            bld.appendLiteral('-');
        }
        if (extended && minute && second) {
            bld.appendLiteral(':');
        }
        if (second) {
            bld.appendSecondOfMinute(2);
        } else if (milli) {
            bld.appendLiteral('-');
        }
        if (milli) {
            bld.appendLiteral('.');
            bld.appendMillisOfSecond(3);
        }
    }

    private static void checkNotStrictISO(Collection fields, boolean strictISO) {
        if (strictISO) {
            throw new IllegalArgumentException("No valid ISO8601 format for fields: " + fields);
        }
    }

    private static void appendSeparator(DateTimeFormatterBuilder bld, boolean extended) {
        if (extended) {
            bld.appendLiteral('-');
        }
    }

    public static DateTimeFormatter dateParser() {
        if (dp == null) {
            dp = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).appendOptional(new DateTimeFormatterBuilder().appendLiteral('T').append(ISODateTimeFormat.offsetElement()).toParser()).toFormatter();
        }
        return dp;
    }

    public static DateTimeFormatter dateElementParser() {
        if (dpe == null) {
            dpe = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearElement()).appendOptional(new DateTimeFormatterBuilder().append(ISODateTimeFormat.monthElement()).appendOptional(ISODateTimeFormat.dayOfMonthElement().getParser()).toParser()).toParser(), new DateTimeFormatterBuilder().append(ISODateTimeFormat.weekyearElement()).append(ISODateTimeFormat.weekElement()).appendOptional(ISODateTimeFormat.dayOfWeekElement().getParser()).toParser(), new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearElement()).append(ISODateTimeFormat.dayOfYearElement()).toParser()}).toFormatter();
        }
        return dpe;
    }

    public static DateTimeFormatter timeParser() {
        if (tp == null) {
            tp = new DateTimeFormatterBuilder().appendOptional(new DateTimeFormatterBuilder().appendLiteral('T').toParser()).append(ISODateTimeFormat.timeElementParser()).appendOptional(ISODateTimeFormat.offsetElement().getParser()).toFormatter();
        }
        return tp;
    }

    public static DateTimeFormatter timeElementParser() {
        if (tpe == null) {
            DateTimeParser decimalPoint = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('.').toParser(), new DateTimeFormatterBuilder().appendLiteral(',').toParser()}).toParser();
            tpe = new DateTimeFormatterBuilder().append(ISODateTimeFormat.hourElement()).append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(ISODateTimeFormat.minuteElement()).append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().append(ISODateTimeFormat.secondElement()).appendOptional(new DateTimeFormatterBuilder().append(decimalPoint).appendFractionOfSecond(1, 9).toParser()).toParser(), new DateTimeFormatterBuilder().append(decimalPoint).appendFractionOfMinute(1, 9).toParser(), null}).toParser(), new DateTimeFormatterBuilder().append(decimalPoint).appendFractionOfHour(1, 9).toParser(), null}).toFormatter();
        }
        return tpe;
    }

    public static DateTimeFormatter dateTimeParser() {
        if (dtp == null) {
            DateTimeParser time = new DateTimeFormatterBuilder().appendLiteral('T').append(ISODateTimeFormat.timeElementParser()).appendOptional(ISODateTimeFormat.offsetElement().getParser()).toParser();
            dtp = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{time, new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).append(null, new DateTimeParser[]{time, new DateTimeFormatterBuilder().appendLiteral('T').append(ISODateTimeFormat.offsetElement()).toParser(), null}).toParser()}).toFormatter();
        }
        return dtp;
    }

    public static DateTimeFormatter date() {
        return ISODateTimeFormat.yearMonthDay();
    }

    public static DateTimeFormatter time() {
        if (t == null) {
            t = new DateTimeFormatterBuilder().append(ISODateTimeFormat.hourMinuteSecondMillis()).append(ISODateTimeFormat.offsetElement()).toFormatter();
        }
        return t;
    }

    public static DateTimeFormatter timeNoMillis() {
        if (tx == null) {
            tx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.hourMinuteSecond()).append(ISODateTimeFormat.offsetElement()).toFormatter();
        }
        return tx;
    }

    public static DateTimeFormatter tTime() {
        if (tt == null) {
            tt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.time()).toFormatter();
        }
        return tt;
    }

    public static DateTimeFormatter tTimeNoMillis() {
        if (ttx == null) {
            ttx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.timeNoMillis()).toFormatter();
        }
        return ttx;
    }

    public static DateTimeFormatter dateTime() {
        if (dt == null) {
            dt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).append(ISODateTimeFormat.tTime()).toFormatter();
        }
        return dt;
    }

    public static DateTimeFormatter dateTimeNoMillis() {
        if (dtx == null) {
            dtx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).append(ISODateTimeFormat.tTimeNoMillis()).toFormatter();
        }
        return dtx;
    }

    public static DateTimeFormatter ordinalDate() {
        if (od == null) {
            od = new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearElement()).append(ISODateTimeFormat.dayOfYearElement()).toFormatter();
        }
        return od;
    }

    public static DateTimeFormatter ordinalDateTime() {
        if (odt == null) {
            odt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.ordinalDate()).append(ISODateTimeFormat.tTime()).toFormatter();
        }
        return odt;
    }

    public static DateTimeFormatter ordinalDateTimeNoMillis() {
        if (odtx == null) {
            odtx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.ordinalDate()).append(ISODateTimeFormat.tTimeNoMillis()).toFormatter();
        }
        return odtx;
    }

    public static DateTimeFormatter weekDate() {
        return ISODateTimeFormat.weekyearWeekDay();
    }

    public static DateTimeFormatter weekDateTime() {
        if (wdt == null) {
            wdt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.weekDate()).append(ISODateTimeFormat.tTime()).toFormatter();
        }
        return wdt;
    }

    public static DateTimeFormatter weekDateTimeNoMillis() {
        if (wdtx == null) {
            wdtx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.weekDate()).append(ISODateTimeFormat.tTimeNoMillis()).toFormatter();
        }
        return wdtx;
    }

    public static DateTimeFormatter basicDate() {
        if (bd == null) {
            bd = new DateTimeFormatterBuilder().appendYear(4, 4).appendMonthOfYear(2).appendDayOfMonth(2).toFormatter();
        }
        return bd;
    }

    public static DateTimeFormatter basicTime() {
        if (bt == null) {
            bt = new DateTimeFormatterBuilder().appendHourOfDay(2).appendMinuteOfHour(2).appendSecondOfMinute(2).appendLiteral('.').appendMillisOfSecond(3).appendTimeZoneOffset("Z", false, 2, 2).toFormatter();
        }
        return bt;
    }

    public static DateTimeFormatter basicTimeNoMillis() {
        if (btx == null) {
            btx = new DateTimeFormatterBuilder().appendHourOfDay(2).appendMinuteOfHour(2).appendSecondOfMinute(2).appendTimeZoneOffset("Z", false, 2, 2).toFormatter();
        }
        return btx;
    }

    public static DateTimeFormatter basicTTime() {
        if (btt == null) {
            btt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.basicTime()).toFormatter();
        }
        return btt;
    }

    public static DateTimeFormatter basicTTimeNoMillis() {
        if (bttx == null) {
            bttx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.basicTimeNoMillis()).toFormatter();
        }
        return bttx;
    }

    public static DateTimeFormatter basicDateTime() {
        if (bdt == null) {
            bdt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.basicDate()).append(ISODateTimeFormat.basicTTime()).toFormatter();
        }
        return bdt;
    }

    public static DateTimeFormatter basicDateTimeNoMillis() {
        if (bdtx == null) {
            bdtx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.basicDate()).append(ISODateTimeFormat.basicTTimeNoMillis()).toFormatter();
        }
        return bdtx;
    }

    public static DateTimeFormatter basicOrdinalDate() {
        if (bod == null) {
            bod = new DateTimeFormatterBuilder().appendYear(4, 4).appendDayOfYear(3).toFormatter();
        }
        return bod;
    }

    public static DateTimeFormatter basicOrdinalDateTime() {
        if (bodt == null) {
            bodt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.basicOrdinalDate()).append(ISODateTimeFormat.basicTTime()).toFormatter();
        }
        return bodt;
    }

    public static DateTimeFormatter basicOrdinalDateTimeNoMillis() {
        if (bodtx == null) {
            bodtx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.basicOrdinalDate()).append(ISODateTimeFormat.basicTTimeNoMillis()).toFormatter();
        }
        return bodtx;
    }

    public static DateTimeFormatter basicWeekDate() {
        if (bwd == null) {
            bwd = new DateTimeFormatterBuilder().appendWeekyear(4, 4).appendLiteral('W').appendWeekOfWeekyear(2).appendDayOfWeek(1).toFormatter();
        }
        return bwd;
    }

    public static DateTimeFormatter basicWeekDateTime() {
        if (bwdt == null) {
            bwdt = new DateTimeFormatterBuilder().append(ISODateTimeFormat.basicWeekDate()).append(ISODateTimeFormat.basicTTime()).toFormatter();
        }
        return bwdt;
    }

    public static DateTimeFormatter basicWeekDateTimeNoMillis() {
        if (bwdtx == null) {
            bwdtx = new DateTimeFormatterBuilder().append(ISODateTimeFormat.basicWeekDate()).append(ISODateTimeFormat.basicTTimeNoMillis()).toFormatter();
        }
        return bwdtx;
    }

    public static DateTimeFormatter year() {
        return ISODateTimeFormat.yearElement();
    }

    public static DateTimeFormatter yearMonth() {
        if (ym == null) {
            ym = new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearElement()).append(ISODateTimeFormat.monthElement()).toFormatter();
        }
        return ym;
    }

    public static DateTimeFormatter yearMonthDay() {
        if (ymd == null) {
            ymd = new DateTimeFormatterBuilder().append(ISODateTimeFormat.yearElement()).append(ISODateTimeFormat.monthElement()).append(ISODateTimeFormat.dayOfMonthElement()).toFormatter();
        }
        return ymd;
    }

    public static DateTimeFormatter weekyear() {
        return ISODateTimeFormat.weekyearElement();
    }

    public static DateTimeFormatter weekyearWeek() {
        if (ww == null) {
            ww = new DateTimeFormatterBuilder().append(ISODateTimeFormat.weekyearElement()).append(ISODateTimeFormat.weekElement()).toFormatter();
        }
        return ww;
    }

    public static DateTimeFormatter weekyearWeekDay() {
        if (wwd == null) {
            wwd = new DateTimeFormatterBuilder().append(ISODateTimeFormat.weekyearElement()).append(ISODateTimeFormat.weekElement()).append(ISODateTimeFormat.dayOfWeekElement()).toFormatter();
        }
        return wwd;
    }

    public static DateTimeFormatter hour() {
        return ISODateTimeFormat.hourElement();
    }

    public static DateTimeFormatter hourMinute() {
        if (hm == null) {
            hm = new DateTimeFormatterBuilder().append(ISODateTimeFormat.hourElement()).append(ISODateTimeFormat.minuteElement()).toFormatter();
        }
        return hm;
    }

    public static DateTimeFormatter hourMinuteSecond() {
        if (hms == null) {
            hms = new DateTimeFormatterBuilder().append(ISODateTimeFormat.hourElement()).append(ISODateTimeFormat.minuteElement()).append(ISODateTimeFormat.secondElement()).toFormatter();
        }
        return hms;
    }

    public static DateTimeFormatter hourMinuteSecondMillis() {
        if (hmsl == null) {
            hmsl = new DateTimeFormatterBuilder().append(ISODateTimeFormat.hourElement()).append(ISODateTimeFormat.minuteElement()).append(ISODateTimeFormat.secondElement()).append(ISODateTimeFormat.millisElement()).toFormatter();
        }
        return hmsl;
    }

    public static DateTimeFormatter hourMinuteSecondFraction() {
        if (hmsf == null) {
            hmsf = new DateTimeFormatterBuilder().append(ISODateTimeFormat.hourElement()).append(ISODateTimeFormat.minuteElement()).append(ISODateTimeFormat.secondElement()).append(ISODateTimeFormat.fractionElement()).toFormatter();
        }
        return hmsf;
    }

    public static DateTimeFormatter dateHour() {
        if (dh == null) {
            dh = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.hour()).toFormatter();
        }
        return dh;
    }

    public static DateTimeFormatter dateHourMinute() {
        if (dhm == null) {
            dhm = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.hourMinute()).toFormatter();
        }
        return dhm;
    }

    public static DateTimeFormatter dateHourMinuteSecond() {
        if (dhms == null) {
            dhms = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.hourMinuteSecond()).toFormatter();
        }
        return dhms;
    }

    public static DateTimeFormatter dateHourMinuteSecondMillis() {
        if (dhmsl == null) {
            dhmsl = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.hourMinuteSecondMillis()).toFormatter();
        }
        return dhmsl;
    }

    public static DateTimeFormatter dateHourMinuteSecondFraction() {
        if (dhmsf == null) {
            dhmsf = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).append(ISODateTimeFormat.literalTElement()).append(ISODateTimeFormat.hourMinuteSecondFraction()).toFormatter();
        }
        return dhmsf;
    }

    private static DateTimeFormatter yearElement() {
        if (ye == null) {
            ye = new DateTimeFormatterBuilder().appendYear(4, 9).toFormatter();
        }
        return ye;
    }

    private static DateTimeFormatter monthElement() {
        if (mye == null) {
            mye = new DateTimeFormatterBuilder().appendLiteral('-').appendMonthOfYear(2).toFormatter();
        }
        return mye;
    }

    private static DateTimeFormatter dayOfMonthElement() {
        if (dme == null) {
            dme = new DateTimeFormatterBuilder().appendLiteral('-').appendDayOfMonth(2).toFormatter();
        }
        return dme;
    }

    private static DateTimeFormatter weekyearElement() {
        if (we == null) {
            we = new DateTimeFormatterBuilder().appendWeekyear(4, 9).toFormatter();
        }
        return we;
    }

    private static DateTimeFormatter weekElement() {
        if (wwe == null) {
            wwe = new DateTimeFormatterBuilder().appendLiteral("-W").appendWeekOfWeekyear(2).toFormatter();
        }
        return wwe;
    }

    private static DateTimeFormatter dayOfWeekElement() {
        if (dwe == null) {
            dwe = new DateTimeFormatterBuilder().appendLiteral('-').appendDayOfWeek(1).toFormatter();
        }
        return dwe;
    }

    private static DateTimeFormatter dayOfYearElement() {
        if (dye == null) {
            dye = new DateTimeFormatterBuilder().appendLiteral('-').appendDayOfYear(3).toFormatter();
        }
        return dye;
    }

    private static DateTimeFormatter literalTElement() {
        if (lte == null) {
            lte = new DateTimeFormatterBuilder().appendLiteral('T').toFormatter();
        }
        return lte;
    }

    private static DateTimeFormatter hourElement() {
        if (hde == null) {
            hde = new DateTimeFormatterBuilder().appendHourOfDay(2).toFormatter();
        }
        return hde;
    }

    private static DateTimeFormatter minuteElement() {
        if (mhe == null) {
            mhe = new DateTimeFormatterBuilder().appendLiteral(':').appendMinuteOfHour(2).toFormatter();
        }
        return mhe;
    }

    private static DateTimeFormatter secondElement() {
        if (sme == null) {
            sme = new DateTimeFormatterBuilder().appendLiteral(':').appendSecondOfMinute(2).toFormatter();
        }
        return sme;
    }

    private static DateTimeFormatter millisElement() {
        if (lse == null) {
            lse = new DateTimeFormatterBuilder().appendLiteral('.').appendMillisOfSecond(3).toFormatter();
        }
        return lse;
    }

    private static DateTimeFormatter fractionElement() {
        if (fse == null) {
            fse = new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(3, 9).toFormatter();
        }
        return fse;
    }

    private static DateTimeFormatter offsetElement() {
        if (ze == null) {
            ze = new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
        }
        return ze;
    }
}

