/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.StrictDateTimeField;

public class LenientDateTimeField
extends DelegatedDateTimeField {
    private static final long serialVersionUID = 8714085824173290599L;

    public static DateTimeField getInstance(DateTimeField field) {
        if (field == null) {
            return null;
        }
        if (field instanceof StrictDateTimeField) {
            field = ((StrictDateTimeField)field).getWrappedField();
        }
        if (field.isLenient()) {
            return field;
        }
        return new LenientDateTimeField(field);
    }

    protected LenientDateTimeField(DateTimeField field) {
        super(field);
    }

    public final boolean isLenient() {
        return true;
    }

    public long set(long instant, int value) {
        int min = this.getMinimumValue(instant);
        if (value >= min && value < this.getMaximumValue(instant)) {
            return super.set(instant, value);
        }
        return this.add(super.set(instant, min), value - min);
    }
}

