/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicFixedMonthChronology
extends BasicChronology {
    private static final long serialVersionUID = 261387371998L;
    static final int MONTH_LENGTH = 30;
    static final long MILLIS_PER_YEAR = 31557600000L;
    static final long MILLIS_PER_MONTH = 2592000000L;

    BasicFixedMonthChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    long setYear(long instant, int year) {
        int thisYear = this.getYear(instant);
        int dayOfYear = this.getDayOfYear(instant, thisYear);
        int millisOfDay = this.getMillisOfDay(instant);
        if (dayOfYear > 365 && !this.isLeapYear(year)) {
            --dayOfYear;
        }
        instant = this.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    long getYearDifference(long minuendInstant, long subtrahendInstant) {
        int minuendYear = this.getYear(minuendInstant);
        int subtrahendYear = this.getYear(subtrahendInstant);
        long minuendRem = minuendInstant - this.getYearMillis(minuendYear);
        long subtrahendRem = subtrahendInstant - this.getYearMillis(subtrahendYear);
        int difference = minuendYear - subtrahendYear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    long getTotalMillisByYearMonth(int year, int month) {
        return (long)(month - 1) * 2592000000L;
    }

    int getDayOfMonth(long millis) {
        return (this.getDayOfYear(millis) - 1) % 30 + 1;
    }

    boolean isLeapYear(int year) {
        return (year & 3) == 3;
    }

    int getDaysInYearMonth(int year, int month) {
        return month != 13 ? 30 : (this.isLeapYear(year) ? 6 : 5);
    }

    int getDaysInMonthMax() {
        return 30;
    }

    int getDaysInMonthMax(int month) {
        return month != 13 ? 30 : 6;
    }

    int getMonthOfYear(long millis) {
        return (this.getDayOfYear(millis) - 1) / 30 + 1;
    }

    int getMonthOfYear(long millis, int year) {
        long monthZeroBased = (millis - this.getYearMillis(year)) / 2592000000L;
        return (int)monthZeroBased + 1;
    }

    int getMaxMonth() {
        return 13;
    }

    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    long getAverageMillisPerMonth() {
        return 2592000000L;
    }
}

