/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ScaledDurationField;

public class RemainderDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 5708241235177666790L;
    final int iDivisor;
    final DurationField iRangeField;

    public RemainderDateTimeField(DateTimeField field, DateTimeFieldType type, int divisor) {
        super(field, type);
        if (divisor < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField rangeField = field.getDurationField();
        this.iRangeField = rangeField == null ? null : new ScaledDurationField(rangeField, type.getRangeDurationType(), divisor);
        this.iDivisor = divisor;
    }

    public RemainderDateTimeField(DividedDateTimeField dividedField) {
        this(dividedField, dividedField.getType());
    }

    public RemainderDateTimeField(DividedDateTimeField dividedField, DateTimeFieldType type) {
        super(dividedField.getWrappedField(), type);
        this.iDivisor = dividedField.iDivisor;
        this.iRangeField = dividedField.iDurationField;
    }

    public int get(long instant) {
        int value = this.getWrappedField().get(instant);
        if (value >= 0) {
            return value % this.iDivisor;
        }
        return this.iDivisor - 1 + (value + 1) % this.iDivisor;
    }

    public long addWrapField(long instant, int amount) {
        return this.set(instant, FieldUtils.getWrappedValue(this.get(instant), amount, 0, this.iDivisor - 1));
    }

    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, 0, this.iDivisor - 1);
        int divided = this.getDivided(this.getWrappedField().get(instant));
        return this.getWrappedField().set(instant, divided * this.iDivisor + value);
    }

    public DurationField getRangeDurationField() {
        return this.iRangeField;
    }

    public int getMinimumValue() {
        return 0;
    }

    public int getMaximumValue() {
        return this.iDivisor - 1;
    }

    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    public long roundHalfFloor(long instant) {
        return this.getWrappedField().roundHalfFloor(instant);
    }

    public long roundHalfCeiling(long instant) {
        return this.getWrappedField().roundHalfCeiling(instant);
    }

    public long roundHalfEven(long instant) {
        return this.getWrappedField().roundHalfEven(instant);
    }

    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    private int getDivided(int value) {
        if (value >= 0) {
            return value / this.iDivisor;
        }
        return (value + 1) / this.iDivisor - 1;
    }
}

