/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;

public class OffsetDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 3145790132623583142L;
    private final int iOffset;
    private final int iMin;
    private final int iMax;

    public OffsetDateTimeField(DateTimeField field, int offset) {
        this(field, field == null ? null : field.getType(), offset, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField field, DateTimeFieldType type, int offset) {
        this(field, type, offset, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public OffsetDateTimeField(DateTimeField field, DateTimeFieldType type, int offset, int minValue, int maxValue) {
        super(field, type);
        if (offset == 0) {
            throw new IllegalArgumentException("The offset cannot be zero");
        }
        this.iOffset = offset;
        this.iMin = minValue < field.getMinimumValue() + offset ? field.getMinimumValue() + offset : minValue;
        this.iMax = maxValue > field.getMaximumValue() + offset ? field.getMaximumValue() + offset : maxValue;
    }

    public int get(long instant) {
        return super.get(instant) + this.iOffset;
    }

    public long add(long instant, int amount) {
        instant = super.add(instant, amount);
        FieldUtils.verifyValueBounds(this, this.get(instant), this.iMin, this.iMax);
        return instant;
    }

    public long add(long instant, long amount) {
        instant = super.add(instant, amount);
        FieldUtils.verifyValueBounds(this, this.get(instant), this.iMin, this.iMax);
        return instant;
    }

    public long addWrapField(long instant, int amount) {
        return this.set(instant, FieldUtils.getWrappedValue(this.get(instant), amount, this.iMin, this.iMax));
    }

    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, this.iMin, this.iMax);
        return super.set(instant, value - this.iOffset);
    }

    public boolean isLeap(long instant) {
        return this.getWrappedField().isLeap(instant);
    }

    public int getLeapAmount(long instant) {
        return this.getWrappedField().getLeapAmount(instant);
    }

    public DurationField getLeapDurationField() {
        return this.getWrappedField().getLeapDurationField();
    }

    public int getMinimumValue() {
        return this.iMin;
    }

    public int getMaximumValue() {
        return this.iMax;
    }

    public long roundFloor(long instant) {
        return this.getWrappedField().roundFloor(instant);
    }

    public long roundCeiling(long instant) {
        return this.getWrappedField().roundCeiling(instant);
    }

    public long roundHalfFloor(long instant) {
        return this.getWrappedField().roundHalfFloor(instant);
    }

    public long roundHalfCeiling(long instant) {
        return this.getWrappedField().roundHalfCeiling(instant);
    }

    public long roundHalfEven(long instant) {
        return this.getWrappedField().roundHalfEven(instant);
    }

    public long remainder(long instant) {
        return this.getWrappedField().remainder(instant);
    }

    public int getOffset() {
        return this.iOffset;
    }
}

