/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -4677223814028011723L;
    private final BasicChronology iChronology;

    BasicDayOfMonthDateTimeField(BasicChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfMonth(), days);
        this.iChronology = chronology;
    }

    public int get(long instant) {
        return this.iChronology.getDayOfMonth(instant);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.iChronology.getDaysInMonthMax();
    }

    public int getMaximumValue(long instant) {
        return this.iChronology.getDaysInMonthMax(instant);
    }

    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.monthOfYear())) {
            int month = partial.get(DateTimeFieldType.monthOfYear());
            if (partial.isSupported(DateTimeFieldType.year())) {
                int year = partial.get(DateTimeFieldType.year());
                return this.iChronology.getDaysInYearMonth(year, month);
            }
            return this.iChronology.getDaysInMonthMax(month);
        }
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        int i = 0;
        while (i < size) {
            if (partial.getFieldType(i) == DateTimeFieldType.monthOfYear()) {
                int month = values[i];
                int j = 0;
                while (j < size) {
                    if (partial.getFieldType(j) == DateTimeFieldType.year()) {
                        int year = values[j];
                        return this.iChronology.getDaysInYearMonth(year, month);
                    }
                    ++j;
                }
                return this.iChronology.getDaysInMonthMax(month);
            }
            ++i;
        }
        return this.getMaximumValue();
    }

    protected int getMaximumValueForSet(long instant, int value) {
        return this.iChronology.getDaysInMonthMaxForSet(instant, value);
    }

    private Object readResolve() {
        return this.iChronology.dayOfMonth();
    }
}

