/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.convert.Converter;

class ConverterSet {
    private final Converter[] iConverters;
    private Entry[] iSelectEntries;

    ConverterSet(Converter[] converters) {
        this.iConverters = converters;
        this.iSelectEntries = new Entry[16];
    }

    /*
     * WARNING - void declaration
     */
    Converter select(Class type) throws IllegalStateException {
        Entry e;
        Entry[] entries = this.iSelectEntries;
        int length = entries.length;
        int index = type == null ? 0 : type.hashCode() & length - 1;
        while ((e = entries[index]) != null) {
            void var5_5;
            if (var5_5.iType == type) {
                return var5_5.iConverter;
            }
            if (++index < length) continue;
            index = 0;
        }
        Converter converter = ConverterSet.selectSlow(this, type);
        e = new Entry(type, converter);
        entries = (Entry[])entries.clone();
        entries[index] = e;
        int i = 0;
        while (i < length) {
            if (entries[i] == null) {
                this.iSelectEntries = entries;
                return converter;
            }
            ++i;
        }
        int newLength = length << 1;
        Entry[] newEntries = new Entry[newLength];
        int i2 = 0;
        while (i2 < length) {
            e = entries[i2];
            type = e.iType;
            index = type == null ? 0 : type.hashCode() & newLength - 1;
            while (newEntries[index] != null) {
                if (++index < newLength) continue;
                index = 0;
            }
            newEntries[index] = e;
            ++i2;
        }
        this.iSelectEntries = newEntries;
        return converter;
    }

    int size() {
        return this.iConverters.length;
    }

    void copyInto(Converter[] converters) {
        System.arraycopy(this.iConverters, 0, converters, 0, this.iConverters.length);
    }

    ConverterSet add(Converter converter, Converter[] removed) {
        Converter[] converters = this.iConverters;
        int length = converters.length;
        int i = 0;
        while (i < length) {
            Converter existing = converters[i];
            if (converter.equals(existing)) {
                if (removed != null) {
                    removed[0] = null;
                }
                return this;
            }
            if (converter.getSupportedType() == existing.getSupportedType()) {
                Converter[] copy = new Converter[length];
                int j = 0;
                while (j < length) {
                    copy[j] = j != i ? converters[j] : converter;
                    ++j;
                }
                if (removed != null) {
                    removed[0] = existing;
                }
                return new ConverterSet(copy);
            }
            ++i;
        }
        Converter[] copy = new Converter[length + 1];
        System.arraycopy(converters, 0, copy, 0, length);
        copy[length] = converter;
        if (removed != null) {
            removed[0] = null;
        }
        return new ConverterSet(copy);
    }

    ConverterSet remove(Converter converter, Converter[] removed) {
        Converter[] converters = this.iConverters;
        int length = converters.length;
        int i = 0;
        while (i < length) {
            if (converter.equals(converters[i])) {
                return this.remove(i, removed);
            }
            ++i;
        }
        if (removed != null) {
            removed[0] = null;
        }
        return this;
    }

    ConverterSet remove(int index, Converter[] removed) {
        Converter[] converters = this.iConverters;
        int length = converters.length;
        if (index >= length) {
            throw new IndexOutOfBoundsException();
        }
        if (removed != null) {
            removed[0] = converters[index];
        }
        Converter[] copy = new Converter[length - 1];
        int j = 0;
        int i = 0;
        while (i < length) {
            if (i != index) {
                copy[j++] = converters[i];
            }
            ++i;
        }
        return new ConverterSet(copy);
    }

    private static Converter selectSlow(ConverterSet set, Class type) {
        Converter converter;
        int length;
        Converter[] converters = set.iConverters;
        int i = length = converters.length;
        while (--i >= 0) {
            converter = converters[i];
            Class supportedType = converter.getSupportedType();
            if (supportedType == type) {
                return converter;
            }
            if (supportedType != null && (type == null || supportedType.isAssignableFrom(type))) continue;
            set = set.remove(i, null);
            converters = set.iConverters;
            length = converters.length;
        }
        if (type == null || length == 0) {
            return null;
        }
        if (length == 1) {
            return converters[0];
        }
        int i2 = length;
        while (--i2 >= 0) {
            converter = converters[i2];
            Class supportedType = converter.getSupportedType();
            int j = length;
            while (--j >= 0) {
                if (j == i2 || !converters[j].getSupportedType().isAssignableFrom(supportedType)) continue;
                set = set.remove(j, null);
                converters = set.iConverters;
                length = converters.length;
                i2 = length - 1;
            }
        }
        if (length == 1) {
            return converters[0];
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Unable to find best converter for type \"");
        msg.append(type.getName());
        msg.append("\" from remaining set: ");
        int i3 = 0;
        while (i3 < length) {
            converter = converters[i3];
            Class supportedType = converter.getSupportedType();
            msg.append(converter.getClass().getName());
            msg.append('[');
            msg.append(supportedType == null ? null : supportedType.getName());
            msg.append("], ");
            ++i3;
        }
        throw new IllegalStateException(msg.toString());
    }

    static class Entry {
        final Class iType;
        final Converter iConverter;

        Entry(Class type, Converter converter) {
            this.iType = type;
            this.iConverter = converter;
        }
    }
}

