/*
 * Decompiled with CFR 0.152.
 */
package didefom.common;

import didefom.common.Symbol;
import didefom.common.Terminal;
import java.util.ArrayList;
import java.util.Iterator;

public class TermNontermString {
    private ArrayList<Symbol> terminalNonterminalString = new ArrayList();

    public void add(Symbol _symbol) {
        this.terminalNonterminalString.add(_symbol);
    }

    public ArrayList<Symbol> getSymbols() {
        return this.terminalNonterminalString;
    }

    public boolean isEmpty() {
        for (Symbol symb : this.terminalNonterminalString) {
            if (symb.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.terminalNonterminalString.clear();
    }

    public ArrayList<Terminal> getFirstSet() {
        ArrayList<Terminal> firstSet = new ArrayList<Terminal>();
        boolean nonEmptySymbolFound = false;
        Iterator<Symbol> i = this.terminalNonterminalString.iterator();
        while (i.hasNext() && !nonEmptySymbolFound) {
            Symbol symb = i.next();
            firstSet.addAll(symb.getFirstSet());
            if (symb.isEmpty()) continue;
            nonEmptySymbolFound = true;
        }
        return firstSet;
    }

    public int getEffectiveLength() {
        int i = 0;
        for (Symbol s : this.getSymbols()) {
            if (s.isEpsilon()) continue;
            ++i;
        }
        return i++;
    }

    public boolean isEqual(TermNontermString nts) {
        int ntsl;
        int thisl = this.getEffectiveLength();
        if (thisl != (ntsl = nts.getEffectiveLength())) {
            return false;
        }
        return this.toString().equals(nts.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Symbol s : this.getSymbols()) {
            if (s.isEpsilon()) continue;
            sb.append(s.getSymbol());
        }
        return sb.toString();
    }

    public TermNontermString reduceEpsilon() {
        TermNontermString ret = new TermNontermString();
        boolean generateEpsilon = !this.getSymbols().isEmpty();
        for (Symbol s : this.getSymbols()) {
            if (s.isEpsilon()) continue;
            generateEpsilon = false;
            ret.add(s);
        }
        if (generateEpsilon) {
            ret.add(this.getSymbols().get(0));
        }
        return ret;
    }
}

