/*
 * Decompiled with CFR 0.152.
 */
package didefom.common.gui;

import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class GUIHelper {
    public static void SetSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static void BuildLanguageSubmenus(JMenu parentMenu, String[] lang_country_array, String[] langNames_array, ActionListener actionListener) {
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < lang_country_array.length; ++i) {
            String[] parts = lang_country_array[i].split("_");
            Locale ltest = new Locale(parts[0], parts[1]);
            JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(langNames_array[i]);
            jmi.setSelected(Locale.getDefault().equals(ltest));
            jmi.setToolTipText(ltest.toString());
            group.add(jmi);
            jmi.addActionListener(actionListener);
            parentMenu.add(jmi);
        }
        ArrayList supportedLocales = new ArrayList();
        Locale[] possibleLocales = Locale.getAvailableLocales();
        for (int i = 0; i < possibleLocales.length; ++i) {
            String s = possibleLocales[i].toString();
            s = s + " ";
        }
    }

    public static void OpenExternalBrowser(String location) {
        String cmd = null;
        Runtime rtm = Runtime.getRuntime();
        boolean win = System.getProperty("os.name").toLowerCase().startsWith("win");
        cmd = win ? "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE " + location : "firefox " + location;
        try {
            rtm.exec(cmd);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static void OpenExternalBrowser(URL url) {
        GUIHelper.OpenExternalBrowser(url.toString());
    }

    public static void OpenExternalBrowser(File file) {
        String absPath = "";
        try {
            absPath = file.toURI().toURL().toString();
            GUIHelper.OpenExternalBrowser(absPath);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public static void SetLocaleByString(String lang_country) {
        String[] parts = lang_country.split("_");
        Locale loc = new Locale(parts[0], parts[1]);
        Locale.setDefault(loc);
    }
}

