/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.AlgorithmState;
import didefom.DKASimulation.Automat;
import didefom.DKASimulation.Rule;
import didefom.DKASimulation.State;
import didefom.DKASimulation.VisualAutomat;
import didefom.DKASimulation.VisualRule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Determinization
extends AlgorithmState {
    private String addedRulesDescription = "";
    private Set<Set<State>> Q_new = new HashSet<Set<State>>();
    private Set<Set<State>> Q_d = new HashSet<Set<State>>();
    private Set<Set<State>> F_d = new HashSet<Set<State>>();
    private Set<State> s_d = new HashSet<State>();
    private Map<Set<State>, State> map = new HashMap<Set<State>, State>();
    private char actualTerminal;
    private SortedSet<Character> char_set = new TreeSet<Character>();
    private Iterator<Character> char_setIterator = null;
    private Set<State> Q_ = new HashSet<State>();
    private State Q_state = null;
    private Set<State> Q__ = new HashSet<State>();
    private State Q__state = null;

    public Determinization(VisualAutomat a) {
        super(a);
        this.setPhase(new DeterminizationPhase());
        this.initPhase();
    }

    private void initPhase() {
        ((DeterminizationPhase)this.getPhase()).setAlgorithm(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.setPhase(new DeterminizationPhase(this));
        this.initDeterminization();
    }

    @Override
    public void step() {
        if (!this.isFinished()) {
            this.getPhase().next();
        }
    }

    @Override
    public boolean isFinished() {
        return this.getPhase().inFinalState();
    }

    public static String SetOfGroupedStatesToString(Set<Set<State>> setOfGroupedStates, String name) {
        StringBuilder ret = new StringBuilder();
        if (name != null && !name.isEmpty()) {
            ret.append(name + " = ");
        }
        ret.append("{");
        for (Set<State> groupedState : setOfGroupedStates) {
            ret.append(Determinization.GroupedStateToString(groupedState, null));
            ret.append(", ");
        }
        if (!setOfGroupedStates.isEmpty()) {
            ret.deleteCharAt(ret.length() - 1);
            ret.deleteCharAt(ret.length() - 1);
        }
        ret.append("}");
        return ret.toString();
    }

    public static String GroupedStateToString(Set<State> groupedState, String name) {
        StringBuilder ret = new StringBuilder();
        if (name != null && !name.isEmpty()) {
            ret.append(name + "=");
        }
        ret.append("<");
        for (State state : groupedState) {
            ret.append(state.GetText() + ",");
        }
        if (!groupedState.isEmpty()) {
            ret.deleteCharAt(ret.length() - 1);
        }
        ret.append(">");
        return ret.toString();
    }

    public String GetAllStatesInfo() {
        StringBuilder ret = new StringBuilder();
        ret.append(Determinization.SetOfGroupedStatesToString(this.Q_new, "Q_new")).append("\n");
        if (((DeterminizationPhase)this.getPhase()).inInitState()) {
            ret.append(Determinization.GroupedStateToString(this.s_d, "s_d")).append("\n");
        }
        if (!this.addedRulesDescription.isEmpty()) {
            ret.append(this.addedRulesDescription).append("\n");
            this.addedRulesDescription = "";
        }
        ret.append(Determinization.SetOfGroupedStatesToString(this.Q_d, "Q_d")).append("\n").append(Determinization.GroupedStateToString(this.Q_, "Q'")).append("\n");
        ret.append(ResourceBundle.getBundle("didefom/DKASimulation/Determinization").getString("ProcessedTerminal")).append(this.actualTerminal == '\u0000' ? "" : "" + this.actualTerminal).append("\n");
        ret.append(Determinization.GroupedStateToString(this.Q__, "Q''"));
        return ret.toString();
    }

    public String GetPhaseDescription() {
        return ResourceBundle.getBundle("didefom/DKASimulation/Determinization").getString("Phase_" + this.getPhase().toString());
    }

    public void initDeterminization() {
        this.s_d.clear();
        this.Q_new.clear();
        this.Q_d.clear();
        this.F_d.clear();
        this.map.clear();
        this.char_set.clear();
        this.char_setIterator = null;
        this.Q_.clear();
        this.Q__.clear();
        this.Q_state = null;
        this.Q__state = null;
        this.getPhase().init();
        for (State s : this.getOrigA().GetStates()) {
            if (!s.IsFirst()) continue;
            this.s_d.add(s);
        }
        this.Q_new.add(this.s_d);
    }

    private boolean chooseNextTerminal() {
        if (this.char_setIterator.hasNext()) {
            this.actualTerminal = this.char_setIterator.next().charValue();
            return true;
        }
        return false;
    }

    private void resetTerminalChooser() {
        this.char_set = new TreeSet<Character>();
        for (State q_ : this.Q_) {
            HashSet<Rule> ms = new HashSet<Rule>();
            this.getAutomaton().GetNextRules(q_, ms);
            for (Rule m : ms) {
                if (m.IsEpsilon()) continue;
                SortedSet<Character> pchar_set = m.GetSet();
                this.char_set.addAll(pchar_set);
            }
        }
        this.char_setIterator = this.char_set.iterator();
    }

    public void SelectQ_FromQnew() {
        Iterator<Set<State>> iter = this.Q_new.iterator();
        this.Q_ = iter.next();
        iter.remove();
        this.Q_d.add(this.Q_);
        if (!this.map.containsKey(this.Q_)) {
            this.Q_state = this.getAutomaton().CreateGroupState(this.Q_);
            if (this.Q_state != null) {
                this.map.put(this.Q_, this.Q_state);
                this.getResultingA().GetStates().add(this.Q_state);
                if (((Object)this.Q_).equals(this.s_d)) {
                    this.Q_state.SetFirst(true);
                }
            }
        } else {
            this.Q_state = this.map.get(this.Q_);
        }
    }

    public void ComputeQ__() {
        this.Q__ = new HashSet<State>();
        for (State q_ : this.Q_) {
            HashSet<Rule> ms = new HashSet<Rule>();
            this.getAutomaton().GetNextRules(q_, ms);
            for (Rule m : ms) {
                if (m.IsEpsilon() || !m.IsChar(this.actualTerminal)) continue;
                this.Q__.add(m.GetDest());
            }
        }
    }

    public void GenerateNewRd() {
        if (!this.Q__.isEmpty()) {
            this.Q__state = null;
            if (!this.map.containsKey(this.Q__)) {
                this.Q__state = this.getAutomaton().CreateGroupState(this.Q__);
                if (this.Q__state != null) {
                    this.map.put(this.Q__, this.Q__state);
                    this.getResultingA().GetStates().add(this.Q__state);
                }
            } else {
                this.Q__state = this.map.get(this.Q__);
            }
            if (this.Q__state != null) {
                TreeSet<Character> char_set2 = new TreeSet<Character>();
                char_set2.add(Character.valueOf(this.actualTerminal));
                this.getResultingA().AddRule(this.getResultingA().GetRules(), this.Q_state, this.Q__state, char_set2);
                VisualRule r = (VisualRule)this.getResultingA().GetRules().get(this.getResultingA().GetRules().size() - 1);
                this.addedRulesDescription = this.addedRulesDescription + "" + r.GetSrc().GetText() + "." + r.GetString() + "->" + r.GetDest().GetText() + ", ";
            }
        }
    }

    public void AddToFinalStates() {
        for (State s : this.Q_) {
            if (!s.IsFinal()) continue;
            this.Q_state.SetFinal(true);
            break;
        }
    }

    private void ProcessingOfQ__() {
        if (this.Q__state != null && !this.Q__.isEmpty() && !this.Q_d.contains(this.Q__)) {
            this.Q_new.add(this.Q__);
        }
    }

    public class DeterminizationPhase
    extends AlgorithmState.AlgorithmPhase {
        private AlgStateEnum state = AlgStateEnum.init;
        private Determinization algorithm;
        private Automat refA;

        @Override
        public void init() {
            this.state = AlgStateEnum.init;
        }

        private DeterminizationPhase() {
            this.init();
        }

        public DeterminizationPhase(Determinization alg) {
            this.state = AlgStateEnum.init;
            this.algorithm = alg;
        }

        public DeterminizationPhase(AlgStateEnum state) {
            this.state = state;
        }

        public DeterminizationPhase(AlgStateEnum st, Determinization alg) {
            this.state = st;
            this.algorithm = alg;
        }

        public void setAlgorithm(Determinization alg) {
            this.algorithm = alg;
        }

        @Override
        public boolean inFinalState() {
            return this.state == AlgStateEnum.finished;
        }

        public boolean inInitState() {
            return this.state == AlgStateEnum.init;
        }

        public AlgStateEnum evaluateNext(boolean toDoActions) {
            switch (this.state) {
                case init: {
                    if (toDoActions && this.algorithm != null) {
                        this.algorithm.initDeterminization();
                    }
                    return AlgStateEnum.select;
                }
                case select: {
                    if (toDoActions && this.algorithm != null) {
                        this.algorithm.SelectQ_FromQnew();
                    }
                    this.resetTerminalChooser();
                    return AlgStateEnum.compute;
                }
                case compute: {
                    if (toDoActions && this.algorithm != null) {
                        if (this.chooseNextTerminal()) {
                            this.algorithm.ComputeQ__();
                            return AlgStateEnum.generate;
                        }
                        return AlgStateEnum.finalStates;
                    }
                    Iterator old = Determinization.this.char_setIterator;
                    AlgStateEnum ret = this.chooseNextTerminal() ? AlgStateEnum.generate : AlgStateEnum.finalStates;
                    Determinization.this.char_setIterator = old;
                    return ret;
                }
                case generate: {
                    if (toDoActions && this.algorithm != null) {
                        this.algorithm.GenerateNewRd();
                    }
                    return AlgStateEnum.processing;
                }
                case processing: {
                    if (toDoActions && this.algorithm != null) {
                        this.algorithm.ProcessingOfQ__();
                    }
                    return AlgStateEnum.compute;
                }
                case finalStates: {
                    if (toDoActions && this.algorithm != null) {
                        this.algorithm.AddToFinalStates();
                    }
                    if (!Determinization.this.Q_new.isEmpty()) {
                        return AlgStateEnum.select;
                    }
                    return AlgStateEnum.finished;
                }
                case finished: {
                    if (!toDoActions || this.algorithm != null) {
                        // empty if block
                    }
                    return AlgStateEnum.finished;
                }
            }
            if (!toDoActions || this.algorithm != null) {
                // empty if block
            }
            this.state = AlgStateEnum.init;
            return this.state;
        }

        @Override
        public AlgorithmState.AlgorithmPhase getNext() {
            AlgStateEnum newstate = this.evaluateNext(false);
            return new DeterminizationPhase(newstate, this.algorithm);
        }

        public boolean equals(DeterminizationPhase dp) {
            return (AlgStateEnum)((Object)dp.getParameter("state")) == this.state;
        }

        @Override
        public AlgorithmState.AlgorithmPhase next() {
            this.state = this.evaluateNext(true);
            return this;
        }

        @Override
        public void setParameter(String key, Object value) {
            if (key.equals("state")) {
                this.state = (AlgStateEnum)((Object)value);
            }
        }

        @Override
        public Object getParameter(String key) {
            if (key.equals("state")) {
                return this.state;
            }
            return null;
        }

        public String toString() {
            return this.state.toString();
        }

        private boolean chooseNextTerminal() {
            return this.algorithm.chooseNextTerminal();
        }

        private void resetTerminalChooser() {
            this.algorithm.resetTerminalChooser();
        }
    }

    public static enum AlgStateEnum {
        init,
        select,
        compute,
        generate,
        processing,
        finalStates,
        finished;

    }
}

