/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.Rule;
import didefom.DKASimulation.State;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class Automat {
    protected List<State> m_states;
    protected List<Rule> m_rules;
    protected StringBuffer m_string = new StringBuffer();

    public Automat() {
        this.m_states = new LinkedList<State>();
        this.m_rules = new LinkedList<Rule>();
    }

    public void SetString(String str) {
        this.m_string = new StringBuffer(str);
    }

    public String GetString() {
        return this.m_string.toString();
    }

    public void AddState(State state) {
        this.m_states.add(state);
    }

    public void AddRule(Rule rule) {
        this.m_rules.add(rule);
    }

    public void DeleteState(State state) {
        this.m_states.remove(state);
        LinkedList<Rule> del = new LinkedList<Rule>();
        for (Rule r : this.m_rules) {
            if (r.GetSrc() != state && r.GetDest() != state) continue;
            del.add(r);
        }
        for (Rule r : del) {
            this.DeleteRule(r);
        }
    }

    public void DeleteRule(Rule rule) {
        this.m_rules.remove(rule);
    }

    public void Step() {
        HashSet<Rule> rules = new HashSet<Rule>();
        HashSet<State> list = new HashSet<State>();
        HashSet<State> active = new HashSet<State>();
        this.ClearRulesActivity();
        this.GetActiveStates(list);
        int c = this.GetNextChar();
        if (c == -1) {
            return;
        }
        for (State s : list) {
            s.SetActive(false);
            rules.clear();
            this.GetNextRules(s, rules);
            for (Rule r : rules) {
                if (!r.IsChar((char)c) || r.IsEpsilon()) continue;
                r.SetActive(true);
                active.add(r.GetDest());
            }
        }
        this.ActivateEpsilonStates(active);
    }

    protected int GetNextChar() {
        int ret = -1;
        if (this.m_string.length() > 0) {
            ret = this.m_string.charAt(0);
            this.m_string.deleteCharAt(0);
        }
        return ret;
    }

    public void Reset() {
        HashSet<State> list = new HashSet<State>();
        this.ClearRulesActivity();
        for (State s : this.m_states) {
            if (s.IsFirst()) {
                s.SetActive(true);
                list.add(s);
                continue;
            }
            s.SetActive(false);
        }
        this.ActivateEpsilonStates(list);
    }

    public boolean IsDone() {
        return this.m_string.length() == 0;
    }

    public boolean IsAtFinalState() {
        for (State s : this.m_states) {
            if (!s.IsFinal() || !s.IsActive()) continue;
            return true;
        }
        return false;
    }

    public boolean IsActive() {
        for (State s : this.m_states) {
            if (!s.IsActive()) continue;
            return true;
        }
        return false;
    }

    protected void ActivateEpsilonStates(Set<State> begin_states) {
        HashSet<State> active = new HashSet<State>();
        HashSet<State> done = new HashSet<State>();
        HashSet<Rule> list = new HashSet<Rule>();
        active.addAll(begin_states);
        while (!active.isEmpty()) {
            Iterator iter = active.iterator();
            State p = (State)iter.next();
            iter.remove();
            done.add(p);
            p.SetActive(true);
            list.clear();
            this.GetNextRules(p, list);
            for (Rule m : list) {
                if (!m.IsEpsilon()) continue;
                if (!done.contains(m.GetDest())) {
                    active.add(m.GetDest());
                }
                m.SetActive(true);
            }
        }
    }

    protected void GetActiveStates(Set<State> list) {
        for (State s : this.m_states) {
            if (!s.IsActive()) continue;
            list.add(s);
        }
    }

    protected void GetActiveRules(Set<Rule> list) {
        for (Rule r : this.m_rules) {
            if (!r.IsActive()) continue;
            list.add(r);
        }
    }

    protected void GetNextRules(State s, Set<Rule> list) {
        for (Rule m : this.m_rules) {
            if (m.GetSrc() != s) continue;
            list.add(m);
        }
    }

    protected void GetNextStates(State s, Set<State> list) {
        for (Rule m : this.m_rules) {
            if (m.GetSrc() != s) continue;
            list.add(m.GetDest());
        }
    }

    protected void ClearRulesActivity() {
        for (Rule m : this.m_rules) {
            m.SetActive(false);
        }
    }

    protected void ClearStatesActivity() {
        for (State s : this.m_states) {
            s.SetActive(false);
        }
    }

    protected void GetEpsilonClosure(State s, Set<State> set) {
        HashSet<State> active = new HashSet<State>();
        HashSet<Rule> list = new HashSet<Rule>();
        active.add(s);
        while (!active.isEmpty()) {
            Iterator iter = active.iterator();
            State p = (State)iter.next();
            iter.remove();
            set.add(p);
            list.clear();
            this.GetNextRules(p, list);
            for (Rule m : list) {
                if (!m.IsEpsilon() || set.contains(m.GetDest())) continue;
                active.add(m.GetDest());
            }
        }
    }

    protected void AddRule(List<Rule> rules, State src, State dest, SortedSet<Character> c) {
        for (Rule r : rules) {
            if (r.GetSrc() != src || r.GetDest() != dest || r.IsEpsilon()) continue;
            Iterator i$ = c.iterator();
            while (i$.hasNext()) {
                char ch = ((Character)i$.next()).charValue();
                r.SetChar(ch);
            }
            return;
        }
        rules.add(this.CreateRule(src, dest, c));
    }

    public void ConvertToEpsilonFree() {
        LinkedList<Rule> rules = new LinkedList<Rule>();
        for (State p : this.m_states) {
            HashSet<State> e_closure = new HashSet<State>();
            this.GetEpsilonClosure(p, e_closure);
            for (Rule m : this.m_rules) {
                if (m.IsEpsilon() || !e_closure.contains(m.GetSrc())) continue;
                SortedSet<Character> char_set = m.GetSet();
                this.AddRule(rules, p, m.GetDest(), char_set);
            }
            boolean fin = false;
            for (State pp : e_closure) {
                if (!pp.IsFinal()) continue;
                fin = true;
                break;
            }
            p.SetFinal(fin);
        }
        this.m_rules.clear();
        for (Rule i : rules) {
            this.AddRule(i);
        }
    }

    protected Rule GetRule(State src, State dest, char c) {
        for (Rule m : this.m_rules) {
            if (m.IsEpsilon() || m.GetSrc() != src || m.GetDest() != dest || !m.IsChar(c)) continue;
            return m;
        }
        return null;
    }

    public void ConvertEpsilonFreeToDFA() {
        LinkedList<Rule> rules = new LinkedList<Rule>();
        LinkedList<State> states = new LinkedList<State>();
        HashSet Q_new = new HashSet();
        HashSet<Set> Q_d = new HashSet<Set>();
        HashSet F_d = new HashSet();
        HashSet<State> s_d = new HashSet<State>();
        HashMap<Set, State> map = new HashMap<Set, State>();
        for (State s : this.m_states) {
            if (!s.IsFirst()) continue;
            s_d.add(s);
        }
        Q_new.add(s_d);
        while (!Q_new.isEmpty()) {
            Iterator iter = Q_new.iterator();
            Set Q_ = (Set)iter.next();
            iter.remove();
            Q_d.add(Q_);
            State Q_state = null;
            if (!map.containsKey(Q_)) {
                Q_state = this.CreateGroupState(Q_);
                if (Q_state != null) {
                    map.put(Q_, Q_state);
                    states.add(Q_state);
                    if (((Object)Q_).equals(s_d)) {
                        Q_state.SetFirst(true);
                    }
                }
            } else {
                Q_state = (State)map.get(Q_);
            }
            for (State s : Q_) {
                if (!s.IsFinal()) continue;
                Q_state.SetFinal(true);
                break;
            }
            TreeSet<Character> char_set = new TreeSet<Character>();
            for (State q_ : Q_) {
                HashSet<Rule> ms = new HashSet<Rule>();
                this.GetNextRules(q_, ms);
                for (Rule m : ms) {
                    if (m.IsEpsilon()) continue;
                    SortedSet<Character> pchar_set = m.GetSet();
                    char_set.addAll(pchar_set);
                }
            }
            Iterator i$ = char_set.iterator();
            while (i$.hasNext()) {
                char c = ((Character)i$.next()).charValue();
                HashSet<State> Q__ = new HashSet<State>();
                for (State q_ : Q_) {
                    HashSet<Rule> ms = new HashSet<Rule>();
                    this.GetNextRules(q_, ms);
                    for (Rule m : ms) {
                        if (m.IsEpsilon() || !m.IsChar(c)) continue;
                        Q__.add(m.GetDest());
                    }
                }
                if (Q__.isEmpty()) continue;
                State Q__state = null;
                if (!map.containsKey(Q__)) {
                    Q__state = this.CreateGroupState(Q__);
                    if (Q__state != null) {
                        map.put(Q__, Q__state);
                        states.add(Q__state);
                    }
                } else {
                    Q__state = (State)map.get(Q__);
                }
                if (Q__state == null) continue;
                TreeSet<Character> char_set2 = new TreeSet<Character>();
                char_set2.add(Character.valueOf(c));
                this.AddRule(rules, Q_state, Q__state, char_set2);
                if (Q_d.contains(Q__)) continue;
                Q_new.add(Q__);
            }
        }
        this.Clear();
        for (State s : states) {
            this.AddState(s);
        }
        for (Rule r : rules) {
            this.AddRule(r);
        }
    }

    public void Clear() {
        this.m_states.clear();
        this.m_rules.clear();
    }

    public boolean CheckDFA(Set<State> bad_states, Set<Rule> bad_rules) {
        boolean ret = true;
        HashSet<State> states = new HashSet<State>();
        HashSet<State> states_done = new HashSet<State>();
        for (State s : this.m_states) {
            if (!s.IsFirst()) continue;
            states.add(s);
        }
        if (states.size() != 1) {
            ret = false;
            bad_states.addAll(states);
        }
        while (!states.isEmpty()) {
            State s;
            Iterator iter = states.iterator();
            s = (State)iter.next();
            iter.remove();
            states_done.add(s);
            HashSet<Rule> rules = new HashSet<Rule>();
            this.GetNextRules(s, rules);
            TreeMap<Character, Rule> chars = new TreeMap<Character, Rule>();
            for (Rule m : rules) {
                if (m.IsEpsilon()) {
                    bad_rules.add(m);
                    ret = false;
                } else {
                    SortedSet<Character> char_set = m.GetSet();
                    Iterator i$ = char_set.iterator();
                    while (i$.hasNext()) {
                        char c = ((Character)i$.next()).charValue();
                        if (chars.containsKey(Character.valueOf(c))) {
                            bad_rules.add(m);
                            bad_rules.add((Rule)chars.get(Character.valueOf(c)));
                            ret = false;
                            continue;
                        }
                        chars.put(Character.valueOf(c), m);
                    }
                }
                if (states_done.contains(m.GetDest())) continue;
                states.add(m.GetDest());
            }
        }
        for (State s : this.m_states) {
            if (states_done.contains(s)) continue;
            bad_states.add(s);
            ret = false;
        }
        return ret;
    }

    public Rule IsThere(char c) {
        for (Rule r : this.m_rules) {
            if (!r.IsChar(c)) continue;
            return r;
        }
        return null;
    }

    public List<State> GetStates() {
        return this.m_states;
    }

    public List<Rule> GetRules() {
        return this.m_rules;
    }

    protected abstract Rule CreateRule(State var1, State var2, SortedSet<Character> var3);

    protected abstract State CreateGroupState(Set var1);
}

