/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.Automat;
import didefom.DKASimulation.Rule;
import didefom.DKASimulation.State;
import didefom.DKASimulation.VisualRule;
import didefom.DKASimulation.VisualState;
import didefom.common.Epsilon;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualAutomat
extends Automat {
    private Font m_fontStates;
    private Font m_fontRules;
    private int m_lineWidth;

    public VisualAutomat() {
    }

    public VisualAutomat(VisualAutomat another) {
        this.setFontRules(another.getFontRules());
        this.setFontStates(another.getFontStates());
        this.m_lineWidth = another.m_lineWidth;
    }

    public void Draw(Graphics2D g) {
        for (Object s : this.m_states) {
            ((VisualState)s).Draw(g);
        }
        for (Object s : this.m_rules) {
            ((VisualRule)s).Draw(g);
        }
    }

    public VisualState GetStateAt(Point pt) {
        for (VisualState s : this.m_states) {
            if (!s.IsHit(pt)) continue;
            return s;
        }
        return null;
    }

    private String unmarshallText(Node textNode) {
        StringBuffer buf = new StringBuffer();
        NodeList nodes = textNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            buf.append(n.getNodeValue());
        }
        return buf.toString();
    }

    public boolean Load(String filename) {
        try {
            Element n;
            int i;
            this.Clear();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new File(filename));
            NodeList list = doc.getElementsByTagName("state");
            HashMap<String, VisualState> map = new HashMap<String, VisualState>();
            for (i = 0; i < list.getLength(); ++i) {
                n = (Element)list.item(i);
                String name = n.getAttribute("cislo");
                VisualState state = new VisualState();
                state.setFont(this.getFontStates());
                state.setLineWidth(this.m_lineWidth);
                map.put(name, state);
                int x = Integer.parseInt(n.getAttribute("x"));
                int y = Integer.parseInt(n.getAttribute("y"));
                int first = Integer.parseInt(n.getAttribute("first"));
                int fin = Integer.parseInt(n.getAttribute("final"));
                int active = Integer.parseInt(n.getAttribute("active"));
                state.SetPos(new Point(x, y));
                state.SetFirst(first != 0);
                state.SetFinal(fin != 0);
                state.SetActive(active != 0);
                state.SetText(this.unmarshallText(n));
                this.m_states.add(state);
            }
            list = doc.getElementsByTagName("rule");
            for (i = 0; i < list.getLength(); ++i) {
                boolean epsilon;
                n = (Element)list.item(i);
                String begin = n.getAttribute("begin");
                String end = n.getAttribute("end");
                VisualState s_begin = (VisualState)map.get(begin);
                VisualState s_end = (VisualState)map.get(end);
                int active = Integer.parseInt(n.getAttribute("active"));
                int x = Integer.parseInt(n.getAttribute("pos_x"));
                int y = Integer.parseInt(n.getAttribute("pos_y"));
                String ch = n.getAttribute("char");
                if (ch.equals(Epsilon.ascii()) || ch.equals(Epsilon.unicode())) {
                    epsilon = true;
                    ch = "";
                } else {
                    epsilon = false;
                }
                VisualRule r = new VisualRule();
                r.setFont(this.m_fontRules);
                r.setLineWidth(this.m_lineWidth);
                r.SetSrc(s_begin);
                r.SetDest(s_end);
                r.SetString(ch);
                r.SetEpsilon(epsilon);
                r.SetTextOffset(new Point(x, y));
                r.SetActive(active != 0);
                ArrayList<Point> pts = new ArrayList<Point>();
                NodeList nl_pts = n.getChildNodes();
                for (int j = 0; j < nl_pts.getLength(); ++j) {
                    Element e_pt;
                    Node n_pt = nl_pts.item(j);
                    if (n_pt.getNodeType() != 1 || !(e_pt = (Element)n_pt).getTagName().equals("point")) continue;
                    int p_x = Integer.parseInt(e_pt.getAttribute("x"));
                    int p_y = Integer.parseInt(e_pt.getAttribute("y"));
                    pts.add(new Point(p_x, p_y));
                }
                r.SetPoints(pts);
                this.m_rules.add(r);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean Save(String filename) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            DOMImplementation di = db.getDOMImplementation();
            Document doc = di.createDocument(null, null, null);
            Element automat = doc.createElement("automat");
            doc.appendChild(automat);
            int counter = 1;
            HashMap<VisualState, String> map = new HashMap<VisualState, String>();
            for (State s : this.m_states) {
                VisualState vs = (VisualState)s;
                String name = "s" + Integer.toString(counter);
                map.put(vs, name);
                Element es = doc.createElement("state");
                es.setAttribute("cislo", name);
                es.setAttribute("x", Integer.toString(vs.GetPos().x));
                es.setAttribute("y", Integer.toString(vs.GetPos().y));
                es.setAttribute("first", vs.IsFirst() ? "1" : "0");
                es.setAttribute("final", vs.IsFinal() ? "1" : "0");
                es.setAttribute("active", vs.IsActive() ? "1" : "0");
                es.appendChild(doc.createTextNode(vs.GetText()));
                automat.appendChild(es);
                ++counter;
            }
            for (Rule r : this.m_rules) {
                VisualRule vr = (VisualRule)r;
                String begin = (String)map.get(vr.GetSrc());
                String end = (String)map.get(vr.GetDest());
                Element er = doc.createElement("rule");
                er.setAttribute("begin", begin);
                er.setAttribute("end", end);
                er.setAttribute("active", vr.IsActive() ? "1" : "0");
                er.setAttribute("pos_x", Integer.toString(vr.GetTextOffset().x));
                er.setAttribute("pos_y", Integer.toString(vr.GetTextOffset().y));
                String ch = vr.IsEpsilon() ? Epsilon.ascii() : vr.GetString();
                er.setAttribute("char", ch);
                for (Point pt : vr.GetPoints()) {
                    Element ep = doc.createElement("point");
                    ep.setAttribute("x", Integer.toString(pt.x));
                    ep.setAttribute("y", Integer.toString(pt.y));
                    er.appendChild(ep);
                }
                automat.appendChild(er);
            }
            Element estring = doc.createElement("string");
            estring.appendChild(doc.createTextNode(this.GetString()));
            automat.appendChild(estring);
            DOMSource ds = new DOMSource(doc);
            StreamResult sr = new StreamResult(new File(filename));
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(ds, sr);
        }
        catch (Exception x) {
            return false;
        }
        return true;
    }

    @Override
    protected Rule CreateRule(State src, State dest, SortedSet<Character> c) {
        LinkedList<Point> pts = new LinkedList<Point>();
        if (src == dest) {
            pts.add(((VisualState)src).GetPos());
            pts.add(((VisualState)src).GetPos());
        }
        return this.CreateRule(src, dest, c, pts);
    }

    protected Rule CreateRule(State src, State dest, SortedSet<Character> c, List<Point> pts) {
        if (src == null || dest == null) {
            return null;
        }
        VisualRule m = new VisualRule(src, dest, c, pts);
        m.setFont(this.m_fontRules);
        m.setLineWidth(this.m_lineWidth);
        Point name_pos = ((VisualState)src).GetPos();
        Point start = ((VisualState)src).GetNearestSurfacePoint(((VisualState)dest).GetPos());
        Point posun = new Point(start.x - name_pos.x, start.y - name_pos.y);
        m.SetTextOffset(posun);
        return m;
    }

    @Override
    protected State CreateGroupState(Set states) {
        if (states.isEmpty()) {
            return null;
        }
        String text = "";
        Point pt = new Point();
        for (VisualState s : states) {
            Point pos = s.GetPos();
            pt.setLocation(pt.x + pos.x, pt.y + pos.y);
            text = text + s.GetText();
        }
        pt.setLocation(pt.x / states.size(), pt.y / states.size());
        VisualState ret = new VisualState();
        ret.SetPos(pt);
        ret.SetText(text);
        ret.setFont(this.getFontStates());
        ret.setLineWidth(this.m_lineWidth);
        return ret;
    }

    public void AddState(Point pos, String text) {
        VisualState v = new VisualState();
        v.SetPos(pos);
        v.SetText(text);
        v.setFont(this.getFontStates());
        v.setLineWidth(this.m_lineWidth);
        super.AddState(v);
    }

    public void AddRule(State start, State dest, List<Point> pts) {
        int i;
        if (start == null || dest == null) {
            return;
        }
        for (i = 65; i <= 255 && this.IsThere((char)i) != null; ++i) {
        }
        TreeSet<Character> set = new TreeSet<Character>();
        set.add(Character.valueOf((char)i));
        Rule v = this.CreateRule(start, dest, set, pts);
        if (v != null) {
            super.AddRule(v);
        }
    }

    public void ClearSelection() {
        for (VisualState s : this.m_states) {
            s.SetSelect(false);
        }
        for (VisualRule r : this.m_rules) {
            r.SetTextSelect(false);
            for (int k = 0; k < r.GetPoints().size(); ++k) {
                r.SetPointSelect(k, false);
            }
        }
    }

    public Font getFontStates() {
        return this.m_fontStates;
    }

    public void setFontStates(Font m_fontStates) {
        this.m_fontStates = m_fontStates;
    }

    public Font getFontRules() {
        return this.m_fontRules;
    }

    public void setFontRules(Font m_fontRules) {
        this.m_fontRules = m_fontRules;
    }

    public void setLineWidth(int lineWidth) {
        this.m_lineWidth = lineWidth;
        for (State s : this.m_states) {
            ((VisualState)s).setLineWidth(lineWidth);
        }
        for (Rule r : this.m_rules) {
            ((VisualRule)r).setLineWidth(lineWidth);
        }
    }

    public int getLineWidth() {
        return this.m_lineWidth;
    }

    public VisualAutomat copy() {
        VisualAutomat a = new VisualAutomat();
        ListIterator<Object> i = this.m_states.listIterator();
        i = this.GetStates().listIterator();
        while (i.hasNext()) {
            a.AddState((State)i.next());
        }
        i = this.GetRules().listIterator();
        while (i.hasNext()) {
            a.AddRule((Rule)i.next());
        }
        a.SetString(this.GetString());
        a.setLineWidth(this.m_lineWidth);
        a.setFontRules(this.getFontRules());
        a.setFontStates(this.getFontStates());
        return a;
    }
}

