/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation.gui;

import didefom.DKASimulation.Determinization;
import didefom.DKASimulation.MainFrame;
import didefom.DKASimulation.View;
import didefom.DKASimulation.VisualAutomat;
import didefom.DKASimulation.gui.JAlgControlPanel;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class JDetAlgDialog
extends JDialog {
    private JButton btnShowOriginal;
    private JButton btnShowTransformed;
    private JAlgControlPanel jAlgControlPanel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea taDetails;
    private Font normalFont = new Font("Arial", 0, 12);
    private VisualAutomat origA;
    private VisualAutomat auxA;
    private VisualAutomat automaton;
    private View view;
    private Determinization determinization;
    private boolean algorithmRunning = false;
    private boolean m_snappingToMainWindow = false;

    public JDetAlgDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JDetAlgDialog(Frame parent, VisualAutomat a, View v) {
        super(parent, true);
        this.setAutomaton(a);
        this.setView(v);
        this.setDeterminization(new Determinization(a));
        this.initComponents();
        this.updateFonts(this.getNormalFont());
        this.taDetails.setEditable(false);
        this.taDetails.setBackground(Color.WHITE);
        this.initActions();
        this.BtnResetActionPerformed(null);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.taDetails = new JTextArea();
        this.jAlgControlPanel1 = new JAlgControlPanel();
        this.jPanel2 = new JPanel();
        this.btnShowOriginal = new JButton();
        this.btnShowTransformed = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("DialogTitle"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                JDetAlgDialog.this.formWindowClosed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("DetailsBorder")));
        this.taDetails.setColumns(20);
        this.taDetails.setFont(new Font("Arial", 0, 12));
        this.taDetails.setRows(5);
        this.jScrollPane1.setViewportView(this.taDetails);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 448, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE));
        this.btnShowOriginal.setText(ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("ShowOriginalButton"));
        this.btnShowOriginal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDetAlgDialog.this.btnShowOriginalActionPerformed(evt);
            }
        });
        this.btnShowTransformed.setText(ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("ShowTransformedButton"));
        this.btnShowTransformed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDetAlgDialog.this.btnShowTransformedActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnShowOriginal, GroupLayout.Alignment.TRAILING).addComponent(this.btnShowTransformed, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.btnShowOriginal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnShowTransformed).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jAlgControlPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAlgControlPanel1, -2, -1, -2).addComponent(this.jPanel2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        if (this.determinization.isFinished() && JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("CloseOptionMessage"), ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("CloseOptionTitle"), 0) == 0) {
            this.view.SetAutomat(this.determinization.getResultingA());
        } else {
            this.view.SetAutomat(this.determinization.getOrigA());
        }
        ((MainFrame)this.getParent()).SetAutomat(this.view.GetAutomat());
        ((MainFrame)this.getParent()).RefreshView();
    }

    private void btnShowTransformedActionPerformed(ActionEvent evt) {
        this.view.SetAutomat(this.determinization.getResultingA());
        ((MainFrame)this.getParent()).RefreshView();
    }

    private void btnShowOriginalActionPerformed(ActionEvent evt) {
        this.view.SetAutomat(this.determinization.getOrigA());
        ((MainFrame)this.getParent()).RefreshView();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JDetAlgDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public void setAutomaton(VisualAutomat m_automat) {
        this.origA = m_automat;
        this.automaton = m_automat;
    }

    public void setView(View m_view) {
        this.view = m_view;
    }

    public Determinization getDeterminization() {
        return this.determinization;
    }

    public void setDeterminization(Determinization determinization) {
        this.determinization = determinization;
    }

    private void initActions() {
        this.jAlgControlPanel1.getBtnReset().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDetAlgDialog.this.BtnResetActionPerformed(evt);
            }
        });
        this.jAlgControlPanel1.getBtnStep().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDetAlgDialog.this.BtnStepActionPerformed(evt);
            }
        });
        this.jAlgControlPanel1.getBtnFinish().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDetAlgDialog.this.BtnFinishActionPerformed(evt);
            }
        });
        this.jAlgControlPanel1.getBtnClose().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDetAlgDialog.this.BtnCloseActionPerformed(evt);
            }
        });
    }

    private void BtnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void BtnResetActionPerformed(ActionEvent evt) {
        this.determinization.reset();
        this.taDetails.setText("");
        this.setAlgorithmRunning(true);
        this.jAlgControlPanel1.getBtnStep().setEnabled(true);
    }

    private void BtnStepActionPerformed(ActionEvent evt) {
        if (!this.isAlgorithmRunning()) {
            this.jAlgControlPanel1.getBtnStep().setEnabled(false);
        }
        if (this.determinization.isFinished()) {
            this.BtnFinishActionPerformed(evt);
            return;
        }
        this.taDetails.append(ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("PhaseLabel") + this.determinization.GetPhaseDescription() + "\n");
        this.determinization.getPhase().next();
        this.taDetails.append(this.determinization.GetAllStatesInfo() + "\n");
        this.taDetails.append("------------------------------\n");
        this.taDetails.setCaretPosition(this.taDetails.getText().length());
        this.view.repaint();
    }

    private void BtnFinishActionPerformed(ActionEvent evt) {
        while (!this.determinization.isFinished()) {
            this.BtnStepActionPerformed(evt);
        }
        if (this.isAlgorithmRunning()) {
            this.view.SetAutomat(this.determinization.getResultingA());
            this.taDetails.append("\n" + ResourceBundle.getBundle("didefom/DKASimulation/gui/JDetAlgDialog").getString("AlgorithmFinishedLabel") + "\n");
            this.setAlgorithmRunning(false);
        }
    }

    public boolean isAlgorithmRunning() {
        return this.algorithmRunning;
    }

    public void setAlgorithmRunning(boolean algorithmRunning) {
        this.algorithmRunning = algorithmRunning;
    }

    public VisualAutomat getAutomaton() {
        return this.automaton;
    }

    public boolean snapToMainWindow() {
        return this.m_snappingToMainWindow;
    }

    public void setSnappingToMainWindow(boolean b) {
        this.m_snappingToMainWindow = b;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this.snapToMainWindow()) {
            Point pt = this.getParent().getLocation();
            this.setLocation(pt.x + this.getParent().getWidth(), pt.y);
        }
        super.setVisible(b);
    }

    public void updateFonts(Font font) {
        this.setNormalFont(font);
        this.btnShowOriginal.setFont(font);
        this.btnShowTransformed.setFont(font);
        this.taDetails.setFont(font);
        this.jAlgControlPanel1.getBtnReset().setFont(font);
        this.jAlgControlPanel1.getBtnStep().setFont(font);
        this.jAlgControlPanel1.getBtnClose().setFont(font);
        this.jAlgControlPanel1.getBtnFinish().setFont(font);
        this.pack();
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void setNormalFont(Font normalFont) {
        this.normalFont = normalFont;
    }
}

