/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.Help;
import didefom.DKASimulation.Rule;
import didefom.DKASimulation.RuleWindow;
import didefom.DKASimulation.State;
import didefom.DKASimulation.StateWindow;
import didefom.DKASimulation.StepVisualAutomata;
import didefom.DKASimulation.StringWindow;
import didefom.DKASimulation.View;
import didefom.DKASimulation.VisualAutomat;
import didefom.DKASimulation.VisualRule;
import didefom.DKASimulation.VisualState;
import didefom.DKASimulation.gui.DetailsAction;
import didefom.DKASimulation.gui.JDetAlgDialog;
import didefom.common.gui.FMFileFilter;
import didefom.common.gui.GUIHelper;
import didefom.common.gui.JAboutDialog;
import didefom.common.gui.JFontChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class MainFrame
extends JFrame
implements ActionListener {
    private JMenuBar menu;
    private JMenu menuFile;
    private JMenu menuAutomat;
    private JMenu menuSetting;
    private JMenu menuAbout;
    private JMenuItem menuFileExit;
    private JMenuItem menuFileSave;
    private JMenuItem menuFileLoad;
    private JMenuItem menuAboutAbout;
    private JMenuItem menuAboutHelp;
    private JMenu menuLanguages;
    private JMenuItem menuAutomatConvert;
    private JMenuItem menuAutomatString;
    private JMenuItem menuAutomatState;
    private JMenuItem menuAutomatRule;
    private JMenuItem menuAutomatStep;
    private JMenuItem menuAutomatStart;
    private JMenuItem menuAutomatStop;
    private JMenuItem menuAutomatReset;
    private JMenuItem menuAutomatCheck;
    private JMenuItem menuAutomatConvertToEpsilonFree;
    private JMenu menuFonts;
    private JMenuItem menuFontNormal;
    private JMenuItem menuFontAutomaton;
    private JMenuItem menuSettingLineWidth;
    private JMenuItem menuSettingTimer;
    private JCheckBoxMenuItem menuSettingDetails;
    private JCheckBoxMenuItem menuSettingSnap;
    private View m_view;
    private StateWindow m_state_window;
    private RuleWindow m_rule_window;
    private StringWindow m_string_window;
    private Help m_help_window;
    private VisualAutomat m_automat;
    private JScrollPane m_scroll;
    private boolean m_automat_running;
    private boolean m_algorithm_running;
    private Timer m_timer;
    private int m_lineWidth = 2;
    private boolean m_details = true;
    private DetailsAction detailsAction;
    private JToolBar toolBar;
    private JSpinner spinInterval;
    private JButton btnStart;
    private JButton btnReset;
    private JButton btnRetezec;
    private JButton btnStop;
    private JButton btnKrok;
    private JButton btnEpsilon;
    private JButton btnDFA;
    private JButton btnStav;
    private JButton btnPrechod;
    private JCheckBox chkDetails;
    private JTextField txtDetails;
    private Font fontNormal;
    private Font fontAutomata;
    private String initFileChooserFilePath = "";

    public void SetAutomat(VisualAutomat a) {
        this.m_automat = a;
    }

    public MainFrame() {
        this.setSize(600, 550);
        this.SetTitle(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ApplicationTitle"));
        this.SetDefaultCloseOperation();
        this.detailsAction = new DetailsAction(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("DetailsActionLabel"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("DetailsActionTooltip"), 68);
        this.BuildMenu();
        this.BuildToolBar();
        this.m_automat = new StepVisualAutomata();
        this.m_view = new View(this);
        this.m_view.SetAutomat(this.m_automat);
        this.m_view.setBackground(Color.WHITE);
        this.m_scroll = new JScrollPane(this.m_view);
        this.m_scroll.setBackground(Color.WHITE);
        this.getContentPane().add(this.m_scroll);
        this.m_state_window = new StateWindow(this);
        this.m_state_window.setVisible(false);
        this.m_rule_window = new RuleWindow(this);
        this.m_rule_window.setVisible(false);
        this.m_string_window = new StringWindow(this);
        this.m_string_window.setVisible(false);
        if (!this.isApplet()) {
            this.m_help_window = new Help(this);
            this.m_help_window.setVisible(false);
        }
        this.m_automat_running = false;
        this.m_algorithm_running = false;
        this.m_timer = new Timer(500, this);
        this.fontNormal = new Font("Arial", 0, 12);
        this.fontAutomata = new Font("Arial", 1, 16);
        this.m_automat.setFontStates(this.fontAutomata);
        this.m_automat.setFontRules(this.fontAutomata);
        this.m_automat.setLineWidth(this.m_lineWidth);
        this.BuildLanguageMenu();
        this.setVisible(true);
    }

    VisualAutomat GetAutomat() {
        return this.m_automat;
    }

    private void menuFontChoose(FontTypes type) {
        Font font = null;
        switch (type) {
            case Normal: {
                font = this.fontNormal;
                break;
            }
            case Automata: {
                font = this.fontAutomata;
                break;
            }
            default: {
                font = this.fontNormal;
            }
        }
        JFontChooser chooser = new JFontChooser(this.isApplet() ? null : (JFrame)JFrame.class.cast(this));
        int result = chooser.showDialog(font);
        if (result != JFontChooser.CANCEL_OPTION) {
            switch (type) {
                case Normal: {
                    this.fontNormal = chooser.getFont();
                    break;
                }
                case Automata: {
                    this.fontAutomata = chooser.getFont();
                    break;
                }
            }
            this.FontChanged();
        }
    }

    private void FontChanged() {
        this.btnStart.setFont(this.fontNormal);
        this.btnStop.setFont(this.fontNormal);
        this.btnKrok.setFont(this.fontNormal);
        this.btnStav.setFont(this.fontNormal);
        this.btnReset.setFont(this.fontNormal);
        this.btnPrechod.setFont(this.fontNormal);
        this.btnRetezec.setFont(this.fontNormal);
        this.btnDFA.setFont(this.fontNormal);
        this.btnEpsilon.setFont(this.fontNormal);
        this.chkDetails.setFont(this.fontNormal);
        this.toolBar.setFont(this.fontNormal);
        this.m_string_window.setFont(this.fontNormal);
        this.m_string_window.m_text.repaint();
        this.m_automat.setFontStates(this.fontAutomata);
        for (State s : this.m_automat.m_states) {
            ((VisualState)s).setFont(this.fontAutomata);
        }
        for (Rule r : this.m_automat.m_rules) {
            ((VisualRule)r).setFont(this.fontAutomata);
        }
        this.m_view.repaint();
    }

    private void BuildLanguageMenu() {
        String langss = ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SupportedLanguages");
        String langssNames = ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SupportedLanguagesNames");
        String[] langs = langss.split(",");
        String[] langsNames = langssNames.split(",");
        GUIHelper.BuildLanguageSubmenus(this.menuLanguages, langs, langsNames, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.menuLanguageActionPerformed(evt);
            }
        });
    }

    private void menuLanguageActionPerformed(ActionEvent evt) {
        JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)evt.getSource();
        GUIHelper.SetLocaleByString(rbmi.getToolTipText());
        this.UpdateMenuLabels();
        this.UpdateToolbarLabels();
        this.m_string_window.UpdateLabels();
        this.m_state_window.UpdateLabels();
        this.m_rule_window.UpdateLabels();
        this.SetTitle(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ApplicationTitle"));
    }

    private void UpdateMenuLabels() {
        this.menuFile.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuFile"));
        this.menuAutomat.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomaton"));
        this.menuSetting.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuSetting"));
        this.menuAbout.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuHelp"));
        this.menuFileExit.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuFileExit"));
        this.menuFileLoad.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuFileOpen"));
        this.menuFileSave.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuFileSave"));
        this.menuAboutAbout.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuHelpAbout"));
        this.menuAboutHelp.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuHelpHelp"));
        this.menuAutomatConvertToEpsilonFree.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatConvertToEpsilonFree"));
        this.menuAutomatCheck.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatCheck"));
        this.menuAutomatConvert.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatConvert"));
        this.menuAutomatString.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatString"));
        this.menuAutomatState.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatState"));
        this.menuAutomatRule.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatRule"));
        this.menuAutomatStep.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatStep"));
        this.menuAutomatReset.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatReset"));
        this.menuAutomatStart.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatStart"));
        this.menuAutomatStop.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuAutomatStop"));
        this.menuFonts.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuFonts"));
        this.menuFontAutomaton.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuFontAutomata"));
        this.menuFontNormal.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuFontNormal"));
        this.menuSettingLineWidth.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuSettingLineWidth"));
        this.menuSettingTimer.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuSettingTimer"));
        this.menuLanguages.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuLanguages"));
        this.detailsAction.putValue("Name", ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("DetailsActionLabel"));
        this.detailsAction.putValue("ShortDescription", ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("DetailsActionTooltip"));
        this.menuSettingSnap.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuSettingSnap"));
        this.menuSettingSnap.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("MenuSettingSnapTooltip"));
    }

    private void UpdateToolbarLabels() {
        this.btnReset.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonReset"));
        this.btnReset.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonResetTip"));
        this.btnStart.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonStart"));
        this.btnStart.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonStartTip"));
        this.btnStop.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonStop"));
        this.btnStop.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonStopTip"));
        this.btnKrok.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonKrok"));
        this.btnKrok.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonKrokTip"));
        this.btnRetezec.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonRetezec"));
        this.btnRetezec.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonRetezecTip"));
        this.btnStav.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonStav"));
        this.btnStav.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonStavTip"));
        this.btnPrechod.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonPrechod"));
        this.btnPrechod.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonPrechodTip"));
        this.btnEpsilon.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonEpsilon"));
        this.btnEpsilon.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonEpsilonTip"));
        this.btnDFA.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonDFA"));
        this.btnDFA.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarButtonDFATip"));
        this.txtDetails.setToolTipText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ToolBarDetailsTextFieldTooltip"));
    }

    private void BuildMenu() {
        this.menu = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuAutomat = new JMenu();
        this.menuSetting = new JMenu();
        this.menuAbout = new JMenu();
        this.menuFileExit = new JMenuItem("", 75);
        this.menuFileExit.addActionListener(this);
        this.menuFileLoad = new JMenuItem();
        this.menuFileLoad.addActionListener(this);
        this.menuFileSave = new JMenuItem();
        this.menuFileSave.addActionListener(this);
        this.menuAboutAbout = new JMenuItem();
        this.menuAboutAbout.addActionListener(this);
        this.menuAboutHelp = new JMenuItem();
        this.menuAboutHelp.addActionListener(this);
        this.menuLanguages = new JMenu();
        this.menuAutomatConvertToEpsilonFree = new JMenuItem();
        this.menuAutomatConvertToEpsilonFree.addActionListener(this);
        this.menuAutomatCheck = new JMenuItem();
        this.menuAutomatCheck.addActionListener(this);
        this.menuAutomatConvert = new JMenuItem();
        this.menuAutomatConvert.addActionListener(this);
        this.menuAutomatString = new JMenuItem();
        this.menuAutomatString.addActionListener(this);
        this.menuAutomatState = new JMenuItem();
        this.menuAutomatState.addActionListener(this);
        this.menuAutomatRule = new JMenuItem();
        this.menuAutomatRule.addActionListener(this);
        this.menuAutomatStep = new JMenuItem();
        this.menuAutomatStep.addActionListener(this);
        this.menuAutomatReset = new JMenuItem();
        this.menuAutomatReset.addActionListener(this);
        this.menuAutomatStart = new JMenuItem();
        this.menuAutomatStart.addActionListener(this);
        this.menuAutomatStop = new JMenuItem();
        this.menuAutomatStop.addActionListener(this);
        this.menuAutomat.addSeparator();
        this.menuAutomat.add(this.menuAutomatReset);
        this.menuAutomat.addSeparator();
        this.menuAutomat.add(this.menuAutomatStart);
        this.menuAutomat.add(this.menuAutomatStop);
        this.menuAutomat.add(this.menuAutomatStep);
        this.menuAutomat.addSeparator();
        this.menuAutomat.add(this.menuAutomatString);
        this.menuAutomat.add(this.menuAutomatState);
        this.menuAutomat.add(this.menuAutomatRule);
        this.menuAutomat.addSeparator();
        this.menuAutomat.add(this.menuAutomatCheck);
        this.menuAutomat.add(this.menuAutomatConvert);
        this.menuAutomat.add(this.menuAutomatConvertToEpsilonFree);
        this.menuFile.add(this.menuFileLoad);
        this.menuFile.add(this.menuFileSave);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuAbout.add(this.menuAboutHelp);
        this.menuAbout.add(this.menuAboutAbout);
        this.menuAbout.add(this.menuLanguages);
        this.menuFonts = new JMenu();
        this.menuFontAutomaton = new JMenuItem();
        this.menuFontAutomaton.addActionListener(this);
        this.menuFontNormal = new JMenuItem();
        this.menuFontNormal.addActionListener(this);
        this.menuFonts.add(this.menuFontNormal);
        this.menuFonts.add(this.menuFontAutomaton);
        this.menuSettingLineWidth = new JMenuItem();
        this.menuSettingLineWidth.addActionListener(this);
        this.menuSettingTimer = new JMenuItem();
        this.menuSettingTimer.addActionListener(this);
        this.menuSettingDetails = new JCheckBoxMenuItem(this.detailsAction);
        this.detailsAction.putValue("SwingSelectedKey", this.m_details);
        this.menuSettingSnap = new JCheckBoxMenuItem();
        this.menuSetting.add(this.menuFonts);
        this.menuSetting.add(this.menuSettingLineWidth);
        this.menuSetting.add(this.menuSettingTimer);
        this.menuSetting.add(this.menuSettingDetails);
        this.menuSetting.add(this.menuSettingSnap);
        this.menu.add(this.menuFile);
        this.menu.add(this.menuAutomat);
        this.menu.add(this.menuSetting);
        this.menu.add(this.menuAbout);
        this.UpdateMenuLabels();
        this.setJMenuBar(this.menu);
    }

    private JButton add2ToolBar(JButton button, String caption, String tooltip, JToolBar toolbar) {
        button = new JButton(caption);
        button.setToolTipText(tooltip);
        toolbar.add(button);
        button.addActionListener(this);
        return button;
    }

    private JButton add2ToolBar(JButton button, JToolBar toolbar) {
        button = new JButton();
        toolbar.add(button);
        button.addActionListener(this);
        return button;
    }

    private void BuildToolBar() {
        this.toolBar = new JToolBar("ToolBar");
        this.btnReset = this.add2ToolBar(this.btnReset, this.toolBar);
        this.btnStart = this.add2ToolBar(this.btnStart, this.toolBar);
        this.btnStop = this.add2ToolBar(this.btnStop, this.toolBar);
        this.btnKrok = this.add2ToolBar(this.btnKrok, this.toolBar);
        this.toolBar.addSeparator();
        this.btnRetezec = this.add2ToolBar(this.btnRetezec, this.toolBar);
        this.btnStav = this.add2ToolBar(this.btnStav, this.toolBar);
        this.btnPrechod = this.add2ToolBar(this.btnPrechod, this.toolBar);
        this.toolBar.addSeparator();
        this.btnEpsilon = this.add2ToolBar(this.btnEpsilon, this.toolBar);
        this.btnDFA = this.add2ToolBar(this.btnDFA, this.toolBar);
        this.chkDetails = new JCheckBox(this.detailsAction);
        this.toolBar.add(this.chkDetails);
        this.chkDetails.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkDetails.setMargin(new Insets(0, 0, 0, 0));
        this.txtDetails = new JTextField();
        this.txtDetails.setEditable(false);
        this.UpdateToolbarLabels();
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "First");
    }

    public static void main(String[] args) {
        GUIHelper.SetSystemLookAndFeel();
        MainFrame srv = new MainFrame();
        srv.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuFileExit) {
            this.dispatchEvent(new WindowEvent(this.isApplet() ? null : (JFrame)JFrame.class.cast(this), 201));
        } else if (e.getSource() == this.menuAboutAbout) {
            this.showAbout();
        } else if (e.getSource() == this.menuAutomatConvert) {
            this.convertToDFA();
        } else if (e.getSource() == this.btnStav) {
            this.ToggleState();
        } else if (e.getSource() == this.btnPrechod) {
            this.ToggleRule();
        } else if (e.getSource() == this.menuAutomatConvertToEpsilonFree) {
            this.convertToEpsilonFree();
        } else if (e.getSource() == this.menuAutomatString) {
            this.m_string_window.setVisible(true);
        } else if (e.getSource() == this.menuAutomatState) {
            this.m_state_window.setVisible(true);
        } else if (e.getSource() == this.menuAutomatRule) {
            this.m_rule_window.setVisible(true);
        } else if (e.getSource() == this.menuAutomatStep) {
            this.step();
        } else if (e.getSource() == this.menuAutomatStart) {
            this.startTimer();
        } else if (e.getSource() == this.menuAutomatStop) {
            this.stopTimer();
        } else if (e.getSource() == this.menuAutomatReset) {
            this.reset();
        } else if (e.getSource() == this.menuAboutHelp) {
            this.m_help_window.setVisible(true);
        } else if (e.getSource() == this.menuFileLoad) {
            this.load();
        } else if (e.getSource() == this.menuFileSave) {
            this.save();
        } else if (e.getSource() == this.m_timer) {
            this.step();
        } else if (e.getSource() == this.btnStart) {
            this.startTimer();
        } else if (e.getSource() == this.btnKrok) {
            this.step();
        } else if (e.getSource() == this.btnEpsilon) {
            this.convertToEpsilonFree();
        } else if (e.getSource() == this.btnStop) {
            this.stopTimer();
        } else if (e.getSource() == this.btnReset) {
            this.reset();
        } else if (e.getSource() == this.btnRetezec) {
            this.m_string_window.setVisible(true);
        } else if (e.getSource() == this.btnDFA) {
            this.convertToDFA();
        } else if (e.getSource() == this.menuAutomatCheck) {
            this.check();
        } else if (e.getSource() == this.menuFontNormal) {
            this.menuFontChoose(FontTypes.Normal);
        } else if (e.getSource() == this.menuFontAutomaton) {
            this.menuFontChoose(FontTypes.Automata);
        } else if (e.getSource() == this.menuSettingLineWidth) {
            this.setLineWidthByDialog();
        } else if (e.getSource() == this.menuSettingTimer) {
            this.setTimerByDialog();
        }
    }

    public void setLineWidthByDialog() {
        JOptionPane dlg = new JOptionPane();
        String inputValue = "";
        inputValue = (String)JOptionPane.showInputDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SetLineWidthDialogQuestion"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SetLineWidthDialogTitle"), 3, new ImageIcon(), null, this.m_lineWidth);
        if (inputValue != null && !inputValue.isEmpty()) {
            try {
                this.m_lineWidth = Integer.parseInt(inputValue);
                this.m_automat.setLineWidth(this.m_lineWidth);
                this.m_view.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void convertToDFA() {
        if (this.detailsAction.getValue("SwingSelectedKey").toString().equals("true")) {
            if (this.m_automat.GetStates().isEmpty()) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ErrEmptyAutomatonMessage"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ErrEmptyAutomatonTitle"), 1);
                return;
            }
            this.m_automat.ConvertToEpsilonFree();
            this.RefreshView();
            JDetAlgDialog dlg = new JDetAlgDialog((Frame)this, this.m_automat, this.m_view);
            dlg.setSnappingToMainWindow(this.SnappingAllowed());
            dlg.setNormalFont(this.fontNormal);
            dlg.updateFonts(dlg.getNormalFont());
            dlg.setVisible(true);
            this.RefreshView();
        } else if (JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("DFAConversionQuestion")) == 0) {
            this.m_automat.ConvertToEpsilonFree();
            this.m_automat.ConvertEpsilonFreeToDFA();
            this.RefreshView();
        }
    }

    public void convertToEpsilonFree() {
        if (JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("EpsilonRemovalQuestion")) == 0) {
            if (!this.m_automat.CheckEpsilonFreeness(null)) {
                this.m_automat.ConvertToEpsilonFree();
            } else {
                JOptionPane.showMessageDialog(this, "Automat ji\u017e je bez epsilon p\u0159echod\u016f!", "MessageEpsilonFreeAutomat", 1);
            }
            this.RefreshView();
        }
    }

    public void showAbout() {
        JDialog dlg = new JDialog(this.isApplet() ? null : (JFrame)JFrame.class.cast(this), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("AboutDialogTitle"), false);
        dlg.setSize(400, 300);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JAboutDialog about = new JAboutDialog();
        about.setAlignmentX(0.5f);
        panel.add((Component)about, "Center");
        JButton ok = new JButton(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((JDialog)((JRootPane)((JLayeredPane)((JPanel)((JPanel)((JButton)evt.getSource()).getParent()).getParent()).getParent()).getParent()).getParent()).dispose();
            }
        });
        ok.setAlignmentX(0.5f);
        panel.add((Component)ok, "Center");
        about.setLabelAppName(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ApplicationTitle"));
        about.setLabelVersion("0.9.1");
        dlg.getContentPane().add(panel);
        dlg.pack();
        dlg.setVisible(true);
    }

    public void SelectState(VisualState s) {
        this.m_state_window.SetState(s);
    }

    public void SelectRule(VisualRule r) {
        this.m_rule_window.SetRule(r);
    }

    public void ToggleState() {
        this.m_state_window.setSnappingToMainWindow(this.SnappingAllowed());
        this.m_state_window.setVisible(!this.m_state_window.isVisible());
    }

    public void ToggleRule() {
        this.m_rule_window.setSnappingToMainWindow(this.SnappingAllowed());
        this.m_rule_window.setVisible(!this.m_rule_window.isVisible());
    }

    public void RefreshView() {
        this.m_scroll.repaint();
        this.m_view.repaint();
    }

    private void step() {
        if (this.m_automat != null) {
            this.m_automat.SetString(this.m_string_window.GetString());
            if (!this.m_automat_running) {
                this.reset();
                return;
            }
            this.m_automat.Step();
            this.m_string_window.SetString(this.m_automat.GetString());
            this.RefreshView();
            if (this.m_automat.IsDone() || !this.m_automat.IsActive()) {
                this.m_timer.stop();
                if (this.m_automat.IsAtFinalState()) {
                    this.m_automat.ClearRulesActivity();
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("AcceptedSentence"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("AcceptedSentenceTitle"), 1);
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RejectedSentence"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("RejectedSentenceTitle"), 1);
                }
                this.m_automat_running = false;
            }
        }
    }

    private void startTimer() {
        this.m_timer.start();
    }

    private void stopTimer() {
        this.m_timer.stop();
    }

    private void reset() {
        this.m_automat.clearSelection();
        this.m_automat.Reset();
        this.RefreshView();
        this.m_automat_running = true;
    }

    private void save() {
        int returnVal;
        JFileChooser dlg = new JFileChooser();
        dlg.addChoosableFileFilter(FMFileFilter.getFileFilter());
        if (this.initFileChooserFilePath != null && !this.initFileChooserFilePath.isEmpty()) {
            dlg.setCurrentDirectory(new File(this.initFileChooserFilePath));
        }
        if ((returnVal = dlg.showSaveDialog(this)) == 0) {
            String filename = dlg.getSelectedFile().getAbsolutePath();
            if (dlg.getSelectedFile().getName().lastIndexOf(46) == -1 && !dlg.getSelectedFile().getName().isEmpty()) {
                filename = filename.concat(".xml");
            }
            if (!this.m_automat.Save(filename)) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ErrSaveFile"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ErrMessageDialogTitle"), 0);
            } else {
                this.initFileChooserFilePath = dlg.getSelectedFile().getPath();
                this.m_view.repaint();
            }
        }
    }

    private void load() {
        JFileChooser dlg = new JFileChooser();
        if (this.initFileChooserFilePath != null && !this.initFileChooserFilePath.isEmpty()) {
            dlg.setCurrentDirectory(new File(this.initFileChooserFilePath));
        }
        dlg.addChoosableFileFilter(FMFileFilter.getFileFilter());
        int returnVal = dlg.showOpenDialog(this);
        if (returnVal == 0) {
            if (!this.m_automat.Load(dlg.getSelectedFile().getAbsolutePath())) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ErrOpenFile"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("ErrMessageDialogTitle"), 0);
            } else {
                this.initFileChooserFilePath = dlg.getSelectedFile().getPath();
                this.m_view.repaint();
            }
        }
    }

    public void check() {
        HashSet<State> states = new HashSet<State>();
        HashSet<Rule> rules = new HashSet<Rule>();
        boolean ret = this.m_automat.CheckDFA(states, rules);
        if (!ret) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("FailNotDFA"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("FailMessageDialogTitle"), 1);
            this.m_automat.clearSelection();
            this.m_automat.selectStates(states);
            this.m_automat.selectRules(rules);
            this.RefreshView();
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SuccessItIsDFA"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SuccessMessageDialogTitle"), 1);
        }
    }

    private void setTimerByDialog() {
        JOptionPane dlg = new JOptionPane();
        String inputValue = "";
        inputValue = (String)JOptionPane.showInputDialog(this, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SetTimerDialogQuestion"), ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("SetTimerDialogTitle"), 3, new ImageIcon(), null, this.m_timer.getDelay());
        if (inputValue != null && !inputValue.isEmpty()) {
            try {
                this.m_timer.setDelay(Integer.parseInt(inputValue));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isApplet() {
        return MainFrame.class.getSuperclass().equals(JApplet.class);
    }

    public void SetTitle(String s) {
        if (!this.isApplet()) {
            try {
                Method m = MainFrame.class.getSuperclass().getMethod("setTitle", String.class);
                if (m != null) {
                    m.invoke((Object)this, s);
                }
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void SetResizable(boolean r) {
        if (!this.isApplet()) {
            try {
                Method m = MainFrame.class.getSuperclass().getMethod("setResizable", Boolean.TYPE);
                if (m != null) {
                    m.invoke((Object)this, r);
                }
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void SetDefaultCloseOperation() {
        if (!this.isApplet()) {
            try {
                Method m = MainFrame.class.getSuperclass().getMethod("setDefaultCloseOperation", Integer.TYPE);
                if (m != null) {
                    Field f = MainFrame.class.getField("EXIT_ON_CLOSE");
                    m.invoke((Object)this, f.getInt(this));
                }
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void pack() {
        if (!this.isApplet()) {
            try {
                Method m = MainFrame.class.getSuperclass().getMethod("pack", new Class[0]);
                if (m != null) {
                    m.invoke((Object)this, new Object[0]);
                }
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean GetDetailsSetting() {
        return this.m_details;
    }

    public boolean SnappingAllowed() {
        return this.menuSettingSnap.isSelected();
    }

    static enum FontTypes {
        Normal,
        Automata;

    }
}

