/*
 * Decompiled with CFR 0.152.
 */
package didefom.common;

import didefom.common.FMStorage;
import didefom.common.XMLStorage;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XMLManager {
    private String fileName;
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilder db;
    private Document doc;
    private DOMImplementation di;
    private FMStorage formalModel;

    public XMLManager() {
        try {
            this.db = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    public void parse() {
        this.parse(this.getFileName());
    }

    public void parse(String fn) {
        this.setFileName(fn);
        try {
            this.doc = this.db.parse(new File(this.getFileName()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    public void Load(XMLStorage fm) {
        fm.setManager(this);
        if (this.doc == null) {
            this.parse();
        }
        fm.Load(this.doc);
    }

    public void Save(XMLStorage fm) {
        fm.setManager(this);
        if (this.di == null) {
            this.di = this.db.getDOMImplementation();
        }
        this.doc = this.di.createDocument(null, null, null);
        this.SaveCreatedDocumentIntoFile();
    }

    protected void InitialStorage() {
    }

    protected void StoreFormalModel(FMStorage fm) {
    }

    protected void StoreFomalModel() {
        this.StoreFormalModel(this.getFormalModel());
    }

    protected void SaveCreatedDocumentIntoFile() {
        DOMSource ds = new DOMSource(this.doc);
        StreamResult sr = new StreamResult(new File(this.getFileName()));
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer trans = tf.newTransformer();
            trans.transform(ds, sr);
        }
        catch (TransformerConfigurationException ex) {
            ex.printStackTrace();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setDocument(Document document) {
        this.doc = document;
    }

    public FMStorage getFormalModel() {
        return this.formalModel;
    }

    public void setFormalModel(FMStorage formalModel) {
        this.formalModel = formalModel;
    }
}

