/*
 * Decompiled with CFR 0.152.
 */
package didefom.DKASimulation;

import didefom.DKASimulation.MainFrame;
import didefom.DKASimulation.VisualState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class StateWindow
extends JDialog
implements ActionListener {
    JLabel m_title;
    JTextField m_text;
    JCheckBox m_isFirst;
    JCheckBox m_isFinal;
    JCheckBox m_isActive;
    JButton m_ok;
    JButton m_storno;
    JLabel m_startLabel;
    JLabel m_finalLabel;
    JLabel m_activeLabel;
    VisualState m_pState = null;
    MainFrame m_parent;

    public StateWindow(MainFrame parent) {
        super(parent, ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowTitle"), false);
        this.setSize(200, 220);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        this.m_title = new JLabel(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowNameLabel"));
        panel.add(this.m_title);
        this.m_text = new JTextField();
        panel.add(this.m_text);
        this.m_startLabel = new JLabel(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowStartingLabel"));
        panel.add(this.m_startLabel);
        this.m_isFirst = new JCheckBox();
        panel.add(this.m_isFirst);
        this.m_finalLabel = new JLabel(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowFinalLabel"));
        panel.add(this.m_finalLabel);
        this.m_isFinal = new JCheckBox();
        panel.add(this.m_isFinal);
        this.m_activeLabel = new JLabel(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowActive"));
        panel.add(this.m_activeLabel);
        this.m_isActive = new JCheckBox();
        panel.add(this.m_isActive);
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 2));
        btnpanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        btnpanel.add(Box.createHorizontalGlue());
        this.m_ok = new JButton(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("OK"));
        this.m_ok.addActionListener(this);
        btnpanel.add(this.m_ok);
        btnpanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.m_storno = new JButton(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("Cancel"));
        this.m_storno.addActionListener(this);
        btnpanel.add(this.m_storno);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)btnpanel, "Last");
        this.m_parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_ok) {
            if (this.m_pState != null) {
                this.m_pState.SetText(this.m_text.getText());
                this.m_pState.SetFinal(this.m_isFinal.isSelected());
                this.m_pState.SetFirst(this.m_isFirst.isSelected());
                this.m_pState.SetActive(this.m_isActive.isSelected());
            }
            this.m_parent.RefreshView();
            this.setVisible(false);
        } else if (e.getSource() == this.m_storno) {
            this.m_pState = null;
            this.setVisible(false);
        }
    }

    public void SetState(VisualState s) {
        if (this.m_pState != null) {
            this.m_pState.SetText(this.m_text.getText());
            this.m_pState.SetFinal(this.m_isFinal.isSelected());
            this.m_pState.SetFirst(this.m_isFirst.isSelected());
            this.m_pState.SetActive(this.m_isActive.isSelected());
        }
        this.m_pState = s;
        if (s != null) {
            this.m_text.setText(s.GetText());
            this.m_isFinal.setSelected(s.IsFinal());
            this.m_isFirst.setSelected(s.IsFirst());
            this.m_isActive.setSelected(s.IsActive());
        } else {
            this.m_text.setText("");
            this.m_isFinal.setSelected(false);
            this.m_isFirst.setSelected(false);
            this.m_isActive.setSelected(false);
        }
    }

    public void UpdateLabels() {
        this.setTitle(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowTitle"));
        this.m_title.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowNameLabel"));
        this.m_startLabel.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowStartingLabel"));
        this.m_finalLabel.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowFinalLabel"));
        this.m_activeLabel.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("StateWindowActive"));
        this.m_ok.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("OK"));
        this.m_storno.setText(ResourceBundle.getBundle("didefom/DKASimulation/DKASimulation").getString("Cancel"));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Point pt = this.getParent().getLocation();
            this.setLocation(pt.x + this.getParent().getWidth(), pt.y + this.getParent().getHeight() - this.getHeight());
        }
        super.setVisible(b);
    }
}

