program scanner(input, output);

{
This program implements the scanner whose pseudo-code precedes Example 4.2. It reads an input string from the standard input. The input string is terminated with #.
}

type
  symbols   = Char;
  symbolset = set of symbols;

var
  ch       : symbols;   {the current read character}
  previous : Boolean;   {auxiliary variable for pushing ch back to the input}
  lu       : String;    {lexical unit}

const
  letters   : symbolset = ['a'..'z'];
  digits    : symbolset = ['0'..'9'];
  BLANK     : symbolset = [' ', #10, #13];
  ENDMARKER : symbols   = '#';

procedure GETSYM;    {read a character from the input while supporting push-back}
begin
  if previous then
    previous := false
  else
    read(ch)
end;

procedure UNGETSYM;     {pushing the last read symbol back to the input}
begin                   {so it is read in the next application of GETSYM}
  if not previous then
    previous := true
  else                  {this implementation does not support double push-back}
    writeln('internal error')
end;

procedure IDENTIFIER;
begin
  repeat
    lu := lu + ch;	{concatenate the string in lu and the character in ch}
    GETSYM
  until not ((ch in letters) or (ch in digits)); {exit when a non-alphanumeric
                                                  symbol is read}
  UNGETSYM;           {the non-alphanumeric symbol in ch is pushed back 
                       onto the standard input}
  writeln('identifier ', lu , ' is recognized');
end;

procedure NUMBER;
begin
  repeat
    lu := lu + ch;	{concatenate the string in lu and the character in ch}
    GETSYM
  until not (ch in digits); 	{exit when a non-numeric symbol is read}
  if ch <> '.' then
  begin
    UNGETSYM; 	{the non-numeric symbol in ch is pushed back onto 
                the standard input}
    writeln('integer ', lu, ' is recognized');
  end
  else
  begin
    repeat
      lu := lu + ch;	{concatenate the string in lu and the character in ch}
      GETSYM
    until not (ch in digits); 	{exit when a non-numeric symbol is read}
    UNGETSYM;	{the non-numeric symbol in ch is pushed back onto 
                the standard input}
    writeln('real number ', lu, ' is recognized');
  end
end;

procedure SCANNER;
begin
  repeat
    GETSYM
  until not (ch in BLANK);   {continue when a non-blank character is read}
  if ch <> ENDMARKER then    {SCANNER has not reached the end marker}
  begin
    lu := '';
    case ch of
      'a'..'z':  IDENTIFIER;   {perform procedure IDENTIFIER}
      '0'..'9':  NUMBER;       {perform procedure NUMBER}
      otherwise writeln('lexical error')
    end
  end
end;


begin
  while ch <> ENDMARKER do    {scan the standard input until the first 
                               end marker denoted by # is read}
    SCANNER;
end.
